/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql.functions;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;

public abstract class ArrayContains
extends SqlFunction {
    public ArrayContains(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of((int)2);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List operands = callBinding.getCall().getOperandList();
        SqlNode operand1 = (SqlNode)operands.get(0);
        SqlNode operand2 = (SqlNode)operands.get(1);
        if (operand1.getKind() == SqlKind.IDENTIFIER) {
            SqlBasicCall valuesCall;
            boolean literalMatch;
            if (operand2.getKind() == SqlKind.LITERAL) {
                return true;
            }
            if (operand2.getKind() == SqlKind.ROW && (literalMatch = Arrays.stream((valuesCall = (SqlBasicCall)operand2).getOperands()).allMatch(op -> op.getKind() == SqlKind.LITERAL))) {
                return true;
            }
        }
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            RelDataType nodeType = validator.deriveType(scope, operand);
            validator.setValidatedNodeType(operand, nodeType);
        }
        return this.validateOperands(validator, scope, call);
    }
}

