/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.function.Parameter;
import com.jayway.jsonpath.internal.function.PathFunction;
import com.jayway.jsonpath.internal.function.PathFunctionFactory;
import com.jayway.jsonpath.internal.function.latebinding.JsonLateBindingValue;
import com.jayway.jsonpath.internal.function.latebinding.PathLateBindingValue;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import com.jayway.jsonpath.internal.path.PathToken;
import java.util.List;

public class FunctionPathToken
extends PathToken {
    private final String functionName;
    private final String pathFragment;
    private final List<Parameter> functionParams;

    public FunctionPathToken(String pathFragment, List<Parameter> parameters) {
        this.pathFragment = pathFragment + (parameters != null && parameters.size() > 0 ? "(...)" : "()");
        if (null != pathFragment) {
            this.functionName = pathFragment;
            this.functionParams = parameters;
        } else {
            this.functionName = null;
            this.functionParams = null;
        }
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        PathFunction pathFunction = PathFunctionFactory.newFunction(this.functionName);
        this.evaluateParameters(currentPath, parent, model, ctx);
        Object result = pathFunction.invoke(currentPath, parent, model, ctx, this.functionParams);
        ctx.addResult(currentPath + "." + this.functionName, parent, result);
        if (!this.isLeaf()) {
            this.next().evaluate(currentPath, parent, result, ctx);
        }
    }

    private void evaluateParameters(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (null != this.functionParams) {
            for (Parameter param : this.functionParams) {
                if (param.hasEvaluated()) continue;
                switch (param.getType()) {
                    case PATH: {
                        param.setLateBinding(new PathLateBindingValue(param.getPath(), ctx.rootDocument(), ctx.configuration()));
                        param.setEvaluated(true);
                        break;
                    }
                    case JSON: {
                        param.setLateBinding(new JsonLateBindingValue(ctx.configuration().jsonProvider(), param));
                        param.setEvaluated(true);
                    }
                }
            }
        }
    }

    @Override
    public boolean isTokenDefinite() {
        return true;
    }

    @Override
    public String getPathFragment() {
        return "." + this.pathFragment;
    }
}

