/*
 * Decompiled with CFR 0.152.
 */
package tr.view.process;

import au.com.trgtd.tr.appl.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.context.Context;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.model.future.Future;
import tr.model.information.Information;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.prefs.projects.ProjectsPrefs;
import tr.runtime.Email;
import tr.runtime.Open;
import tr.swing.TRButton;
import tr.swing.TRComboBox;
import tr.swing.TRLabel;
import tr.swing.TRTextField;
import tr.swing.date.field.DateField;
import tr.swing.editorpane.HyperEditorPane;
import tr.swing.mig.MTextArea;
import tr.swing.time.HourSpinner;
import tr.swing.time.MinuteSpinner;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.ViewUtils;
import tr.view.action.StatusComboBoxModel;
import tr.view.action.StatusEnum;
import tr.view.action.prefs.ActionPrefs;
import tr.view.action.recurrence.NewRecurrenceWizard;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizard;
import tr.view.contexts.ContextsComboBox;
import tr.view.contexts.ContextsComboBoxModel;
import tr.view.criteria.CriterionComboBoxModel;
import tr.view.process.ProcessCookie;
import tr.view.process.ProcessNode;
import tr.view.process.ProcessNodeProvider;
import tr.view.project.chooser.ProjectChooser;
import tr.view.project.chooser.ProjectChooserDialog;
import tr.view.topics.TopicsComboBox;
import tr.view.topics.TopicsComboBoxModel;

public class ProcessPanel
extends JPanel
implements Observer,
ProcessCookie {
    private ActionListener actionListenerThoughtTopic;
    private FocusListener focusListenerThoughtText;
    private ActionListener actionListenerDelete;
    private ActionListener actionListenerSomeday;
    private ActionListener actionListenerReference;
    private HyperlinkListener hyperlinkListener;
    private ActionListener actionListenerEmail;
    private PropertyChangeListener doneDatePropertyChangeListener;
    private PropertyChangeListener scheduledDateListener;
    private ActionListener doneCheckBoxActionListener;
    private ItemListener statusListener;
    private ActionListener recurrenceButtonListener;
    private ActionListener addToProjectButtonListener;
    private ActionListener newProjectCheckBoxListener;
    private FocusListener newProjectTextFocusListener;
    private ActionListener actionableYesListener;
    private ActionListener actionableNoListener;
    private PreferenceChangeListener prefsChangeListener;
    private Observer criteriaObserver;
    private Observer thoughtObserver = new Observer(){

        public void update(Observable observable, Object arg) {
            assert (observable instanceof Thought);
            if (arg == Thought.Change.DESCRIPTION) {
                if (!ProcessPanel.this.thoughtText.getText().equals(ProcessPanel.this.thought.getDescription())) {
                    ProcessPanel.this.thoughtText.setText(ProcessPanel.this.thought.getDescription());
                }
            } else if (arg == Thought.Change.TOPIC) {
                ProcessPanel.this.topicCombo.setSelectedItem(ProcessPanel.this.thought.getTopic());
                ProcessPanel.this.thoughtText.setForeground(ProcessPanel.this.thought.getTopic().getForeground());
                ProcessPanel.this.thoughtText.setBackground(ProcessPanel.this.thought.getTopic().getBackground());
            }
        }
    };
    private MigLayout statusLayoutA1 = new MigLayout(this.getMIGCons("insets 0px"), "0[grow]0", "0[]0");
    private MigLayout statusLayoutA2 = new MigLayout(this.getMIGCons("insets 0px"), "0[grow]0", "0[]2:2:2[]0");
    private MigLayout statusLayoutM1 = new MigLayout(this.getMIGCons("insets 0px"), "0[grow]0", "0[top]0");
    private MigLayout statusLayoutM2 = new MigLayout(this.getMIGCons("insets 0px"), "0[grow]0", "0[top]2[top]0");
    private static final Logger LOG = Logger.getLogger("tr.view.process");
    private static final boolean DEBUG_MIG_LAYOUT = false;
    private static final String LBL_TOPIC = ProcessPanel.getMsg("LBL_Topic");
    private static final String LBL_ACTIONABLE = ProcessPanel.getMsg("LBL_Actionable");
    private static final String LBL_YES = ProcessPanel.getMsg("LBL_Yes");
    private static final String LBL_NO = ProcessPanel.getMsg("LBL_No");
    private static final String LBL_NOT_ACTIONABLE = ProcessPanel.getMsg("LBL_NotActionable");
    private static final String LBL_DELETE = ProcessPanel.getMsg("LBL_Delete");
    private static final String LBL_SOMEDAY = ProcessPanel.getMsg("LBL_SomedayMaybe");
    private static final String LBL_REFERENCE = ProcessPanel.getMsg("LBL_Reference");
    private static final String LBL_TICKLE_DATE = ProcessPanel.getMsg("LBL_TickleDate");
    private static final String LBL_SUCCESS = ProcessPanel.getMsg("LBL_SuccessfulOutcome");
    private static final String LBL_NEXT_ACTION = ProcessPanel.getMsg("LBL_NextAction");
    private static final String LBL_DESCRIPTION = ProcessPanel.getMsg("LBL_Description");
    private static final String LBL_CONTEXT = ProcessPanel.getMsg("LBL_Context");
    private static final String LBL_TIME = ProcessPanel.getMsg("LBL_Time");
    private static final String LBL_ENERGY = ProcessPanel.getMsg("LBL_Energy");
    private static final String LBL_PRIORITY = ProcessPanel.getMsg("LBL_Priority");
    private static final String LBL_STATUS = ProcessPanel.getMsg("LBL_Status");
    private static final String LBL_DUE_DATE = ProcessPanel.getMsg("LBL_DueDate");
    private static final String LBL_START_DATE = ProcessPanel.getMsg("LBL_StartDate");
    private static final String LBL_DURATION = ProcessPanel.getMsg("LBL_Duration");
    private static final String LBL_RECURRENCE = ProcessPanel.getMsg("LBL_Recurrence");
    private static final String LBL_CREATE = ProcessPanel.getMsg("LBL_Create");
    private static final String LBL_MODIFY = ProcessPanel.getMsg("LBL_Modify");
    private static final String LBL_DELEGATE = ProcessPanel.getMsg("LBL_Delegate");
    private static final String LBL_EMAIL = ProcessPanel.getMsg("LBL_Email");
    private static final String LBL_FOLLOWUP = ProcessPanel.getMsg("LBL_Followup");
    private static final String LBL_PROJECT = ProcessPanel.getMsg("LBL_Project");
    private static final String LBL_ADD_TO_PROJECT = ProcessPanel.getMsg("LBL_AddToProject");
    private static final String LBL_NEW_PROJECT = ProcessPanel.getMsg("LBL_NewProject");
    private static final String LBL_DONE = ProcessPanel.getMsg("LBL_Done");
    private static final String LBL_CREATED = ProcessPanel.getMsg("LBL_Created");
    private static final String LBL_NOTES = ProcessPanel.getMsg("LBL_Notes");
    private static final Dimension SIZE_DELEGATE_TEXT = new Dimension(200, 23);
    private static final Dimension SIZE_PROJECT_BUTTON = new Dimension(20, 20);
    private static final Dimension SIZE_NOTES_EDITOR = new Dimension(100, 62);
    private static final TRLabel fillerLabel1 = new TRLabel("");
    private static final TRLabel fillerLabel2 = new TRLabel("");
    private static final TRLabel fillerLabel3 = new TRLabel("");
    private static final TRLabel fillerLabel4 = new TRLabel("");
    private final Data data;
    private final ProcessNodeProvider processNodeProvider;
    private final ProcessNode processNode;
    private final Project projects;
    private final Project singleActions;
    private final Manager<Thought> thoughtManager;
    private final Manager<Information> referenceManager;
    private final Manager<Future> somedayManager;
    private Thought thought;
    private Action action;
    private Project addToProject;
    private Project recurrenceProject;
    private ProjectChooser projectChooser;
    private TRLabel thoughtLabel;
    private TRTextField thoughtText;
    private TRLabel topicLabel;
    private JComboBox topicCombo;
    private ButtonGroup actionableButtonGroup;
    private JRadioButton actionableYesRadioButton;
    private JRadioButton actionableNoRadioButton;
    private ButtonGroup notActionableButtonGroup;
    private JRadioButton deleteRadioButton;
    private JRadioButton somedayRadioButton;
    private JRadioButton referenceRadioButton;
    private TRLabel tickleDateLabel;
    private DateField tickleDateField;
    private TRLabel notesLabel;
    private HyperEditorPane notesField;
    private TRLabel notesLabelNA;
    private HyperEditorPane notesFieldNA;
    private TRLabel actionableLabel;
    private TRLabel successLabel;
    private TRLabel actionLabel;
    private TRLabel projectLabel;
    private MTextArea successText;
    private TRLabel descriptionLabel;
    private TRTextField descriptionText;
    private TRLabel contextLabel;
    private JComboBox contextCombo;
    private TRLabel timeLabel;
    private JComboBox timeCombo;
    private TRLabel energyLabel;
    private JComboBox energyCombo;
    private TRLabel priorityLabel;
    private JComboBox priorityCombo;
    private JComboBox statusCombo;
    private TRLabel statusLabel;
    private TRLabel dueDateLabel;
    private DateField dueDateField;
    private TRLabel startDateLabel;
    private DateField startDateField;
    private DateField scheduledDateField;
    private HourSpinner scheduledHourSpinner;
    private MinuteSpinner scheduledMinuteSpinner;
    private TRLabel durationLabel;
    private HourSpinner durationHourSpinner;
    private MinuteSpinner durationMinuteSpinner;
    private TRButton recurrenceButton;
    private TRLabel recurrenceLabel;
    private TRLabel delegatedToLabel;
    private TRTextField delegatedToField;
    private TRButton emailButton;
    private TRLabel followupLabel;
    private DateField followupDateField;
    private JCheckBox doneCheckBox;
    private DateField doneDateField;
    private TRLabel createdDateLabel;
    private DateField createdDateField;
    private JCheckBox newProjectCheck;
    private TRTextField newProjectField;
    private TRButton addToProjectButton;
    private TRLabel addToProjectLabel;
    private TRTextField addToProjectField;
    private JPanel panelChoice;
    private JPanel panelNotActionable;
    private JPanel panelActionable;
    private JPanel panelAction;
    private JPanel statusPanel;

    public ProcessPanel(ProcessNodeProvider processNodeProvider) {
        this.processNodeProvider = processNodeProvider;
        this.processNode = new ProcessNode(this);
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        this.projects = this.data.getRootProjects();
        this.singleActions = this.data.getRootActions();
        this.referenceManager = this.data.getInformationManager();
        this.somedayManager = this.data.getFutureManager();
        this.thoughtManager = this.data.getThoughtManager();
        this.thoughtManager.addObserver((Observer)this);
        this.initComponents();
        this.initPanel();
        this.initModel();
    }

    private void enableFields(boolean b) {
        this.thoughtLabel.setEnabled(b);
        this.thoughtText.setEnabled(b);
        this.topicLabel.setEnabled(b);
        this.topicCombo.setEnabled(b);
        this.actionableYesRadioButton.setEnabled(b);
        this.actionableNoRadioButton.setEnabled(b);
        this.deleteRadioButton.setEnabled(b);
        this.somedayRadioButton.setEnabled(b);
        this.referenceRadioButton.setEnabled(b);
        this.tickleDateLabel.setEnabled(b);
        this.tickleDateField.setEnabled(b);
        this.notesLabel.setEnabled(b);
        this.notesField.setEnabled(b);
        this.notesLabelNA.setEnabled(b);
        this.notesFieldNA.setEnabled(b);
        this.actionableLabel.setEnabled(b);
        this.successLabel.setEnabled(b);
        this.successText.setEnabled(b);
        this.actionLabel.setEnabled(b);
        this.descriptionLabel.setEnabled(b);
        this.descriptionText.setEnabled(b);
        this.contextLabel.setEnabled(b);
        this.contextCombo.setEnabled(b);
        this.timeLabel.setEnabled(b);
        this.timeCombo.setEnabled(b);
        this.energyLabel.setEnabled(b);
        this.energyCombo.setEnabled(b);
        this.priorityLabel.setEnabled(b);
        this.priorityCombo.setEnabled(b);
        this.statusCombo.setEnabled(b);
        this.statusLabel.setEnabled(b);
        this.dueDateLabel.setEnabled(b);
        this.dueDateField.setEnabled(b);
        this.startDateLabel.setEnabled(b);
        this.startDateField.setEnabled(b);
        this.scheduledDateField.setEnabled(b);
        this.scheduledHourSpinner.setEnabled(b);
        this.scheduledMinuteSpinner.setEnabled(b);
        this.durationLabel.setEnabled(b);
        this.durationHourSpinner.setEnabled(b);
        this.durationMinuteSpinner.setEnabled(b);
        this.recurrenceButton.setEnabled(b);
        this.recurrenceLabel.setEnabled(b);
        this.delegatedToLabel.setEnabled(b);
        this.delegatedToField.setEnabled(b);
        this.emailButton.setEnabled(b);
        this.followupLabel.setEnabled(b);
        this.followupDateField.setEnabled(b);
        this.doneCheckBox.setEnabled(b);
        this.doneDateField.setEnabled(b);
        this.createdDateLabel.setEnabled(b);
        this.createdDateField.setEnabled(b && ActionPrefs.isEditCreateDate());
        this.projectLabel.setEnabled(b);
        this.addToProjectButton.setEnabled(b);
        this.addToProjectLabel.setEnabled(b);
        this.addToProjectField.setEnabled(b);
        this.addToProjectField.setEditable(false);
        this.newProjectCheck.setEnabled(b);
        this.newProjectField.setEnabled(b && this.newProjectCheck.isSelected());
        this.newProjectField.setEditable(b && this.newProjectCheck.isSelected());
    }

    private void initFieldValues() {
        Project project;
        if (this.thought == null) {
            this.thoughtLabel.setText(ProcessPanel.getMsg("LBL_Thought"));
            this.thoughtText.setText("");
            this.thoughtText.setForeground(Color.black);
            this.thoughtText.setBackground(Color.white);
            this.topicCombo.setSelectedItem(null);
            this.descriptionText.setText("");
            this.notesFieldNA.setText("");
            this.notesField.setText("");
            this.newProjectField.setText("");
        } else {
            this.thoughtLabel.setText(ProcessPanel.getMsg("LBL_ThoughtN", this.countUnprocessedThoughts()));
            this.thoughtText.setText(this.thought.getDescription());
            this.thoughtText.setForeground(this.thought.getTopic().getForeground());
            this.thoughtText.setBackground(this.thought.getTopic().getBackground());
            this.topicCombo.setSelectedItem(this.thought.getTopic());
            this.descriptionText.setText(this.thought.getDescription());
            this.notesFieldNA.setText(this.thought.getNotes());
            this.notesField.setText(this.thought.getNotes());
            this.newProjectField.setText(this.thought.getDescription());
        }
        this.actionableYesRadioButton.setSelected(false);
        this.actionableNoRadioButton.setSelected(false);
        if (this.action == null) {
            LOG.info("Action == null");
            this.deleteRadioButton.setSelected(false);
            this.somedayRadioButton.setSelected(true);
            this.referenceRadioButton.setSelected(false);
            this.tickleDateField.setDate(null);
            this.successText.setText("");
            this.contextCombo.setSelectedItem(null);
            this.timeCombo.setSelectedItem(null);
            this.energyCombo.setSelectedItem(null);
            this.priorityCombo.setSelectedItem(null);
            switch (ProjectsPrefs.getNewActionState()) {
                case DOASAP: {
                    this.statusCombo.setSelectedItem(StatusEnum.DO_ASAP);
                    break;
                }
                case DELEGATED: {
                    this.statusCombo.setSelectedItem(StatusEnum.DELEGATED);
                    break;
                }
                case INACTIVE: {
                    this.statusCombo.setSelectedItem(StatusEnum.INACTIVE);
                    break;
                }
                case SCHEDULED: {
                    this.statusCombo.setSelectedItem(StatusEnum.SCHEDULED);
                }
            }
            this.dueDateField.setDate(null);
            this.startDateField.setDate(null);
            this.scheduledDateField.setDate(null);
            this.scheduledHourSpinner.setVal(0);
            this.scheduledMinuteSpinner.setVal(0);
            this.durationHourSpinner.setVal(0);
            this.durationMinuteSpinner.setVal(0);
            this.recurrenceButton.setText(LBL_CREATE);
            this.delegatedToField.setText("");
            this.followupDateField.setDate(null);
            this.doneCheckBox.setSelected(false);
            this.doneDateField.setDate(null);
            this.createdDateField.setDate(Calendar.getInstance().getTime());
        } else {
            LOG.info("Action != null");
            this.deleteRadioButton.setSelected(false);
            this.somedayRadioButton.setSelected(true);
            this.referenceRadioButton.setSelected(false);
            this.tickleDateField.setDate(null);
            this.notesField.setText(this.action.getNotes());
            this.notesFieldNA.setText(this.action.getNotes());
            this.successText.setText(this.action.getSuccess());
            if (this.action.getDescription().trim().length() > 0) {
                this.descriptionText.setText(this.action.getDescription());
            }
            this.contextCombo.setSelectedItem(this.action.getContext());
            this.timeCombo.setSelectedItem(this.action.getTime());
            this.energyCombo.setSelectedItem(this.action.getEnergy());
            this.priorityCombo.setSelectedItem(this.action.getPriority());
            switch (this.action.getState().getType()) {
                case DELEGATED: {
                    this.statusCombo.setSelectedItem(StatusEnum.DELEGATED);
                    ActionStateDelegated s = (ActionStateDelegated)this.action.getState();
                    this.delegatedToField.setText(s.getTo());
                    this.followupDateField.setDate(s.getDate());
                    break;
                }
                case DOASAP: {
                    this.statusCombo.setSelectedItem(StatusEnum.DO_ASAP);
                    break;
                }
                case INACTIVE: {
                    this.statusCombo.setSelectedItem(StatusEnum.INACTIVE);
                    break;
                }
                case SCHEDULED: {
                    this.statusCombo.setSelectedItem(StatusEnum.SCHEDULED);
                    ActionStateDelegated s = (ActionStateScheduled)this.action.getState();
                    this.scheduledDateField.setDate(s.getDate());
                    Calendar c = Calendar.getInstance();
                    c.setTime(s.getDate());
                    this.scheduledHourSpinner.setVal(c.get(11));
                    this.scheduledMinuteSpinner.setVal(c.get(12));
                    this.durationHourSpinner.setVal(s.getDurationHours());
                    this.durationMinuteSpinner.setVal(s.getDurationMinutes());
                    this.recurrenceButton.setText(LBL_CREATE);
                    break;
                }
            }
            this.dueDateField.setDate(this.action.getDueDate());
            this.startDateField.setDate(this.action.getStartDate());
            this.doneCheckBox.setSelected(false);
            this.doneDateField.setDate(null);
            this.createdDateField.setDate(this.action.getCreated());
            this.newProjectField.setText(this.descriptionText.getText());
        }
        Project project2 = project = this.action == null ? null : (Project)this.action.getParent();
        if (project == null || project.isRoot()) {
            this.addToProject = null;
            this.addToProjectField.setText("");
        } else {
            this.addToProject = project;
            this.addToProjectField.setText(project.getDescription());
        }
        this.newProjectCheck.setSelected(false);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    private void addListeners() {
        this.actionListenerThoughtTopic = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcessPanel.this.changedTopic();
            }
        };
        this.topicCombo.addActionListener(this.actionListenerThoughtTopic);
        this.focusListenerThoughtText = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ProcessPanel.this.changedDescription();
            }
        };
        this.thoughtText.addFocusListener(this.focusListenerThoughtText);
        this.actionableYesListener = new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProcessPanel.this.changedToActionable();
            }
        };
        this.actionableYesRadioButton.addActionListener(this.actionableYesListener);
        this.actionableNoListener = new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ProcessPanel.this.changedToNotActionable();
            }
        };
        this.actionableNoRadioButton.addActionListener(this.actionableNoListener);
        this.actionListenerEmail = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcessPanel.this.emailActionPerformed();
            }
        };
        this.emailButton.addActionListener(this.actionListenerEmail);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ProcessPanel.this.hyperlink(evt);
            }
        };
        this.notesField.addHyperlinkListener(this.hyperlinkListener);
        this.notesFieldNA.addHyperlinkListener(this.hyperlinkListener);
        this.actionListenerDelete = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcessPanel.this.enableDisableNotActionable();
            }
        };
        this.deleteRadioButton.addActionListener(this.actionListenerDelete);
        this.actionListenerSomeday = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcessPanel.this.enableDisableNotActionable();
            }
        };
        this.somedayRadioButton.addActionListener(this.actionListenerSomeday);
        this.actionListenerReference = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcessPanel.this.enableDisableNotActionable();
            }
        };
        this.referenceRadioButton.addActionListener(this.actionListenerReference);
        this.doneCheckBoxActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcessPanel.this.doneCheckBoxChanged();
            }
        };
        this.doneCheckBox.addActionListener(this.doneCheckBoxActionListener);
        this.doneDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ProcessPanel.this.changedDoneDate();
            }
        };
        this.doneDateField.addPropertyChangeListener("value", this.doneDatePropertyChangeListener);
        this.statusListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ProcessPanel.this.changedStatus();
            }
        };
        this.statusCombo.addItemListener(this.statusListener);
        this.recurrenceButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessPanel.this.recurrenceButtonActionPerformed(e);
            }
        };
        this.recurrenceButton.addActionListener(this.recurrenceButtonListener);
        this.scheduledDateListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
                ProcessPanel.this.changedScheduledDate();
            }
        };
        this.scheduledDateField.addPropertyChangeListener(this.scheduledDateListener);
        this.newProjectCheckBoxListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessPanel.this.newProjectActionPerformed(e);
            }
        };
        this.newProjectCheck.addActionListener(this.newProjectCheckBoxListener);
        this.newProjectTextFocusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ProcessPanel.this.newProjectTextFocusGained(e);
            }
        };
        this.newProjectField.addFocusListener(this.newProjectTextFocusListener);
        this.addToProjectButtonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessPanel.this.addToProjectButtonActionPerformed(e);
            }
        };
        this.addToProjectButton.addActionListener(this.addToProjectButtonListener);
        this.prefsChangeListener = new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent e) {
                ProcessPanel.this.changedPrefs(e);
            }
        };
        ActionPrefs.prefs.addPreferenceChangeListener(this.prefsChangeListener);
        this.criteriaObserver = new Observer(){

            public void update(Observable observable, Object arguement) {
                ProcessPanel.this.changedCriteria();
            }
        };
        this.data.getTimeCriterion().addObserver(this.criteriaObserver);
        this.data.getEnergyCriterion().addObserver(this.criteriaObserver);
        this.data.getPriorityCriterion().addObserver(this.criteriaObserver);
    }

    private void removeListeners() {
        this.topicCombo.removeActionListener(this.actionListenerThoughtTopic);
        this.actionListenerThoughtTopic = null;
        this.thoughtText.removeFocusListener(this.focusListenerThoughtText);
        this.focusListenerThoughtText = null;
        this.actionableYesRadioButton.removeActionListener(this.actionableYesListener);
        this.actionableYesListener = null;
        this.actionableNoRadioButton.removeActionListener(this.actionableNoListener);
        this.actionableNoListener = null;
        this.emailButton.removeActionListener(this.actionListenerEmail);
        this.actionListenerEmail = null;
        this.notesField.removeHyperlinkListener(this.hyperlinkListener);
        this.notesFieldNA.removeHyperlinkListener(this.hyperlinkListener);
        this.hyperlinkListener = null;
        this.deleteRadioButton.removeActionListener(this.actionListenerDelete);
        this.actionListenerDelete = null;
        this.somedayRadioButton.removeActionListener(this.actionListenerSomeday);
        this.actionListenerSomeday = null;
        this.referenceRadioButton.removeActionListener(this.actionListenerReference);
        this.actionListenerReference = null;
        this.doneCheckBox.removeActionListener(this.doneCheckBoxActionListener);
        this.doneCheckBoxActionListener = null;
        this.doneDateField.removePropertyChangeListener(this.doneDatePropertyChangeListener);
        this.doneDatePropertyChangeListener = null;
        this.recurrenceButton.removeActionListener(this.recurrenceButtonListener);
        this.recurrenceButtonListener = null;
        this.scheduledDateField.removePropertyChangeListener(this.scheduledDateListener);
        this.scheduledDateListener = null;
        this.newProjectCheck.removeActionListener(this.newProjectCheckBoxListener);
        this.newProjectCheckBoxListener = null;
        this.newProjectField.removeFocusListener(this.newProjectTextFocusListener);
        this.newProjectTextFocusListener = null;
        this.addToProjectButton.removeActionListener(this.addToProjectButtonListener);
        this.addToProjectButtonListener = null;
        ActionPrefs.prefs.removePreferenceChangeListener(this.prefsChangeListener);
        this.prefsChangeListener = null;
        this.data.getTimeCriterion().removeObserver(this.criteriaObserver);
        this.data.getEnergyCriterion().removeObserver(this.criteriaObserver);
        this.data.getPriorityCriterion().removeObserver(this.criteriaObserver);
        this.criteriaObserver = null;
    }

    private void changedDescription() {
        if (this.thought != null) {
            this.thought.setDescription(this.thoughtText.getText());
        }
    }

    private void changedTopic() {
        if (this.thought != null) {
            this.thought.setTopic((Topic)this.topicCombo.getSelectedItem());
        }
    }

    private void changedToActionable() {
        this.panelChoice.removeAll();
        this.panelChoice.add((Component)this.getPanelActionable(), "Center");
        this.panelChoice.revalidate();
        this.panelChoice.repaint();
        this.notesField.setEditable(false);
        if (ActionPrefs.isShowSuccess()) {
            this.successText.requestFocusInWindow();
        } else {
            this.descriptionText.requestFocusInWindow();
        }
        if (!this.notesField.getText().equals(this.notesFieldNA.getText())) {
            this.notesField.setText(this.notesFieldNA.getText());
        }
    }

    private void changedToNotActionable() {
        this.panelChoice.removeAll();
        this.panelChoice.add((Component)this.getPanelNotActionable(), "Center");
        this.panelChoice.revalidate();
        this.panelChoice.repaint();
        this.notesFieldNA.setEditable(false);
        if (this.deleteRadioButton.isSelected()) {
            this.deleteRadioButton.requestFocusInWindow();
        } else if (this.somedayRadioButton.isSelected()) {
            this.somedayRadioButton.requestFocusInWindow();
        } else {
            this.referenceRadioButton.requestFocusInWindow();
        }
        if (!this.notesFieldNA.getText().equals(this.notesField.getText())) {
            this.notesFieldNA.setText(this.notesField.getText());
        }
    }

    private void emailActionPerformed() {
        String to = this.delegatedToField.getText();
        if (Utilities.getOperatingSystem() == 16 && to.indexOf("@") == -1) {
            JOptionPane.showMessageDialog(null, ProcessPanel.getMsg("ERR_EmailRequired"), "", 1);
            return;
        }
        String subject = this.descriptionText.getText();
        String body = this.notesField.getText();
        Email.email((String)to, (String)subject, (String)body, (String)ActionPrefs.getEmailEncoding());
        Date today = Calendar.getInstance().getTime();
        if (ActionPrefs.isNoteDelegateEmail()) {
            this.addToNotes(ProcessPanel.getMsg("MSG_EmailSent") + " " + Constants.DATE_FORMAT_FIXED.format(today));
        }
    }

    private void changedScheduledDate() {
        this.recurrenceButton.setEnabled(this.scheduledDateField.getDate() != null);
    }

    private void changedStatus() {
        StatusEnum status = (StatusEnum)this.statusCombo.getSelectedItem();
        if (status == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProcessPanel.this.statusCombo.setSelectedItem(StatusEnum.DO_ASAP);
                }
            });
            this.setStatusDoASAP();
            return;
        }
        switch (status) {
            case DELEGATED: {
                this.setStatusDelegated();
                return;
            }
            case DO_ASAP: {
                this.setStatusDoASAP();
                return;
            }
            case INACTIVE: {
                this.setStatusInactive();
                return;
            }
            case SCHEDULED: {
                this.setStatusScheduled();
                this.recurrenceButton.setEnabled(this.scheduledDateField.getDate() != null);
                return;
            }
        }
    }

    private void changedDoneDate() {
        this.doneCheckBox.setSelected(this.doneDateField.getDate() != null);
    }

    private void doneCheckBoxChanged() {
        if (this.doneCheckBox.isSelected()) {
            if (this.doneDateField.getDate() == null) {
                this.doneDateField.setDate(Calendar.getInstance().getTime());
            }
        } else {
            this.doneDateField.setDate(null);
        }
    }

    private void changedPrefs(PreferenceChangeEvent e) {
        String key = e.getKey();
        if (key.equals("edit.create-date")) {
            this.createdDateField.setEnabled(this.thought != null && ActionPrefs.isEditCreateDate());
            return;
        }
        if (key.equals("note.delegate.email")) {
            return;
        }
        if (key.equals("show.due")) {
            if (this.actionableYesRadioButton.isSelected()) {
                this.changedStatus();
            }
            return;
        }
        if (key.equals("show.start")) {
            if (this.actionableYesRadioButton.isSelected()) {
                this.changedStatus();
            }
            return;
        }
        if (key.equals("show.success")) {
            this.panelActionable = null;
            if (this.actionableYesRadioButton.isSelected()) {
                this.changedToActionable();
            }
            return;
        }
    }

    private void changedCriteria() {
        this.panelActionable = null;
        if (this.actionableYesRadioButton.isSelected()) {
            this.changedToActionable();
        }
    }

    private void addToNotes(String text) {
        String notes = this.notesField.getText().trim();
        if (notes.contains(text)) {
            return;
        }
        if (notes.length() == 0) {
            this.notesField.setText(text);
        } else {
            this.notesField.setText(notes + "\n" + text);
        }
    }

    private void hyperlink(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void enableDisableNotActionable() {
        this.tickleDateLabel.setEnabled(this.somedayRadioButton.isSelected());
        this.tickleDateField.setEnabled(this.somedayRadioButton.isSelected());
        if (this.deleteRadioButton.isSelected()) {
            this.notesLabelNA.setEnabled(false);
            this.notesFieldNA.setEnabled(false);
            this.notesFieldNA.setEditable(false);
        } else {
            this.notesLabelNA.setEnabled(true);
            this.notesFieldNA.setEnabled(true);
        }
    }

    private Thought getNextUnprocessedThought() {
        for (Thought t : this.thoughtManager.list()) {
            if (t.isProcessed()) continue;
            return t;
        }
        return null;
    }

    private int countUnprocessedThoughts() {
        int c = 0;
        for (Thought t : this.thoughtManager.list()) {
            if (t.isProcessed()) continue;
            ++c;
        }
        return c;
    }

    public synchronized void initModel() {
        if (this.thought != null) {
            this.thought.removeObserver((Observer)this);
        }
        this.thought = this.getNextUnprocessedThought();
        if (this.thought == null) {
            this.action = null;
            this.enableFields(false);
            this.processNodeProvider.provide(null);
        } else {
            if (this.thought.getAction() != null) {
                this.action = this.thought.getAction();
            } else {
                this.action = new Action((IDGenerator)this.data);
                this.action.setDescription(this.thought.getDescription());
                this.action.setNotes(this.thought.getNotes());
                this.action.setTopic(this.thought.getTopic());
                switch (ProjectsPrefs.getNewActionState()) {
                    case DELEGATED: {
                        this.action.setState((ActionState)new ActionStateDelegated());
                        break;
                    }
                    case DOASAP: {
                        this.action.setState((ActionState)new ActionStateASAP());
                        break;
                    }
                    case INACTIVE: {
                        this.action.setState((ActionState)new ActionStateInactive());
                        break;
                    }
                    case SCHEDULED: {
                        this.action.setState((ActionState)new ActionStateScheduled());
                    }
                }
            }
            this.thought.addObserver(this.thoughtObserver);
            this.recurrenceProject = null;
            this.enableFields(true);
            this.processNodeProvider.provide(this.processNode);
        }
        this.initFieldValues();
        this.actionableYesRadioButton.setSelected(true);
        this.changedToActionable();
        this.changedStatus();
        this.actionableYesRadioButton.requestFocusInWindow();
    }

    public String validateProcessing() {
        StringBuffer sb = new StringBuffer();
        if (this.actionableNoRadioButton.isSelected()) {
            if (!this.deleteRadioButton.isSelected() && this.thoughtText.getText().trim().equals("")) {
                sb.append(ProcessPanel.getMsg("no.thought.description") + "\n");
            }
        } else {
            if (this.descriptionText.getText().trim().length() == 0) {
                sb.append(ProcessPanel.getMsg("no.action.description") + "\n");
            }
            if (this.statusCombo.getSelectedItem() == StatusEnum.SCHEDULED && this.scheduledDateField.getDate() == null) {
                sb.append(ProcessPanel.getMsg("no.scheduled.date") + "\n");
            }
            if (this.statusCombo.getSelectedItem() == StatusEnum.DELEGATED && this.delegatedToField.getText().trim().equals("")) {
                sb.append(ProcessPanel.getMsg("no.delegate") + "\n");
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public void process() {
        if (this.thought == null || this.action == null) {
            return;
        }
        String probs = this.validateProcessing();
        if (probs != null) {
            String t = ProcessPanel.getMsg("dialog.problems.title");
            String m = ProcessPanel.getMsg("dialog.problems.message") + "\n\n" + probs + "\n";
            JOptionPane.showMessageDialog(null, m, t, 2);
            return;
        }
        if (this.actionableNoRadioButton.isSelected()) {
            if (this.deleteRadioButton.isSelected()) {
                this.thoughtManager.remove((Observable)this.thought);
            } else if (this.referenceRadioButton.isSelected()) {
                Information reference = new Information(this.data.getNextID());
                reference.setTopic((Topic)this.topicCombo.getSelectedItem());
                reference.setDescription(this.thoughtText.getText());
                reference.setNotes(this.notesFieldNA.getText());
                this.referenceManager.add((Observable)reference);
            } else if (this.somedayRadioButton.isSelected()) {
                Future someday = new Future(this.data.getNextID());
                someday.setThought(this.thought);
                someday.setDescription(this.thoughtText.getText());
                someday.setTopic((Topic)this.topicCombo.getSelectedItem());
                someday.setTickle(this.tickleDateField.getDate());
                someday.setNotes(this.notesFieldNA.getText());
                this.somedayManager.add((Observable)someday);
            }
        } else {
            Recurrence recurrence;
            this.action.setThought(this.thought);
            this.action.setSuccess(this.successText.getText());
            this.action.setDescription(this.descriptionText.getText());
            this.action.setTopic((Topic)this.topicCombo.getSelectedItem());
            this.action.setContext((Context)this.contextCombo.getSelectedItem());
            this.action.setTime((Value)this.timeCombo.getSelectedItem());
            this.action.setEnergy((Value)this.energyCombo.getSelectedItem());
            this.action.setPriority((Value)this.priorityCombo.getSelectedItem());
            this.action.setNotes(this.notesField.getText());
            this.action.setDone(this.doneCheckBox.isSelected());
            this.action.setDoneDate(this.doneDateField.getDate());
            this.action.setCreated(this.createdDateField.getDate());
            StatusEnum status = (StatusEnum)this.statusCombo.getSelectedItem();
            switch (status) {
                case DELEGATED: {
                    ActionStateDelegated stateDelegated = new ActionStateDelegated();
                    stateDelegated.setDate(this.followupDateField.getDate());
                    stateDelegated.setTo(this.delegatedToField.getText());
                    this.action.setState((ActionState)stateDelegated);
                    this.action.setDueDate(this.dueDateField.getDate());
                    this.action.setStartDate(this.startDateField.getDate());
                    break;
                }
                case DO_ASAP: {
                    this.action.setState((ActionState)new ActionStateASAP());
                    this.action.setDueDate(this.dueDateField.getDate());
                    this.action.setStartDate(this.startDateField.getDate());
                    break;
                }
                case INACTIVE: {
                    this.action.setState((ActionState)new ActionStateInactive());
                    this.action.setDueDate(this.dueDateField.getDate());
                    this.action.setStartDate(this.startDateField.getDate());
                    break;
                }
                case SCHEDULED: {
                    if (!this.action.isStateScheduled()) {
                        this.action.setState((ActionState)new ActionStateScheduled());
                    }
                    ActionStateScheduled stateScheduled = (ActionStateScheduled)this.action.getState();
                    Calendar c = Calendar.getInstance();
                    c.setTime(this.scheduledDateField.getDate());
                    c.set(11, this.scheduledHourSpinner.getVal());
                    c.set(12, this.scheduledMinuteSpinner.getVal());
                    stateScheduled.setDate(c.getTime());
                    stateScheduled.setDurationHours(this.durationHourSpinner.getVal());
                    stateScheduled.setDurationMins(this.durationMinuteSpinner.getVal());
                    this.action.setDueDate(null);
                    this.action.setStartDate(null);
                }
            }
            if (this.newProjectCheck.isSelected()) {
                Project project = new Project((IDGenerator)this.data);
                project.setThought(this.thought);
                String desc = this.newProjectField.getText().trim();
                project.setDescription(desc.length() > 0 ? desc : this.thought.getDescription());
                project.setTopic(this.action.getTopic());
                project.setDone(false);
                project.setVision(this.action.getSuccess());
                project.setNotes(this.thought.getNotes());
                project.add((Item)this.action);
                if (this.addToProject == null) {
                    this.projects.add((Item)project);
                } else {
                    project.setSequencing(this.addToProject.isSequencing());
                    project.setSequenceType(this.addToProject.getSequenceType());
                    project.setPriority(this.addToProject.getPriority());
                    this.addToProject.add((Item)project);
                }
            } else if (this.addToProject == null) {
                this.singleActions.add((Item)this.action);
            } else {
                this.addToProject.add((Item)this.action);
            }
            if (this.action.getPriority() == null) {
                this.action.setPriority(((Project)this.action.getParent()).getPriority());
            }
            if (this.action.isStateScheduled() && (recurrence = this.action.getRecurrence()) != null) {
                Project parent;
                if (this.recurrenceProject != null && (parent = (Project)this.action.getParent()) != null) {
                    for (Action a : this.recurrenceProject.getChildren(Action.class)) {
                        if (a.getID() == this.action.getID()) continue;
                        parent.add((Item)a);
                    }
                }
                recurrence.setProject((Project)this.action.getParent());
            }
        }
        this.thought.setProcessed(true);
        this.initModel();
    }

    public void takeFocus() {
        this.actionableYesRadioButton.requestFocusInWindow();
    }

    public void update(Observable observable, Object arg) {
        if (observable == this.thoughtManager && this.thought == null) {
            this.initModel();
        }
    }

    private void initPanel() {
        this.initFields();
        this.add((Component)this.createPanel(), "Center");
    }

    private void initFields() {
        this.thoughtLabel = new TRLabel(ProcessPanel.getMsg("LBL_Thought"));
        this.thoughtText = new TRTextField();
        this.topicLabel = new TRLabel(LBL_TOPIC);
        this.topicCombo = new TopicsComboBox((ComboBoxModel)new TopicsComboBoxModel(false));
        this.actionableYesRadioButton = new JRadioButton(LBL_YES);
        this.actionableNoRadioButton = new JRadioButton(LBL_NO);
        this.actionableButtonGroup = new ButtonGroup();
        this.actionableButtonGroup.add(this.actionableNoRadioButton);
        this.actionableButtonGroup.add(this.actionableYesRadioButton);
        this.deleteRadioButton = new JRadioButton();
        this.deleteRadioButton.setText(LBL_DELETE);
        this.somedayRadioButton = new JRadioButton();
        this.somedayRadioButton.setText(LBL_SOMEDAY);
        this.tickleDateLabel = new TRLabel(LBL_TICKLE_DATE);
        this.tickleDateField = new DateField();
        this.referenceRadioButton = new JRadioButton();
        this.referenceRadioButton.setText(LBL_REFERENCE);
        this.notesLabelNA = new TRLabel(LBL_NOTES);
        this.notesFieldNA = new HyperEditorPane();
        this.notesFieldNA.setMinimumSize(SIZE_NOTES_EDITOR);
        this.notesLabel = new TRLabel(LBL_NOTES);
        this.notesField = new HyperEditorPane();
        this.notesField.setMinimumSize(SIZE_NOTES_EDITOR);
        this.actionableLabel = new TRLabel(LBL_ACTIONABLE);
        this.successLabel = new TRLabel(LBL_SUCCESS);
        this.successText = new MTextArea();
        this.actionLabel = new TRLabel(LBL_NEXT_ACTION);
        this.descriptionLabel = new TRLabel(LBL_DESCRIPTION);
        this.descriptionText = new TRTextField();
        this.contextLabel = new TRLabel(LBL_CONTEXT);
        this.contextCombo = new ContextsComboBox((ComboBoxModel)new ContextsComboBoxModel(false));
        this.timeLabel = new TRLabel(LBL_TIME);
        this.timeCombo = new TRComboBox(this.getTimeComboBoxModel());
        this.energyLabel = new TRLabel(LBL_ENERGY);
        this.energyCombo = new TRComboBox(this.getEnergyComboBoxModel());
        this.priorityLabel = new TRLabel(LBL_PRIORITY);
        this.priorityCombo = new TRComboBox(this.getPriorityComboBoxModel());
        this.statusLabel = new TRLabel(LBL_STATUS);
        this.statusCombo = new TRComboBox((ComboBoxModel)new StatusComboBoxModel());
        this.recurrenceLabel = new TRLabel(LBL_RECURRENCE);
        this.recurrenceButton = new TRButton(LBL_CREATE);
        this.dueDateLabel = new TRLabel(LBL_DUE_DATE);
        this.dueDateField = new DateField();
        this.startDateLabel = new TRLabel(LBL_START_DATE);
        this.startDateField = new DateField();
        this.notActionableButtonGroup = new ButtonGroup();
        this.notActionableButtonGroup.add(this.deleteRadioButton);
        this.notActionableButtonGroup.add(this.somedayRadioButton);
        this.notActionableButtonGroup.add(this.referenceRadioButton);
        this.scheduledHourSpinner = new HourSpinner();
        this.scheduledMinuteSpinner = new MinuteSpinner();
        this.durationLabel = new TRLabel(LBL_DURATION);
        this.durationHourSpinner = new HourSpinner();
        this.durationMinuteSpinner = new MinuteSpinner();
        this.scheduledDateField = new DateField();
        this.delegatedToLabel = new TRLabel(LBL_DELEGATE);
        this.delegatedToField = new TRTextField();
        this.delegatedToField.setPreferredSize(SIZE_DELEGATE_TEXT);
        this.delegatedToField.setMinimumSize(SIZE_DELEGATE_TEXT);
        this.delegatedToField.setMaximumSize(SIZE_DELEGATE_TEXT);
        this.emailButton = new TRButton(LBL_EMAIL);
        this.followupLabel = new TRLabel(LBL_FOLLOWUP);
        this.followupDateField = new DateField();
        this.doneCheckBox = new JCheckBox(LBL_DONE);
        this.doneCheckBox.setHorizontalTextPosition(10);
        this.doneDateField = new DateField();
        this.createdDateLabel = new TRLabel(LBL_CREATED);
        this.createdDateField = new DateField();
        this.projectLabel = new TRLabel(LBL_PROJECT);
        this.newProjectCheck = new JCheckBox(LBL_NEW_PROJECT);
        this.newProjectCheck.setHorizontalTextPosition(10);
        this.newProjectField = new TRTextField();
        this.addToProjectField = new TRTextField();
        this.addToProjectLabel = new TRLabel(LBL_ADD_TO_PROJECT);
        this.addToProjectButton = new TRButton("...");
        this.addToProjectButton.setPreferredSize(SIZE_PROJECT_BUTTON);
        this.addToProjectButton.setMinimumSize(SIZE_PROJECT_BUTTON);
        this.addToProjectButton.setMaximumSize(SIZE_PROJECT_BUTTON);
    }

    private JPanel createPanel() {
        JPanel panel = ViewUtils.isAquaLaF() ? new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "[][grow]", "4[]2[]2[]2[]2[grow]0")) : new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "[][grow]", "4[center]2[top]2[center]2[center]2[grow]0"));
        ViewUtils.addSeparator((JPanel)panel, (JLabel)this.thoughtLabel);
        panel.add((Component)this.thoughtText, "align left, span, growx 100, split 3");
        panel.add((Component)this.topicLabel, "align left");
        panel.add((Component)this.topicCombo, "align left, wrap");
        ViewUtils.addSeparator((JPanel)panel, (JLabel)this.actionableLabel);
        panel.add((Component)this.actionableYesRadioButton, "align left, split 2");
        panel.add((Component)this.actionableNoRadioButton, "align left, wrap");
        this.panelChoice = new JPanel(new BorderLayout());
        panel.add((Component)this.panelChoice, "span, grow");
        return panel;
    }

    private JPanel getPanelNotActionable() {
        if (this.panelNotActionable == null) {
            this.panelNotActionable = new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "0[grow]0", "2[]2[]2[]2[]2[]4[grow]4"));
            ViewUtils.addSeparator((JPanel)this.panelNotActionable, (String)LBL_NOT_ACTIONABLE);
            this.panelNotActionable.add((Component)this.deleteRadioButton, "sx, wrap");
            this.panelNotActionable.add((Component)this.somedayRadioButton, "sx, split 3, align left");
            this.panelNotActionable.add((Component)this.tickleDateLabel, "align left, gapleft 12");
            this.panelNotActionable.add((Component)this.tickleDateField, "align left, wrap");
            this.panelNotActionable.add((Component)this.referenceRadioButton, "sx, wrap");
            ViewUtils.addSeparator((JPanel)this.panelNotActionable);
            this.panelNotActionable.add((Component)this.notesLabelNA, "span, split 2, align left top, growx 0, growy 0");
            this.panelNotActionable.add((Component)this.notesFieldNA, "span, grow");
        }
        return this.panelNotActionable;
    }

    private JPanel getPanelActionable() {
        if (this.panelActionable == null) {
            if (ActionPrefs.isShowSuccess()) {
                this.panelActionable = new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "0[][grow]0", "0[]2[]2[]2[grow]2[]2[]2[]2"));
                ViewUtils.addSeparator((JPanel)this.panelActionable, (JLabel)this.successLabel);
                this.panelActionable.add((Component)this.successText, "span, growx, wrap");
            } else {
                this.panelActionable = new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "0[][grow]0", "0[]2[grow]2[]2[]2[]2"));
            }
            ViewUtils.addSeparator((JPanel)this.panelActionable, (JLabel)this.actionLabel);
            this.panelActionable.add((Component)this.getPanelAction(), "span, grow, wrap");
            ViewUtils.addSeparator((JPanel)this.panelActionable, (JLabel)this.projectLabel);
            this.panelActionable.add((Component)this.newProjectCheck, "align left, grow 0");
            this.panelActionable.add((Component)this.newProjectField, "align left, growx 100, growy 0, wrap");
            this.panelActionable.add((Component)this.addToProjectLabel, "split 2, gapleft 5, gapright 6, align left, growx 0, growy 0");
            this.panelActionable.add((Component)this.addToProjectButton, "gapright 6, align left, grow 0");
            this.panelActionable.add((Component)this.addToProjectField, "align left, growx 100, growy 0, wrap");
        }
        return this.panelActionable;
    }

    private String getMIGCons() {
        return "";
    }

    private String getMIGCons(String c) {
        assert (c != null && c.trim().length() > 0);
        return c;
    }

    private JPanel getStatusPanel(Rows rows) {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setOpaque(false);
            this.statusPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        } else {
            this.statusPanel.removeAll();
        }
        if (ViewUtils.isAquaLaF()) {
            this.statusPanel.setLayout((LayoutManager)(rows == Rows.One ? this.statusLayoutA1 : this.statusLayoutA2));
        } else {
            this.statusPanel.setLayout((LayoutManager)(rows == Rows.One ? this.statusLayoutM1 : this.statusLayoutM2));
        }
        return this.statusPanel;
    }

    private void setStatusDelegated() {
        boolean focus = this.statusCombo.hasFocus();
        JPanel panel = this.getStatusPanel(Rows.Two);
        panel.add((Component)this.statusCombo, "span, split");
        if (ActionPrefs.isShowDueDate()) {
            panel.add((Component)this.dueDateLabel, "");
            panel.add((Component)this.dueDateField, "");
        }
        if (ActionPrefs.isShowStartDate()) {
            panel.add((Component)this.startDateLabel, "");
            panel.add((Component)this.startDateField, "");
        }
        panel.add((Component)fillerLabel1, "wrap");
        panel.add((Component)this.delegatedToLabel, "gapleft 4, span, split 5");
        panel.add((Component)this.delegatedToField, "");
        panel.add((Component)this.emailButton, "gapleft 2");
        panel.add((Component)this.followupLabel, "");
        panel.add((Component)this.followupDateField, "wrap");
        panel.revalidate();
        panel.repaint();
        if (focus) {
            this.statusCombo.requestFocusInWindow();
        }
    }

    private void setStatusDoASAP() {
        boolean focus = this.statusCombo.hasFocus();
        JPanel panel = this.getStatusPanel(Rows.One);
        panel.add((Component)this.statusCombo, "span, split");
        if (ActionPrefs.isShowDueDate()) {
            panel.add((Component)this.dueDateLabel, "");
            panel.add((Component)this.dueDateField, "");
        }
        if (ActionPrefs.isShowStartDate()) {
            panel.add((Component)this.startDateLabel, "");
            panel.add((Component)this.startDateField, "");
        }
        panel.add((Component)fillerLabel2, "wrap");
        panel.revalidate();
        panel.repaint();
        if (focus) {
            this.statusCombo.requestFocusInWindow();
        }
    }

    private void setStatusInactive() {
        boolean focus = this.statusCombo.hasFocus();
        JPanel panel = this.getStatusPanel(Rows.One);
        panel.add((Component)this.statusCombo, "span, split");
        if (ActionPrefs.isShowDueDate()) {
            panel.add((Component)this.dueDateLabel, "");
            panel.add((Component)this.dueDateField, "");
        }
        if (ActionPrefs.isShowStartDate()) {
            panel.add((Component)this.startDateLabel, "");
            panel.add((Component)this.startDateField, "");
        }
        panel.add((Component)fillerLabel3, "wrap");
        panel.revalidate();
        panel.repaint();
        if (focus) {
            this.statusCombo.requestFocusInWindow();
        }
    }

    private void setStatusScheduled() {
        boolean focus = this.statusCombo.hasFocus();
        JPanel panel = this.getStatusPanel(Rows.Two);
        panel.add((Component)this.statusCombo, "span, split 7");
        panel.add((Component)this.scheduledDateField, "gapleft 2");
        panel.add((Component)this.scheduledHourSpinner, "gapleft 0");
        panel.add((Component)this.scheduledMinuteSpinner, "gapleft 0");
        panel.add((Component)this.durationLabel, "gapleft 4");
        panel.add((Component)this.durationHourSpinner, "gapleft 2");
        panel.add((Component)this.durationMinuteSpinner, "gapleft 0, wrap");
        panel.add((Component)this.recurrenceLabel, "gapleft 4, split 2");
        panel.add((Component)this.recurrenceButton, "gapleft 2, wrap");
        panel.revalidate();
        panel.repaint();
        if (focus) {
            this.statusCombo.requestFocusInWindow();
        }
    }

    private JPanel getPanelAction() {
        if (this.panelAction == null) {
            this.panelAction = ViewUtils.isAquaLaF() ? new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]2", "0[]2[]2[]2[]2[]2[grow]2[]2[]0")) : new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]2", "0[top]2[top]2[]2[top]2[]2[top,grow]2[]2[top]0"));
            this.panelAction.add((Component)this.descriptionLabel, "align right");
            this.panelAction.add((Component)this.descriptionText, "span, growx, wrap");
            this.panelAction.add((Component)this.contextLabel, "align right");
            this.panelAction.add((Component)this.contextCombo, "align left, span, split");
            if (this.data.getTimeCriterion().isUse()) {
                this.panelAction.add((Component)this.timeLabel, "align right");
                this.panelAction.add((Component)this.timeCombo, "align left");
            }
            if (this.data.getEnergyCriterion().isUse()) {
                this.panelAction.add((Component)this.energyLabel, "align right");
                this.panelAction.add((Component)this.energyCombo, "align left");
            }
            if (this.data.getPriorityCriterion().isUse()) {
                this.panelAction.add((Component)this.priorityLabel, "align right");
                this.panelAction.add((Component)this.priorityCombo, "align left");
            }
            this.panelAction.add((Component)fillerLabel4, "wrap");
            ViewUtils.addSeparator((JPanel)this.panelAction);
            if (ViewUtils.isAquaLaF()) {
                this.panelAction.add((Component)this.statusLabel, "align right top, gaptop 4");
                this.panelAction.add((Component)this.getStatusPanel(Rows.One), "align left, growx 100, wrap");
            } else {
                this.panelAction.add((Component)this.statusLabel, "align right top");
                this.panelAction.add((Component)this.getStatusPanel(Rows.One), "align left, growx 100, wrap");
            }
            ViewUtils.addSeparator((JPanel)this.panelAction);
            if (ViewUtils.isAquaLaF()) {
                this.panelAction.add((Component)this.notesLabel, "align right top, gaptop 4, growx 0, growy 0");
                this.panelAction.add((Component)this.notesField, "span, gapleft 3, gapright 3, grow");
            } else {
                this.panelAction.add((Component)this.notesLabel, "align right top, growx 0, growy 0");
                this.panelAction.add((Component)this.notesField, "span, grow");
            }
            ViewUtils.addSeparator((JPanel)this.panelAction);
            this.panelAction.add((Component)this.doneCheckBox, "align right, grow 0");
            this.panelAction.add((Component)this.doneDateField, "align left, split 3, grow 0");
            this.panelAction.add((Component)this.createdDateLabel, "align left, grow 0");
            this.panelAction.add((Component)this.createdDateField, "align left, grow 0, wrap");
        }
        return this.panelAction;
    }

    private ComboBoxModel getTimeComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getTimeCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private ComboBoxModel getEnergyComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getEnergyCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private ComboBoxModel getPriorityComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getPriorityCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private void recurrenceButtonActionPerformed(ActionEvent e) {
        Recurrence recurrence;
        if (this.statusCombo.getSelectedItem() != StatusEnum.SCHEDULED) {
            return;
        }
        this.action.setThought(this.thought);
        this.action.setSuccess(this.successText.getText());
        this.action.setDescription(this.descriptionText.getText());
        this.action.setTopic((Topic)this.topicCombo.getSelectedItem());
        this.action.setContext((Context)this.contextCombo.getSelectedItem());
        this.action.setTime((Value)this.timeCombo.getSelectedItem());
        this.action.setEnergy((Value)this.energyCombo.getSelectedItem());
        this.action.setPriority((Value)this.priorityCombo.getSelectedItem());
        this.action.setNotes(this.notesField.getText());
        this.action.setDone(this.doneCheckBox.isSelected());
        this.action.setDoneDate(this.doneDateField.getDate());
        this.action.setCreated(this.createdDateField.getDate());
        if (!this.action.isStateScheduled()) {
            this.action.setState((ActionState)new ActionStateScheduled());
        }
        ActionStateScheduled state = (ActionStateScheduled)this.action.getState();
        state.setDate(this.scheduledDateField.getDate());
        state.setDurationHours(this.durationHourSpinner.getVal());
        state.setDurationMins(this.durationMinuteSpinner.getVal());
        if (this.recurrenceProject == null) {
            this.recurrenceProject = new Project((IDGenerator)this.data);
            this.recurrenceProject.add((Item)this.action);
        }
        if ((recurrence = this.action.getRecurrence()) == null) {
            NewRecurrenceWizard wizard = new NewRecurrenceWizard();
            wizard.start(this.action);
        } else {
            ModifyRecurrenceWizard wizard = new ModifyRecurrenceWizard();
            wizard.start(this.action);
        }
        if (this.action.getRecurrence() == null) {
            this.recurrenceButton.setText(LBL_CREATE);
        } else {
            this.recurrenceButton.setText(LBL_MODIFY);
        }
    }

    private void newProjectTextFocusGained(FocusEvent evt) {
        if (this.newProjectField.getText().equals(this.thought.getDescription())) {
            this.newProjectField.selectAll();
        }
    }

    private void newProjectActionPerformed(ActionEvent evt) {
        this.newProjectField.setEnabled(this.newProjectCheck.isSelected());
    }

    private void addToProjectButtonActionPerformed(ActionEvent evt) {
        if (this.projectChooser == null) {
            this.projectChooser = new ProjectChooser(WindowManager.getDefault().getMainWindow());
        }
        ProjectChooserDialog dialog = this.projectChooser.getDialog();
        Project newProject = dialog.select(this.addToProject, (Component)this.addToProjectButton);
        if (!dialog.cancelled()) {
            this.addToProject = newProject;
            if (this.addToProject == null) {
                this.addToProjectField.setText("");
            } else {
                this.addToProjectField.setText(this.addToProject.getDescription());
            }
        }
    }

    private static String getMsg(String key) {
        return NbBundle.getMessage(ProcessPanel.class, (String)key);
    }

    private static String getMsg(String key, int n) {
        return NbBundle.getMessage(ProcessPanel.class, (String)key, (Object)n);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Rows {
        One,
        Two;

    }
}

