/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.helper;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;

final class KeyResolver
implements Provider<String> {
    private final Key<String> key;
    private final String defaultValue;
    private final String toString;
    @Inject
    private Injector injector;

    public KeyResolver(String key, String defaultValue) {
        this.key = Key.get(String.class, (Annotation)Names.named(key));
        this.defaultValue = defaultValue;
        this.toString = "${" + key + "}";
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    @Override
    public String get() {
        try {
            return this.injector.getInstance(this.key);
        }
        catch (Throwable e) {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            return this.toString;
        }
    }

    public String toString() {
        return this.toString;
    }
}

