/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.json.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UserData {
    private String username;
    private Long expires;
    private boolean singleUse = false;
    private ConcurrentMap<String, Connection> connections;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Long getExpires() {
        return this.expires;
    }

    public void setExpires(Long expires) {
        this.expires = expires;
    }

    public boolean isSingleUse() {
        return this.singleUse;
    }

    public void setSingleUse(boolean singleUse) {
        this.singleUse = singleUse;
    }

    public Map<String, Connection> getConnections() {
        return this.connections == null ? null : Collections.unmodifiableMap(this.connections);
    }

    public void setConnections(Map<String, Connection> connections) {
        this.connections = new ConcurrentHashMap<String, Connection>(connections);
    }

    public Connection removeConnection(String identifier) {
        return (Connection)this.connections.remove(identifier);
    }

    @JsonIgnore
    public boolean isExpired() {
        Long expirationTimestamp = this.getExpires();
        if (expirationTimestamp == null) {
            return false;
        }
        return System.currentTimeMillis() > expirationTimestamp;
    }

    public static class Connection {
        private String id;
        private String protocol;
        private String primaryConnection;
        private Map<String, String> parameters;
        private boolean singleUse = false;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @JsonProperty(value="join")
        public String getPrimaryConnection() {
            return this.primaryConnection;
        }

        @JsonProperty(value="join")
        public void setPrimaryConnection(String primaryConnection) {
            this.primaryConnection = primaryConnection;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public void setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        public boolean isSingleUse() {
            return this.singleUse;
        }

        public void setSingleUse(boolean singleUse) {
            this.singleUse = singleUse;
        }
    }
}

