/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.intercept;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class RequestMatcherDelegatingAuthorizationManager
implements AuthorizationManager<HttpServletRequest> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<RequestMatcher, AuthorizationManager<RequestAuthorizationContext>> mappings;

    private RequestMatcherDelegatingAuthorizationManager(Map<RequestMatcher, AuthorizationManager<RequestAuthorizationContext>> mappings) {
        Assert.notEmpty(mappings, "mappings cannot be empty");
        this.mappings = mappings;
    }

    @Override
    public AuthorizationDecision check(Supplier<Authentication> authentication, HttpServletRequest request) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(LogMessage.format("Authorizing %s", (Object)request));
        }
        for (Map.Entry<RequestMatcher, AuthorizationManager<RequestAuthorizationContext>> mapping : this.mappings.entrySet()) {
            RequestMatcher matcher = mapping.getKey();
            RequestMatcher.MatchResult matchResult = matcher.matcher(request);
            if (!matchResult.isMatch()) continue;
            AuthorizationManager<RequestAuthorizationContext> manager = mapping.getValue();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(LogMessage.format("Checking authorization on %s using %s", (Object)request, manager));
            }
            return manager.check(authentication, new RequestAuthorizationContext(request, matchResult.getVariables()));
        }
        this.logger.trace("Abstaining since did not find matching RequestMatcher");
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<RequestMatcher, AuthorizationManager<RequestAuthorizationContext>> mappings = new LinkedHashMap<RequestMatcher, AuthorizationManager<RequestAuthorizationContext>>();

        public Builder add(RequestMatcher matcher, AuthorizationManager<RequestAuthorizationContext> manager) {
            Assert.notNull((Object)matcher, "matcher cannot be null");
            Assert.notNull(manager, "manager cannot be null");
            this.mappings.put(matcher, manager);
            return this;
        }

        public RequestMatcherDelegatingAuthorizationManager build() {
            return new RequestMatcherDelegatingAuthorizationManager(this.mappings);
        }
    }
}

