/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.scheduling;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.util.Assert;

public class DelegatingSecurityContextTaskScheduler
implements TaskScheduler {
    private final TaskScheduler delegate;
    private final SecurityContext securityContext;

    public DelegatingSecurityContextTaskScheduler(TaskScheduler delegateTaskScheduler, SecurityContext securityContext) {
        Assert.notNull((Object)delegateTaskScheduler, "delegateTaskScheduler cannot be null");
        this.delegate = delegateTaskScheduler;
        this.securityContext = securityContext;
    }

    public DelegatingSecurityContextTaskScheduler(TaskScheduler delegate) {
        this(delegate, null);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        return this.delegate.schedule(this.wrap(task), trigger);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        return this.delegate.schedule(this.wrap(task), startTime);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        return this.delegate.scheduleAtFixedRate(this.wrap(task), startTime, period);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        return this.delegate.scheduleAtFixedRate(this.wrap(task), period);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        return this.delegate.scheduleWithFixedDelay(this.wrap(task), startTime, delay);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        return this.delegate.scheduleWithFixedDelay(this.wrap(task), delay);
    }

    private Runnable wrap(Runnable delegate) {
        return DelegatingSecurityContextRunnable.create(delegate, this.securityContext);
    }
}

