/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.AuthenticationProviderService;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.security.PasswordPolicyService;
import org.apache.guacamole.auth.jdbc.sharing.user.SharedAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.ModeledUser;
import org.apache.guacamole.auth.jdbc.user.ModeledUserContext;
import org.apache.guacamole.auth.jdbc.user.PrivilegedModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.UserModel;
import org.apache.guacamole.auth.jdbc.user.UserService;
import org.apache.guacamole.language.TranslatableGuacamoleClientException;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;

public class JDBCAuthenticationProviderService
implements AuthenticationProviderService {
    @Inject
    private JDBCEnvironment environment;
    @Inject
    private UserService userService;
    @Inject
    private PasswordPolicyService passwordPolicyService;
    @Inject
    private Provider<ModeledUserContext> userContextProvider;

    @Override
    public AuthenticatedUser authenticateUser(AuthenticationProvider authenticationProvider, Credentials credentials) throws GuacamoleException {
        ModeledAuthenticatedUser user = this.userService.retrieveAuthenticatedUser(authenticationProvider, credentials);
        if (user != null) {
            return user;
        }
        throw new GuacamoleInvalidCredentialsException("Invalid login", CredentialsInfo.USERNAME_PASSWORD);
    }

    @Override
    public ModeledUserContext getUserContext(AuthenticationProvider authenticationProvider, AuthenticatedUser authenticatedUser) throws GuacamoleException {
        if (authenticatedUser instanceof SharedAuthenticatedUser) {
            return null;
        }
        boolean databaseCredentialsUsed = authenticatedUser instanceof ModeledAuthenticatedUser;
        boolean databaseRestrictionsApplicable = databaseCredentialsUsed || this.environment.isUserRequired();
        ModeledUser user = this.userService.retrieveUser(authenticationProvider, authenticatedUser);
        ModeledUserContext context = this.userContextProvider.get();
        if (user != null && !user.isDisabled()) {
            if (databaseRestrictionsApplicable) {
                if (!user.isAccountValid()) {
                    throw new TranslatableGuacamoleClientException("User account is no longer valid.", "LOGIN.ERROR_NOT_VALID");
                }
                if (!user.isAccountAccessible()) {
                    throw new TranslatableGuacamoleClientException("User account may not be used at this time.", "LOGIN.ERROR_NOT_ACCESSIBLE");
                }
            }
            if (databaseCredentialsUsed && (user.isExpired() || this.passwordPolicyService.isPasswordExpired(user))) {
                this.userService.resetExpiredPassword(user, authenticatedUser.getCredentials());
            }
        } else if (!databaseRestrictionsApplicable) {
            user = this.userService.retrieveSkeletonUser(authenticationProvider, authenticatedUser);
            if (this.environment.autoCreateAbsentAccounts()) {
                ModeledUser createdUser = (ModeledUser)this.userService.createObject((ModeledAuthenticatedUser)new PrivilegedModeledAuthenticatedUser(user.getCurrentUser()), user);
                user.setModel((UserModel)createdUser.getModel());
            }
        } else {
            throw new GuacamoleInvalidCredentialsException("Invalid login", CredentialsInfo.USERNAME_PASSWORD);
        }
        context.init(user.getCurrentUser());
        context.recordUserLogin();
        return context;
    }

    @Override
    public UserContext updateUserContext(AuthenticationProvider authenticationProvider, UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        return context;
    }
}

