/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.security;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.guacamole.auth.jdbc.security.PasswordContainsUsernameException;
import org.apache.guacamole.auth.jdbc.security.PasswordEncryptionService;
import org.apache.guacamole.auth.jdbc.security.PasswordMinimumLengthException;
import org.apache.guacamole.auth.jdbc.security.PasswordPolicy;
import org.apache.guacamole.auth.jdbc.security.PasswordRequiresDigitException;
import org.apache.guacamole.auth.jdbc.security.PasswordRequiresMultipleCaseException;
import org.apache.guacamole.auth.jdbc.security.PasswordRequiresSymbolException;
import org.apache.guacamole.auth.jdbc.security.PasswordReusedException;
import org.apache.guacamole.auth.jdbc.security.PasswordTooYoungException;
import org.apache.guacamole.auth.jdbc.user.ModeledUser;
import org.apache.guacamole.auth.jdbc.user.PasswordRecordMapper;
import org.apache.guacamole.auth.jdbc.user.PasswordRecordModel;

public class PasswordPolicyService {
    @Inject
    private JDBCEnvironment environment;
    @Inject
    private PasswordRecordMapper passwordRecordMapper;
    @Inject
    private PasswordEncryptionService encryptionService;
    private final Pattern CONTAINS_LOWERCASE = Pattern.compile("\\p{javaLowerCase}");
    private final Pattern CONTAINS_UPPERCASE = Pattern.compile("\\p{javaUpperCase}");
    private final Pattern CONTAINS_DIGIT = Pattern.compile("\\p{Digit}");
    private final Pattern CONTAINS_NON_ALPHANUMERIC = Pattern.compile("[^\\p{javaLowerCase}\\p{javaUpperCase}\\p{Digit}]");

    private boolean matches(String str, Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(str);
            if (matcher.find()) continue;
            return false;
        }
        return true;
    }

    private boolean matchesPreviousPasswords(String password, String username, int historySize) {
        if (historySize <= 0) {
            return false;
        }
        List<PasswordRecordModel> history = this.passwordRecordMapper.select(username, historySize);
        for (PasswordRecordModel record : history) {
            byte[] hash = this.encryptionService.createPasswordHash(password, record.getPasswordSalt());
            if (!Arrays.equals(hash, record.getPasswordHash())) continue;
            return true;
        }
        return false;
    }

    public void verifyPassword(String username, String password) throws GuacamoleException {
        PasswordPolicy policy = this.environment.getPasswordPolicy();
        if (password.length() < policy.getMinimumLength()) {
            throw new PasswordMinimumLengthException("Password does not meet minimum length requirements.", policy.getMinimumLength());
        }
        if (policy.isUsernameProhibited() && password.toLowerCase().contains(username.toLowerCase())) {
            throw new PasswordContainsUsernameException("Password must not contain username.");
        }
        if (policy.isMultipleCaseRequired() && !this.matches(password, this.CONTAINS_LOWERCASE, this.CONTAINS_UPPERCASE)) {
            throw new PasswordRequiresMultipleCaseException("Password must contain both uppercase and lowercase.");
        }
        if (policy.isNumericRequired() && !this.matches(password, this.CONTAINS_DIGIT)) {
            throw new PasswordRequiresDigitException("Passwords must contain at least one digit.");
        }
        if (policy.isNonAlphanumericRequired() && !this.matches(password, this.CONTAINS_NON_ALPHANUMERIC)) {
            throw new PasswordRequiresSymbolException("Passwords must contain at least one non-alphanumeric character.");
        }
        int historySize = policy.getHistorySize();
        if (this.matchesPreviousPasswords(password, username, historySize)) {
            throw new PasswordReusedException("Password matches a previously-used password.", historySize);
        }
    }

    private long getPasswordAge(ModeledUser user) {
        PasswordRecordModel passwordRecord = user.getPasswordRecord();
        if (passwordRecord == null) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long lastResetTime = passwordRecord.getPasswordDate().getTime();
        return TimeUnit.DAYS.convert(currentTime - lastResetTime, TimeUnit.MILLISECONDS);
    }

    public void verifyPasswordAge(ModeledUser user) throws GuacamoleException {
        PasswordPolicy policy = this.environment.getPasswordPolicy();
        long minimumAge = policy.getMinimumAge();
        long passwordAge = this.getPasswordAge(user);
        if (passwordAge < minimumAge) {
            throw new PasswordTooYoungException("Password was already recently changed.", minimumAge - passwordAge);
        }
    }

    public boolean isPasswordExpired(ModeledUser user) throws GuacamoleException {
        PasswordPolicy policy = this.environment.getPasswordPolicy();
        int maxPasswordAge = policy.getMaximumAge();
        if (maxPasswordAge == 0) {
            return false;
        }
        return this.getPasswordAge(user) >= (long)maxPasswordAge;
    }

    public void recordPassword(ModeledUser user) throws GuacamoleException {
        PasswordPolicy policy = this.environment.getPasswordPolicy();
        int historySize = policy.getHistorySize();
        if (historySize <= 0) {
            return;
        }
        this.passwordRecordMapper.insert(user.getPasswordRecord(), historySize);
    }
}

