/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharing.connection;

import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.sharing.SharedObjectManager;
import org.apache.guacamole.auth.jdbc.sharingprofile.ModeledSharingProfile;
import org.apache.guacamole.auth.jdbc.tunnel.ActiveConnectionRecord;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedConnectionDefinition {
    private final Logger logger = LoggerFactory.getLogger(SharedConnectionDefinition.class);
    private final ActiveConnectionRecord activeConnection;
    private final ModeledSharingProfile sharingProfile;
    private final String shareKey;
    private final SharedObjectManager<GuacamoleTunnel> tunnels = new SharedObjectManager<GuacamoleTunnel>(){

        @Override
        protected void cleanup(GuacamoleTunnel tunnel) {
            try {
                tunnel.close();
            }
            catch (GuacamoleException e) {
                SharedConnectionDefinition.this.logger.debug("Unable to close tunnel of shared connection.", (Throwable)e);
            }
        }
    };

    public SharedConnectionDefinition(ActiveConnectionRecord activeConnection, ModeledSharingProfile sharingProfile, String shareKey) {
        this.activeConnection = activeConnection;
        this.sharingProfile = sharingProfile;
        this.shareKey = shareKey;
    }

    public ActiveConnectionRecord getActiveConnection() {
        return this.activeConnection;
    }

    public ModeledSharingProfile getSharingProfile() {
        return this.sharingProfile;
    }

    public String getShareKey() {
        return this.shareKey;
    }

    public void registerTunnel(GuacamoleTunnel tunnel) {
        this.tunnels.register(tunnel);
    }

    public void invalidate() {
        this.tunnels.invalidate();
    }
}

