"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.XJsonWorker = void 0;
const grammar_1 = require("../grammar");
class XJsonWorker {
    constructor(ctx) {
        this.ctx = ctx;
    }
    async parse(modelUri) {
        if (!this.parser) {
            this.parser = grammar_1.createParser();
        }
        const model = this.ctx.getMirrorModels().find((m) => m.uri.toString() === modelUri);
        if (model) {
            return this.parser(model.getValue());
        }
    }
}
exports.XJsonWorker = XJsonWorker;
//# sourceMappingURL=xjson_worker.js.map