"""Generated client library for cloudresourcemanager version v2beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.cloudresourcemanager.v2beta1 import cloudresourcemanager_v2beta1_messages as messages


class CloudresourcemanagerV2beta1(base_api.BaseApiClient):
  """Generated client library for service cloudresourcemanager version v2beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudresourcemanager.googleapis.com/'
  MTLS_BASE_URL = ''

  _PACKAGE = 'cloudresourcemanager'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/cloud-platform.read-only']
  _VERSION = 'v2beta1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudresourcemanagerV2beta1'
  _URL_VERSION = 'v2beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudresourcemanager handle."""
    url = url or self.BASE_URL
    super(CloudresourcemanagerV2beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.folders = self.FoldersService(self)

  class FoldersService(base_api.BaseApiService):
    """Service class for the folders resource."""

    _NAME = 'folders'

    def __init__(self, client):
      super(CloudresourcemanagerV2beta1.FoldersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a Folder in the resource hierarchy.
Returns an Operation which can be used to track the progress of the
folder creation workflow.
Upon success the Operation.response field will be populated with the
created Folder.

In order to succeed, the addition of this new Folder must not violate
the Folder naming, height or fanout constraints.
+ The Folder's display_name must be distinct from all other Folder's that
share its parent.
+ The addition of the Folder must not cause the active Folder hierarchy
to exceed a height of 4. Note, the full active + deleted Folder hierarchy
is allowed to reach a height of 8; this provides additional headroom when
moving folders that contain deleted folders.
+ The addition of the Folder must not cause the total number of Folders
under its parent to exceed 100.

If the operation fails due to a folder constraint violation,
a PreconditionFailure explaining the violation will be returned.
If the failure occurs synchronously then the PreconditionFailure
will be returned via the Status.details field and if it occurs
asynchronously then the PreconditionFailure will be returned
via the the Operation.error field.

The caller must have `resourcemanager.folders.create` permission on the
identified parent.

      Args:
        request: (CloudresourcemanagerFoldersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.create',
        ordered_params=[],
        path_params=[],
        query_params=['parent'],
        relative_path='v2beta1/folders',
        request_field='folder',
        request_type_name='CloudresourcemanagerFoldersCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Requests deletion of a Folder. The Folder is moved into the.
[DELETE_REQUESTED] state immediately, and is deleted approximately 30 days
later. This method may only be called on an empty Folder in the [ACTIVE]
state, where a Folder is empty if it doesn't contain any Folders or
Projects in the [ACTIVE] state.
The caller must have `resourcemanager.folders.delete` permission on the
identified folder.

      Args:
        request: (CloudresourcemanagerFoldersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='cloudresourcemanager.folders.delete',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v2beta1/folders/{foldersId}',
        request_field='',
        request_type_name='CloudresourcemanagerFoldersDeleteRequest',
        response_type_name='Folder',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a Folder identified by the supplied resource name.
Valid Folder resource names have the format `folders/{folder_id}`
(for example, `folders/1234`).
The caller must have `resourcemanager.folders.get` permission on the
identified folder.

      Args:
        request: (CloudresourcemanagerFoldersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.folders.get',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v2beta1/folders/{foldersId}',
        request_field='',
        request_type_name='CloudresourcemanagerFoldersGetRequest',
        response_type_name='Folder',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a Folder. The returned policy may be.
empty if no such policy or resource exists. The `resource` field should
be the Folder's resource name, e.g. "folders/1234".
The caller must have `resourcemanager.folders.getIamPolicy` permission
on the identified folder.

      Args:
        request: (CloudresourcemanagerFoldersGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.getIamPolicy',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v2beta1/folders/{foldersId}:getIamPolicy',
        request_field='getIamPolicyRequest',
        request_type_name='CloudresourcemanagerFoldersGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Folders that are direct descendants of supplied parent resource.
List provides a strongly consistent view of the Folders underneath
the specified parent resource.
List returns Folders sorted based upon the (ascending) lexical ordering
of their display_name.
The caller must have `resourcemanager.folders.list` permission on the
identified parent.

      Args:
        request: (CloudresourcemanagerFoldersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFoldersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='cloudresourcemanager.folders.list',
        ordered_params=[],
        path_params=[],
        query_params=['pageSize', 'pageToken', 'parent', 'showDeleted'],
        relative_path='v2beta1/folders',
        request_field='',
        request_type_name='CloudresourcemanagerFoldersListRequest',
        response_type_name='ListFoldersResponse',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves a Folder under a new resource parent.
Returns an Operation which can be used to track the progress of the
folder move workflow.
Upon success the Operation.response field will be populated with the
moved Folder.
Upon failure, a FolderOperationError categorizing the failure cause will
be returned - if the failure occurs synchronously then the
FolderOperationError will be returned via the Status.details field
and if it occurs asynchronously then the FolderOperation will be returned
via the the Operation.error field.
In addition, the Operation.metadata field will be populated with a
FolderOperation message as an aid to stateless clients.
Folder moves will be rejected if they violate either the naming, height
or fanout constraints described in the [CreateFolder] documentation.
The caller must have `resourcemanager.folders.move` permission on the
folder's current and proposed new parent.

      Args:
        request: (CloudresourcemanagerFoldersMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.move',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v2beta1/folders/{foldersId}:move',
        request_field='moveFolderRequest',
        request_type_name='CloudresourcemanagerFoldersMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a Folder, changing its display_name.
Changes to the folder display_name will be rejected if they violate either
the display_name formatting rules or naming constraints described in
the [CreateFolder] documentation.
+ The Folder's display name must start and end with a letter or digit,
may contain letters, digits, spaces, hyphens and underscores and can be
no longer than 30 characters. This is captured by the regular expression:
[\p{L}\p{N}]({\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?.
The caller must have `resourcemanager.folders.update` permission on the
identified folder.

If the update fails due to the unique name constraint then a
PreconditionFailure explaining this violation will be returned
in the Status.details field.

      Args:
        request: (CloudresourcemanagerFoldersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='cloudresourcemanager.folders.patch',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=['updateMask'],
        relative_path='v2beta1/folders/{foldersId}',
        request_field='folder',
        request_type_name='CloudresourcemanagerFoldersPatchRequest',
        response_type_name='Folder',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Search for folders that match specific filter criteria.
Search provides an eventually consistent view of the folders a user has
access to which meet the specified filter criteria.

      Args:
        request: (SearchFoldersRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchFoldersResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v2beta1/folders:search',
        request_field='<request>',
        request_type_name='SearchFoldersRequest',
        response_type_name='SearchFoldersResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on a Folder, replacing any existing policy.
The `resource` field should be the Folder's resource name, e.g.
"folders/1234".
The caller must have `resourcemanager.folders.setIamPolicy` permission
on the identified folder.

      Args:
        request: (CloudresourcemanagerFoldersSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.setIamPolicy',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v2beta1/folders/{foldersId}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudresourcemanagerFoldersSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified Folder.
The `resource` field should be the Folder's resource name,
e.g. "folders/1234".

      Args:
        request: (CloudresourcemanagerFoldersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.testIamPermissions',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v2beta1/folders/{foldersId}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudresourcemanagerFoldersTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Cancels the deletion request for a Folder. This method may only be.
called on a Folder in the [DELETE_REQUESTED] state.
In order to succeed, the Folder's parent must be in the [ACTIVE] state.
In addition, reintroducing the folder into the tree must not violate
folder naming, height and fanout constraints described in the
[CreateFolder] documentation.
The caller must have `resourcemanager.folders.undelete` permission on the
identified folder.

      Args:
        request: (CloudresourcemanagerFoldersUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Folder) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='cloudresourcemanager.folders.undelete',
        ordered_params=['foldersId'],
        path_params=['foldersId'],
        query_params=[],
        relative_path='v2beta1/folders/{foldersId}:undelete',
        request_field='undeleteFolderRequest',
        request_type_name='CloudresourcemanagerFoldersUndeleteRequest',
        response_type_name='Folder',
        supports_download=False,
    )
