"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Logger = (function () {
    function Logger() {
    }
    Logger.warn = function (message) {
        var optionalParams = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            optionalParams[_i - 1] = arguments[_i];
        }
        if (Logger.isDevelopment() && !Logger.isTest()) {
            console.warn.apply(console, __spread([Logger.namespace + " " + message], optionalParams));
        }
    };
    Logger.expected = function (message, expected, received) {
        if (Logger.isDevelopment() && !Logger.isTest()) {
            console.warn(Logger.namespace + " " + message, "\n\n  Expected: " + expected + "\n  Received: " + received + "\n");
        }
    };
    Logger.error = function (message) {
        var optionalParams = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            optionalParams[_i - 1] = arguments[_i];
        }
        if (Logger.isDevelopment() && !Logger.isTest()) {
            console.warn.apply(console, __spread([Logger.namespace + " " + message], optionalParams));
        }
    };
    Logger.isDevelopment = function () {
        return process.env.NODE_ENV !== 'production';
    };
    Logger.isTest = function () {
        return process.env.NODE_ENV === 'test';
    };
    Logger.namespace = '[@elastic/charts]';
    return Logger;
}());
exports.Logger = Logger;
//# sourceMappingURL=logger.js.map