"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wizardSavedObjectTypeMigrations = void 0;

var _lodash = require("lodash");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const migrateIndexPattern = doc => {
  try {
    const visualizationStateJSON = (0, _lodash.get)(doc, 'attributes.visualizationState');
    const visualizationState = JSON.parse(visualizationStateJSON);
    const indexPatternId = visualizationState.indexPattern;
    const indexRefName = 'kibanaSavedObjectMeta.searchSourceJSON.index';

    if (indexPatternId && Array.isArray(doc.references)) {
      const searchSourceIndex = {
        indexRefName
      };
      const visualizationWithoutIndex = {
        searchFields: visualizationState.searchFields,
        activeVisualization: visualizationState.activeVisualization
      };
      doc.attributes.visualizationState = JSON.stringify(visualizationWithoutIndex);
      doc.references.push({
        name: indexRefName,
        type: 'index-pattern',
        id: indexPatternId
      });
      doc.attributes.version = 2;
      return { ...doc,
        attributes: { ...doc.attributes,
          kibanaSavedObjectMeta: {
            searchSourceJSON: JSON.stringify(searchSourceIndex)
          }
        }
      };
    }

    return doc;
  } catch (e) {
    return doc;
  }
};

const wizardSavedObjectTypeMigrations = {
  '2.3.0': (0, _lodash.flow)(migrateIndexPattern)
};
exports.wizardSavedObjectTypeMigrations = wizardSavedObjectTypeMigrations;