/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.hash;

import org.pentaho.di.core.exception.KettleValueException;

public class LongHashIndex {
    private static final int STANDARD_INDEX_SIZE = 512;
    private static final float STANDARD_LOAD_FACTOR = 0.78f;
    private LongHashIndexEntry[] index;
    private int size;
    private int resizeThresHold;

    public LongHashIndex(int size) {
        int factor2Size;
        for (factor2Size = 1; factor2Size < size; factor2Size <<= 1) {
        }
        this.size = factor2Size;
        this.resizeThresHold = (int)((float)factor2Size * 0.78f);
        this.index = new LongHashIndexEntry[factor2Size];
    }

    public LongHashIndex() {
        this(512);
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Long get(long key) throws KettleValueException {
        int hashCode = LongHashIndex.generateHashCode(key);
        int indexPointer = hashCode & this.index.length - 1;
        LongHashIndexEntry check = this.index[indexPointer];
        while (check != null) {
            if (check.hashCode == hashCode && check.equalsKey(key)) {
                return check.value;
            }
            check = check.nextEntry;
        }
        return null;
    }

    public void put(long key, Long value) throws KettleValueException {
        int hashCode = LongHashIndex.generateHashCode(key);
        int indexPointer = hashCode & this.index.length - 1;
        boolean searchEmptySpot = false;
        LongHashIndexEntry check = this.index[indexPointer];
        LongHashIndexEntry previousCheck = null;
        while (check != null) {
            searchEmptySpot = true;
            if (check.hashCode == hashCode && check.equalsKey(key)) {
                check.value = value;
                return;
            }
            previousCheck = check;
            check = check.nextEntry;
        }
        while (searchEmptySpot) {
            if (++indexPointer >= this.size) {
                indexPointer = 0;
            }
            if (this.index[indexPointer] != null) continue;
            searchEmptySpot = false;
        }
        this.index[indexPointer] = new LongHashIndexEntry(hashCode, key, value, this.index[indexPointer]);
        if (previousCheck != null) {
            previousCheck.nextEntry = this.index[indexPointer];
        }
        this.resize();
    }

    private final void resize() {
        ++this.size;
        if (this.size >= this.resizeThresHold) {
            LongHashIndexEntry[] oldIndex = this.index;
            int newSize = 2 * this.index.length;
            LongHashIndexEntry[] newIndex = new LongHashIndexEntry[newSize];
            for (int i = 0; i < oldIndex.length; ++i) {
                LongHashIndexEntry next;
                LongHashIndexEntry entry = oldIndex[i];
                if (entry == null) continue;
                oldIndex[i] = null;
                do {
                    next = entry.nextEntry;
                    int indexPointer = entry.hashCode & newSize - 1;
                    entry.nextEntry = newIndex[indexPointer];
                    newIndex[indexPointer] = entry;
                } while ((entry = next) != null);
            }
            this.index = newIndex;
            this.resizeThresHold = (int)((float)newSize * 0.78f);
        }
    }

    public static int generateHashCode(Long key) throws KettleValueException {
        return key.hashCode();
    }

    private static final class LongHashIndexEntry {
        private int hashCode;
        private long key;
        private long value;
        private LongHashIndexEntry nextEntry;

        public LongHashIndexEntry(int hashCode, Long key, Long value, LongHashIndexEntry nextEntry) {
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
            this.nextEntry = nextEntry;
        }

        public boolean equalsKey(long cmpKey) {
            return this.key == cmpKey;
        }

        public boolean equals(LongHashIndexEntry entry) {
            return entry.key == this.key;
        }

        public boolean equalsValue(long cmpValue) {
            return this.value == cmpValue;
        }
    }
}

