/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.ContentValidator;
import com.adobe.epubcheck.ctc.Epub3StructureCheck;
import com.adobe.epubcheck.ctc.EpubCSSCheck;
import com.adobe.epubcheck.ctc.EpubCfiCheck;
import com.adobe.epubcheck.ctc.EpubExtLinksCheck;
import com.adobe.epubcheck.ctc.EpubHTML5StructureCheck;
import com.adobe.epubcheck.ctc.EpubLangCheck;
import com.adobe.epubcheck.ctc.EpubMetaDataV2Check;
import com.adobe.epubcheck.ctc.EpubMetaDataV3Check;
import com.adobe.epubcheck.ctc.EpubNCXCheck;
import com.adobe.epubcheck.ctc.EpubNavCheck;
import com.adobe.epubcheck.ctc.EpubRenditionCheck;
import com.adobe.epubcheck.ctc.EpubSVGCheck;
import com.adobe.epubcheck.ctc.EpubScriptCheck;
import com.adobe.epubcheck.ctc.EpubSpanCheck;
import com.adobe.epubcheck.ctc.EpubSpineCheck;
import com.adobe.epubcheck.ctc.EpubStyleSheetsCheck;
import com.adobe.epubcheck.ctc.EpubTextContentCheck;
import com.adobe.epubcheck.ctc.EpubTocCheck;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.opf.DocumentValidator;

public class EpubCheckContentFactory
implements ContentValidator {
    private static final EpubCheckContentFactory instance = new EpubCheckContentFactory();

    public static EpubCheckContentFactory getInstance() {
        return instance;
    }

    @Override
    public DocumentValidator newInstance(Report report, ContentValidator.ValidationType vt, EpubPackage epack) {
        if (vt.equals((Object)ContentValidator.ValidationType.METADATA_V3)) {
            return new EpubMetaDataV3Check(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.METADATA_V2)) {
            return new EpubMetaDataV2Check(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.TEXT)) {
            return new EpubTextContentCheck(report, epack);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.NAV)) {
            return new EpubNavCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.NCX)) {
            return new EpubNCXCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.SPINE)) {
            return new EpubSpineCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.SCRIPT)) {
            return new EpubScriptCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.SPAN)) {
            return new EpubSpanCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.LANG)) {
            return new EpubLangCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.CSS_SEARCH)) {
            return new EpubCSSCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.LINK)) {
            return new EpubExtLinksCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.RENDITION)) {
            return new EpubRenditionCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.CFI)) {
            return new EpubCfiCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.HTML_STRUCTURE)) {
            return new EpubHTML5StructureCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.MULTIPLE_CSS)) {
            return new EpubStyleSheetsCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.EPUB3_STRUCTURE)) {
            return new Epub3StructureCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.TOC)) {
            return new EpubTocCheck(epack, report);
        }
        if (vt.equals((Object)ContentValidator.ValidationType.SVG)) {
            return new EpubSVGCheck(epack, report);
        }
        return null;
    }
}

