/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharingprofile;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.sharingprofile.ModeledSharingProfile;
import org.apache.guacamole.auth.jdbc.sharingprofile.SharingProfileService;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.SharingProfile;
import org.mybatis.guice.transactional.Transactional;

public class SharingProfileDirectory
extends RestrictedObject
implements Directory<SharingProfile> {
    @Inject
    private SharingProfileService sharingProfileService;

    public SharingProfile get(String identifier) throws GuacamoleException {
        return (SharingProfile)this.sharingProfileService.retrieveObject(this.getCurrentUser(), identifier);
    }

    @Transactional
    public Collection<SharingProfile> getAll(Collection<String> identifiers) throws GuacamoleException {
        return Collections.unmodifiableCollection(this.sharingProfileService.retrieveObjects(this.getCurrentUser(), identifiers));
    }

    @Transactional
    public Set<String> getIdentifiers() throws GuacamoleException {
        return this.sharingProfileService.getIdentifiers(this.getCurrentUser());
    }

    @Transactional
    public void add(SharingProfile object) throws GuacamoleException {
        this.sharingProfileService.createObject(this.getCurrentUser(), object);
    }

    @Transactional
    public void update(SharingProfile object) throws GuacamoleException {
        ModeledSharingProfile sharingProfile = (ModeledSharingProfile)object;
        this.sharingProfileService.updateObject(this.getCurrentUser(), sharingProfile);
    }

    @Transactional
    public void remove(String identifier) throws GuacamoleException {
        this.sharingProfileService.deleteObject(this.getCurrentUser(), identifier);
    }
}

