/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.tunnel;

import com.google.inject.Inject;
import java.util.Date;
import java.util.UUID;
import org.apache.guacamole.auth.jdbc.connection.ModeledConnection;
import org.apache.guacamole.auth.jdbc.connectiongroup.ModeledConnectionGroup;
import org.apache.guacamole.auth.jdbc.sharing.SharedConnectionMap;
import org.apache.guacamole.auth.jdbc.sharing.SharedObjectManager;
import org.apache.guacamole.auth.jdbc.sharingprofile.ModeledSharingProfile;
import org.apache.guacamole.auth.jdbc.user.RemoteAuthenticatedUser;
import org.apache.guacamole.net.AbstractGuacamoleTunnel;
import org.apache.guacamole.net.GuacamoleSocket;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ConnectionRecord;

public class ActiveConnectionRecord
implements ConnectionRecord {
    private RemoteAuthenticatedUser user;
    private ModeledConnectionGroup balancingGroup;
    private ModeledConnection connection;
    private ModeledSharingProfile sharingProfile;
    private final Date startDate = new Date();
    private final UUID uuid = UUID.randomUUID();
    private String connectionID;
    private GuacamoleTunnel tunnel;
    @Inject
    private SharedConnectionMap connectionMap;
    private final SharedObjectManager<String> shareKeyManager = new SharedObjectManager<String>(){

        @Override
        protected void cleanup(String key) {
            ActiveConnectionRecord.this.connectionMap.remove(key);
        }
    };

    private void init(RemoteAuthenticatedUser user, ModeledConnectionGroup balancingGroup, ModeledConnection connection, ModeledSharingProfile sharingProfile) {
        this.user = user;
        this.balancingGroup = balancingGroup;
        this.connection = connection;
        this.sharingProfile = sharingProfile;
    }

    public void init(RemoteAuthenticatedUser user, ModeledConnectionGroup balancingGroup, ModeledConnection connection) {
        this.init(user, balancingGroup, connection, null);
    }

    public void init(RemoteAuthenticatedUser user, ModeledConnection connection) {
        this.init(user, null, connection);
    }

    public void init(RemoteAuthenticatedUser user, ActiveConnectionRecord activeConnection, ModeledSharingProfile sharingProfile) {
        this.init(user, null, activeConnection.getConnection(), sharingProfile);
        this.connectionID = activeConnection.getConnectionID();
    }

    public RemoteAuthenticatedUser getUser() {
        return this.user;
    }

    public ModeledConnectionGroup getBalancingGroup() {
        return this.balancingGroup;
    }

    public ModeledConnection getConnection() {
        return this.connection;
    }

    public ModeledSharingProfile getSharingProfile() {
        return this.sharingProfile;
    }

    public boolean hasBalancingGroup() {
        return this.balancingGroup != null;
    }

    public boolean isPrimaryConnection() {
        return this.sharingProfile == null;
    }

    public String getConnectionIdentifier() {
        return this.connection.getIdentifier();
    }

    public String getConnectionName() {
        return this.connection.getName();
    }

    public String getSharingProfileIdentifier() {
        if (this.sharingProfile != null) {
            return this.sharingProfile.getIdentifier();
        }
        return null;
    }

    public String getSharingProfileName() {
        if (this.sharingProfile != null) {
            return this.sharingProfile.getName();
        }
        return null;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return null;
    }

    public String getRemoteHost() {
        return this.user.getRemoteHost();
    }

    public String getUsername() {
        return this.user.getIdentifier();
    }

    public boolean isActive() {
        return this.tunnel != null && this.tunnel.isOpen();
    }

    public GuacamoleTunnel getTunnel() {
        return this.tunnel;
    }

    public GuacamoleTunnel assignGuacamoleTunnel(final GuacamoleSocket socket, String connectionID) {
        this.tunnel = new AbstractGuacamoleTunnel(){

            public GuacamoleSocket getSocket() {
                return socket;
            }

            public UUID getUUID() {
                return ActiveConnectionRecord.this.uuid;
            }
        };
        if (this.isPrimaryConnection()) {
            this.connectionID = connectionID;
        }
        return this.tunnel;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public void registerShareKey(String key) {
        this.shareKeyManager.register(key);
    }

    public void invalidate() {
        this.shareKeyManager.invalidate();
    }
}

