/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.Assert;

public final class DelegatingAccessDeniedHandler
implements AccessDeniedHandler {
    private final LinkedHashMap<Class<? extends AccessDeniedException>, AccessDeniedHandler> handlers;
    private final AccessDeniedHandler defaultHandler;

    public DelegatingAccessDeniedHandler(LinkedHashMap<Class<? extends AccessDeniedException>, AccessDeniedHandler> handlers, AccessDeniedHandler defaultHandler) {
        Assert.notEmpty(handlers, "handlers cannot be null or empty");
        Assert.notNull((Object)defaultHandler, "defaultHandler cannot be null");
        this.handlers = handlers;
        this.defaultHandler = defaultHandler;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        for (Map.Entry<Class<? extends AccessDeniedException>, AccessDeniedHandler> entry : this.handlers.entrySet()) {
            Class<? extends AccessDeniedException> handlerClass = entry.getKey();
            if (!handlerClass.isAssignableFrom(accessDeniedException.getClass())) continue;
            AccessDeniedHandler handler = entry.getValue();
            handler.handle(request, response, accessDeniedException);
            return;
        }
        this.defaultHandler.handle(request, response, accessDeniedException);
    }
}

