/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AttributeUtil {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static Pattern INTEGER_PATTERN = Pattern.compile("^[ \t\n\r]*(-?[0-9]+)");

    private AttributeUtil() {
    }

    public static int parseInteger(String attrVal) {
        if (attrVal == null) {
            return Integer.MIN_VALUE;
        }
        Matcher m = INTEGER_PATTERN.matcher(attrVal);
        if (!m.matches()) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(m.group(1));
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
    }

    public static int parseNonNegativeInteger(String attrVal) {
        int rv = AttributeUtil.parseInteger(attrVal);
        if (rv < 0) {
            return -1;
        }
        return rv;
    }

    public static int parsePositiveInteger(String attrVal) {
        int rv = AttributeUtil.parseInteger(attrVal);
        if (rv < 1) {
            return -1;
        }
        return rv;
    }

    public static String[] split(String value) {
        if (value == null || "".equals(value)) {
            return EMPTY_STRING_ARRAY;
        }
        int len = value.length();
        LinkedList<String> list = new LinkedList<String>();
        boolean collectingSpace = true;
        int start = 0;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                if (collectingSpace) continue;
                list.add(value.substring(start, i));
                collectingSpace = true;
                continue;
            }
            if (!collectingSpace) continue;
            start = i;
            collectingSpace = false;
        }
        if (start < len) {
            char c;
            int end = len;
            for (int i = 1; len > i && ((c = value.charAt(len - i)) == ' ' || c == '\t' || c == '\n' || c == '\r'); ++i) {
                --end;
            }
            list.add(value.substring(start, end));
        }
        return list.toArray(EMPTY_STRING_ARRAY);
    }

    public static boolean lowerCaseLiteralEqualsIgnoreAsciiCaseString(String lowerCaseLiteral, String string) {
        if (string == null) {
            return false;
        }
        if (lowerCaseLiteral.length() != string.length()) {
            return false;
        }
        for (int i = 0; i < lowerCaseLiteral.length(); ++i) {
            char c0 = lowerCaseLiteral.charAt(i);
            char c1 = string.charAt(i);
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }
}

