/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.codelinks;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;

public class CodeLink {
    private final String myCodeFragment;
    private final String myUrl;
    private int myHash;

    public CodeLink(@NotNull String codeFragment, @NotNull String url) {
        if (codeFragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/codelinks/CodeLink.<init> must not be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/almworks/tracklink/codelinks/CodeLink.<init> must not be null");
        }
        this.myHash = 0;
        this.myCodeFragment = codeFragment;
        this.myUrl = url;
    }

    public String getCodeFragment() {
        return this.myCodeFragment;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public int hashCode() {
        int h = this.myHash;
        if (h == 0) {
            this.myHash = h = Comparing.hashcode((Object)this.myCodeFragment) + 37 * Comparing.hashcode((Object)this.myUrl);
        }
        return h;
    }

    public String toString() {
        return "CodeLink: [" + this.myCodeFragment + "] -> [" + this.myUrl + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CodeLink) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            CodeLink otherLink = (CodeLink)obj;
            return Comparing.strEqual((String)otherLink.myUrl, (String)this.myUrl) && Comparing.strEqual((String)otherLink.myCodeFragment, (String)this.myCodeFragment);
        }
        return false;
    }
}

