/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.StateFullPathCompleter;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;

@CommandDefinition(name="cd", description="Changes the current node")
public class StateCdCommand
extends PmSessionCommand {
    @Argument(completer=StateFullPathCompleter.class, description="Feature pack node path")
    private String path;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        if (this.path == null || this.path.isEmpty()) {
            return;
        }
        try {
            this.cdFp(session);
        }
        catch (PathConsumerException | PathParserException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.enterFPFailed(), ex);
        }
    }

    private void cdFp(PmCommandInvocation session) throws CommandExecutionException, PathParserException, PathConsumerException {
        PmSession pm = session.getPmSession();
        String currentPath = pm.getCurrentPath();
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(pm.getContainer(), true);
        if (this.path.startsWith("/")) {
            pm.setCurrentPath(null);
        } else if (this.path.equals("..")) {
            if (currentPath == null) {
                throw new CommandExecutionException("No path entered");
            }
            if (currentPath.equals("/")) {
                return;
            }
            int i = (currentPath = currentPath.substring(0, currentPath.length() - 1)).lastIndexOf("/");
            this.path = i < 0 ? "/" : currentPath.substring(0, i);
            if (this.path.isEmpty()) {
                this.path = "/";
            }
            pm.setCurrentPath(null);
        } else {
            this.path = currentPath + this.path;
        }
        PathParser.parse(this.path, consumer);
        Group grp = consumer.getCurrentNode(this.path);
        if (grp == null) {
            return;
        }
        if (!this.path.endsWith("/")) {
            this.path = this.path + '/';
        }
        pm.setCurrentPath(this.path);
        String prompt = "/".equals(grp.getIdentity().getName()) ? "/" : grp.getIdentity().getName() + '/';
        session.setPrompt(session.getPmSession().buildPrompt(prompt));
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }
}

