// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourcePrivatecaCertificate() *schema.Resource {
	return &schema.Resource{
		Create: resourcePrivatecaCertificateCreate,
		Read:   resourcePrivatecaCertificateRead,
		Update: resourcePrivatecaCertificateUpdate,
		Delete: resourcePrivatecaCertificateDelete,

		Importer: &schema.ResourceImporter{
			State: resourcePrivatecaCertificateImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"location": {
				Type:     schema.TypeString,
				Required: true,
				ForceNew: true,
				Description: `Location of the Certificate. A full list of valid locations can be found by
running 'gcloud privateca locations list'.`,
			},
			"name": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The name for this Certificate.`,
			},
			"pool": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The name of the CaPool this Certificate belongs to.`,
			},
			"certificate_template": {
				Type:             schema.TypeString,
				Optional:         true,
				ForceNew:         true,
				DiffSuppressFunc: compareResourceNames,
				Description: `The resource name for a CertificateTemplate used to issue this certificate,
in the format 'projects/*/locations/*/certificateTemplates/*'. If this is specified,
the caller must have the necessary permission to use this template. If this is
omitted, no template will be used. This template must be in the same location
as the Certificate.`,
			},
			"certificate_authority": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `The Certificate Authority ID that should issue the certificate. For example, to issue a Certificate from
a Certificate Authority with resource name 'projects/my-project/locations/us-central1/caPools/my-pool/certificateAuthorities/my-ca',
argument 'pool' should be set to 'projects/my-project/locations/us-central1/caPools/my-pool', argument 'certificate_authority'
should be set to 'my-ca'.`,
			},
			"config": {
				Type:        schema.TypeList,
				Optional:    true,
				ForceNew:    true,
				Description: `The config used to create a self-signed X.509 certificate or CSR.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"public_key": {
							Type:        schema.TypeList,
							Required:    true,
							ForceNew:    true,
							Description: `A PublicKey describes a public key.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"format": {
										Type:         schema.TypeString,
										Required:     true,
										ForceNew:     true,
										ValidateFunc: validateEnum([]string{"KEY_TYPE_UNSPECIFIED", "PEM"}),
										Description:  `The format of the public key. Currently, only PEM format is supported. Possible values: ["KEY_TYPE_UNSPECIFIED", "PEM"]`,
									},
									"key": {
										Type:        schema.TypeString,
										Optional:    true,
										ForceNew:    true,
										Description: `Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.`,
									},
								},
							},
						},
						"subject_config": {
							Type:        schema.TypeList,
							Required:    true,
							ForceNew:    true,
							Description: `Specifies some of the values in a certificate that are related to the subject.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"subject": {
										Type:        schema.TypeList,
										Required:    true,
										ForceNew:    true,
										Description: `Contains distinguished name fields such as the location and organization.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"common_name": {
													Type:        schema.TypeString,
													Required:    true,
													ForceNew:    true,
													Description: `The common name of the distinguished name.`,
												},
												"organization": {
													Type:        schema.TypeString,
													Required:    true,
													ForceNew:    true,
													Description: `The organization of the subject.`,
												},
												"country_code": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The country code of the subject.`,
												},
												"locality": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The locality or city of the subject.`,
												},
												"organizational_unit": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The organizational unit of the subject.`,
												},
												"postal_code": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The postal code of the subject.`,
												},
												"province": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The province, territory, or regional state of the subject.`,
												},
												"street_address": {
													Type:        schema.TypeString,
													Optional:    true,
													ForceNew:    true,
													Description: `The street address of the subject.`,
												},
											},
										},
									},
									"subject_alt_name": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `The subject alternative name fields.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"dns_names": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Contains only valid, fully-qualified host names.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
													AtLeastOneOf: []string{"config.0.subject_config.0.subject_alt_name.0.dns_names", "config.0.subject_config.0.subject_alt_name.0.uris", "config.0.subject_config.0.subject_alt_name.0.email_addresses", "config.0.subject_config.0.subject_alt_name.0.ip_addresses"},
												},
												"email_addresses": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Contains only valid RFC 2822 E-mail addresses.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
													AtLeastOneOf: []string{"config.0.subject_config.0.subject_alt_name.0.dns_names", "config.0.subject_config.0.subject_alt_name.0.uris", "config.0.subject_config.0.subject_alt_name.0.email_addresses", "config.0.subject_config.0.subject_alt_name.0.ip_addresses"},
												},
												"ip_addresses": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
													AtLeastOneOf: []string{"config.0.subject_config.0.subject_alt_name.0.dns_names", "config.0.subject_config.0.subject_alt_name.0.uris", "config.0.subject_config.0.subject_alt_name.0.email_addresses", "config.0.subject_config.0.subject_alt_name.0.ip_addresses"},
												},
												"uris": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `Contains only valid RFC 3986 URIs.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
													AtLeastOneOf: []string{"config.0.subject_config.0.subject_alt_name.0.dns_names", "config.0.subject_config.0.subject_alt_name.0.uris", "config.0.subject_config.0.subject_alt_name.0.email_addresses", "config.0.subject_config.0.subject_alt_name.0.ip_addresses"},
												},
											},
										},
									},
								},
							},
						},
						"x509_config": {
							Type:        schema.TypeList,
							Required:    true,
							ForceNew:    true,
							Description: `Describes how some of the technical X.509 fields in a certificate should be populated.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"key_usage": {
										Type:        schema.TypeList,
										Required:    true,
										ForceNew:    true,
										Description: `Indicates the intended use for keys that correspond to a certificate.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"base_key_usage": {
													Type:        schema.TypeList,
													Required:    true,
													ForceNew:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"cert_sign": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to sign certificates.`,
															},
															"content_commitment": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".`,
															},
															"crl_sign": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used sign certificate revocation lists.`,
															},
															"data_encipherment": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to encipher data.`,
															},
															"decipher_only": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to decipher only.`,
															},
															"digital_signature": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used for digital signatures.`,
															},
															"encipher_only": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to encipher only.`,
															},
															"key_agreement": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used in a key agreement protocol.`,
															},
															"key_encipherment": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `The key may be used to encipher other keys.`,
															},
														},
													},
												},
												"extended_key_usage": {
													Type:        schema.TypeList,
													Required:    true,
													ForceNew:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"client_auth": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.`,
															},
															"code_signing": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".`,
															},
															"email_protection": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".`,
															},
															"ocsp_signing": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".`,
															},
															"server_auth": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.`,
															},
															"time_stamping": {
																Type:        schema.TypeBool,
																Optional:    true,
																ForceNew:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".`,
															},
														},
													},
												},
												"unknown_extended_key_usages": {
													Type:        schema.TypeList,
													Optional:    true,
													ForceNew:    true,
													Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"object_id_path": {
																Type:        schema.TypeList,
																Required:    true,
																ForceNew:    true,
																Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																Elem: &schema.Schema{
																	Type: schema.TypeInt,
																},
															},
														},
													},
												},
											},
										},
									},
									"additional_extensions": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"critical": {
													Type:     schema.TypeBool,
													Required: true,
													ForceNew: true,
													Description: `Indicates whether or not this extension is critical (i.e., if the client does not know how to
handle this extension, the client should consider this to be an error).`,
												},
												"object_id": {
													Type:        schema.TypeList,
													Required:    true,
													ForceNew:    true,
													Description: `Describes values that are relevant in a CA certificate.`,
													MaxItems:    1,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"object_id_path": {
																Type:        schema.TypeList,
																Required:    true,
																ForceNew:    true,
																Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																Elem: &schema.Schema{
																	Type: schema.TypeInt,
																},
															},
														},
													},
												},
												"value": {
													Type:        schema.TypeString,
													Required:    true,
													ForceNew:    true,
													Description: `The value of this X.509 extension. A base64-encoded string.`,
												},
											},
										},
									},
									"aia_ocsp_servers": {
										Type:     schema.TypeList,
										Optional: true,
										ForceNew: true,
										Description: `Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
"Authority Information Access" extension in the certificate.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"ca_options": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Describes values that are relevant in a CA certificate.`,
										MaxItems:    1,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"is_ca": {
													Type:        schema.TypeBool,
													Optional:    true,
													ForceNew:    true,
													Description: `When true, the "CA" in Basic Constraints extension will be set to true.`,
												},
												"max_issuer_path_length": {
													Type:     schema.TypeInt,
													Optional: true,
													ForceNew: true,
													Description: `Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.`,
												},
												"non_ca": {
													Type:     schema.TypeBool,
													Optional: true,
													ForceNew: true,
													Description: `When true, the "CA" in Basic Constraints extension will be set to false. 
If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.`,
												},
												"zero_max_issuer_path_length": {
													Type:     schema.TypeBool,
													Optional: true,
													ForceNew: true,
													Description: `When true, the "path length constraint" in Basic Constraints extension will be set to 0.
if both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
the max path length will be omitted from the CA certificate.`,
												},
											},
										},
									},
									"policy_ids": {
										Type:        schema.TypeList,
										Optional:    true,
										ForceNew:    true,
										Description: `Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"object_id_path": {
													Type:        schema.TypeList,
													Required:    true,
													ForceNew:    true,
													Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
											},
										},
									},
								},
							},
						},
					},
				},
				ExactlyOneOf: []string{"pem_csr", "config"},
			},
			"labels": {
				Type:        schema.TypeMap,
				Optional:    true,
				Description: `Labels with user-defined metadata to apply to this resource.`,
				Elem:        &schema.Schema{Type: schema.TypeString},
			},
			"lifetime": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
"notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
fractional digits, terminated by 's'. Example: "3.5s".`,
				Default: "315360000s",
			},
			"pem_csr": {
				Type:         schema.TypeString,
				Optional:     true,
				ForceNew:     true,
				Description:  `Immutable. A pem-encoded X.509 certificate signing request (CSR).`,
				ExactlyOneOf: []string{"pem_csr", "config"},
			},
			"certificate_description": {
				Type:        schema.TypeList,
				Computed:    true,
				Description: `Output only. Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if this field is present.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"aia_issuing_certificate_urls": {
							Type:        schema.TypeList,
							Computed:    true,
							Description: `Describes lists of issuer CA certificate URLs that appear in the "Authority Information Access" extension in the certificate.`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"authority_key_id": {
							Type:        schema.TypeList,
							Computed:    true,
							Description: `Identifies the subjectKeyId of the parent certificate, per https://tools.ietf.org/html/rfc5280#section-4.2.1.1`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"key_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `Optional. The value of this KeyId encoded in lowercase hexadecimal. This is most likely the 160 bit SHA-1 hash of the public key.`,
									},
								},
							},
						},
						"cert_fingerprint": {
							Type:        schema.TypeList,
							Computed:    true,
							Description: `The hash of the x.509 certificate.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"sha256_hash": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `The SHA 256 hash, encoded in hexadecimal, of the DER x509 certificate.`,
									},
								},
							},
						},
						"config_values": {
							Type:        schema.TypeList,
							Computed:    true,
							Deprecated:  "Deprecated in favor of `x509_description`.",
							Description: `Describes some of the technical fields in a certificate.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"key_usage": {
										Type:        schema.TypeList,
										Computed:    true,
										Description: `Indicates the intended use for keys that correspond to a certificate.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"base_key_usage": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"key_usage_options": {
																Type:        schema.TypeList,
																Computed:    true,
																Description: `Describes high-level ways in which a key may be used.`,
																Elem: &schema.Resource{
																	Schema: map[string]*schema.Schema{
																		"cert_sign": {
																			Type:        schema.TypeBool,
																			Computed:    true,
																			Description: `The key may be used to sign certificates.`,
																		},
																		"content_commitment": {
																			Type:        schema.TypeBool,
																			Computed:    true,
																			Description: `The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".`,
																		},
																		"crl_sign": {
																			Type:        schema.TypeBool,
																			Computed:    true,
																			Description: `The key may be used sign certificate revocation lists.`,
																		},
																		"data_encipherment": {
																			Type:        schema.TypeBool,
																			Computed:    true,
																			Description: `The key may be used to encipher data.`,
																		},
																		"decipher_only": {
																			Type:        schema.TypeBool,
																			Computed:    true,
																			Description: `The key may be used to decipher only.`,
																		},
																		"digital_signature": {
																			Type:        schema.TypeBool,
																			Computed:    true,
																			Description: `The key may be used for digital signatures.`,
																		},
																		"encipher_only": {
																			Type:        schema.TypeBool,
																			Computed:    true,
																			Description: `The key may be used to encipher only.`,
																		},
																		"key_agreement": {
																			Type:        schema.TypeBool,
																			Computed:    true,
																			Description: `The key may be used in a key agreement protocol.`,
																		},
																		"key_encipherment": {
																			Type:        schema.TypeBool,
																			Computed:    true,
																			Description: `The key may be used to encipher other keys.`,
																		},
																	},
																},
															},
														},
													},
												},
												"extended_key_usage": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"client_auth": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.`,
															},
															"code_signing": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".`,
															},
															"email_protection": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".`,
															},
															"ocsp_signing": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".`,
															},
															"server_auth": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.`,
															},
															"time_stamping": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".`,
															},
														},
													},
												},
												"unknown_extended_key_usages": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"obect_id": {
																Type:        schema.TypeList,
																Computed:    true,
																Description: `Required. Describes how some of the technical fields in a certificate should be populated.`,
																Elem: &schema.Resource{
																	Schema: map[string]*schema.Schema{
																		"object_id_path": {
																			Type:        schema.TypeList,
																			Computed:    true,
																			Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																			Elem: &schema.Schema{
																				Type: schema.TypeInt,
																			},
																		},
																	},
																},
															},
														},
													},
												},
											},
										},
									},
								},
							},
						},
						"crl_distribution_points": {
							Type:        schema.TypeList,
							Computed:    true,
							Description: `Describes a list of locations to obtain CRL information, i.e. the DistributionPoint.fullName described by https://tools.ietf.org/html/rfc5280#section-4.2.1.13`,
							Elem: &schema.Schema{
								Type: schema.TypeString,
							},
						},
						"public_key": {
							Type:        schema.TypeList,
							Computed:    true,
							Description: `A PublicKey describes a public key.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"format": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `The format of the public key. Currently, only PEM format is supported.`,
									},
									"key": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `Required. A public key. When this is specified in a request, the padding and encoding can be any of the options described by the respective 'KeyType' value. When this is generated by the service, it will always be an RFC 5280 SubjectPublicKeyInfo structure containing an algorithm identifier and a key. A base64-encoded string.`,
									},
								},
							},
						},
						"subject_description": {
							Type:        schema.TypeList,
							Computed:    true,
							Description: `Describes some of the values in a certificate that are related to the subject and lifetime.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"hex_serial_number": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `The serial number encoded in lowercase hexadecimal.`,
									},
									"lifetime": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `For convenience, the actual lifetime of an issued certificate. Corresponds to 'notAfterTime' - 'notBeforeTime'.`,
									},
									"not_after_time": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `The time at which the certificate expires.`,
									},
									"not_before_time": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `The time at which the certificate becomes valid.`,
									},
									"subject": {
										Type:        schema.TypeList,
										Computed:    true,
										Description: `Contains distinguished name fields such as the location and organization.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"common_name": {
													Type:        schema.TypeString,
													Computed:    true,
													Description: `The "common name" of the distinguished name.`,
												},
												"country_code": {
													Type:        schema.TypeString,
													Computed:    true,
													Description: `The country code of the subject.`,
												},
												"locality": {
													Type:        schema.TypeString,
													Computed:    true,
													Description: `The locality or city of the subject.`,
												},
												"organization": {
													Type:        schema.TypeString,
													Computed:    true,
													Description: `The organization of the subject.`,
												},
												"organizational_unit": {
													Type:        schema.TypeString,
													Computed:    true,
													Description: `The organizationalUnit of the subject.`,
												},
												"postal_code": {
													Type:        schema.TypeString,
													Computed:    true,
													Description: `The postalCode or city of the subject.`,
												},
												"province": {
													Type:        schema.TypeString,
													Computed:    true,
													Description: `The province of the subject.`,
												},
												"street_address": {
													Type:        schema.TypeString,
													Computed:    true,
													Description: `The streetAddress or city of the subject.`,
												},
											},
										},
									},
									"subject_alt_name": {
										Type:        schema.TypeList,
										Computed:    true,
										Description: `The subject alternative name fields.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"custom_sans": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Contains additional subject alternative name values.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"critical": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Required. Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).`,
															},
															"obect_id": {
																Type:        schema.TypeList,
																Computed:    true,
																Description: `Describes how some of the technical fields in a certificate should be populated.`,
																Elem: &schema.Resource{
																	Schema: map[string]*schema.Schema{
																		"object_id_path": {
																			Type:        schema.TypeList,
																			Computed:    true,
																			Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																			Elem: &schema.Schema{
																				Type: schema.TypeInt,
																			},
																		},
																	},
																},
															},
															"value": {
																Type:        schema.TypeString,
																Computed:    true,
																Description: `The value of this X.509 extension.`,
															},
														},
													},
												},
												"dns_names": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Contains only valid, fully-qualified host names.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
												"email_addresses": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Contains only valid RFC 2822 E-mail addresses.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
												"ip_addresses": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
												"uris": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Contains only valid RFC 3986 URIs.`,
													Elem: &schema.Schema{
														Type: schema.TypeString,
													},
												},
											},
										},
									},
								},
							},
						},
						"subject_key_id": {
							Type:        schema.TypeList,
							Computed:    true,
							Description: `Provides a means of identifiying certificates that contain a particular public key, per https://tools.ietf.org/html/rfc5280#section-4.2.1.2.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"key_id": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `Optional. The value of this KeyId encoded in lowercase hexadecimal. This is most likely the 160 bit SHA-1 hash of the public key.`,
									},
								},
							},
						},
						"x509_description": {
							Type:        schema.TypeList,
							Computed:    true,
							Description: `A structured description of the issued X.509 certificate.`,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"additional_extensions": {
										Type:        schema.TypeList,
										Computed:    true,
										Description: `Describes custom X.509 extensions.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"value": {
													Type:        schema.TypeString,
													Optional:    true,
													Description: `The value of this X.509 extension. A base64-encoded string.`,
												},
												"critical": {
													Type:     schema.TypeBool,
													Computed: true,
													Description: `Indicates whether or not this extension is critical (i.e., if the client does not know how to
handle this extension, the client should consider this to be an error).`,
												},
												"object_id": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Describes values that are relevant in a CA certificate.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"object_id_path": {
																Type:        schema.TypeList,
																Computed:    true,
																Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																Elem: &schema.Schema{
																	Type: schema.TypeInt,
																},
															},
														},
													},
												},
											},
										},
									},
									"aia_ocsp_servers": {
										Type:     schema.TypeList,
										Computed: true,
										Description: `Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
"Authority Information Access" extension in the certificate.`,
										Elem: &schema.Schema{
											Type: schema.TypeString,
										},
									},
									"ca_options": {
										Type:        schema.TypeList,
										Computed:    true,
										Description: `Describes values that are relevant in a CA certificate.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"is_ca": {
													Type:        schema.TypeBool,
													Computed:    true,
													Description: `When true, the "CA" in Basic Constraints extension will be set to true.`,
												},
												"max_issuer_path_length": {
													Type:     schema.TypeInt,
													Computed: true,
													Description: `Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.`,
												},
											},
										},
									},
									"key_usage": {
										Type:        schema.TypeList,
										Computed:    true,
										Description: `Indicates the intended use for keys that correspond to a certificate.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"base_key_usage": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"cert_sign": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `The key may be used to sign certificates.`,
															},
															"content_commitment": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".`,
															},
															"crl_sign": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `The key may be used sign certificate revocation lists.`,
															},
															"data_encipherment": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `The key may be used to encipher data.`,
															},
															"decipher_only": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `The key may be used to decipher only.`,
															},
															"digital_signature": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `The key may be used for digital signatures.`,
															},
															"encipher_only": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `The key may be used to encipher only.`,
															},
															"key_agreement": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `The key may be used in a key agreement protocol.`,
															},
															"key_encipherment": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `The key may be used to encipher other keys.`,
															},
														},
													},
												},
												"extended_key_usage": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `Describes high-level ways in which a key may be used.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"client_auth": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.`,
															},
															"code_signing": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".`,
															},
															"email_protection": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".`,
															},
															"ocsp_signing": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".`,
															},
															"server_auth": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.`,
															},
															"time_stamping": {
																Type:        schema.TypeBool,
																Computed:    true,
																Description: `Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".`,
															},
														},
													},
												},
												"unknown_extended_key_usages": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
													Elem: &schema.Resource{
														Schema: map[string]*schema.Schema{
															"object_id_path": {
																Type:        schema.TypeList,
																Computed:    true,
																Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
																Elem: &schema.Schema{
																	Type: schema.TypeInt,
																},
															},
														},
													},
												},
											},
										},
									},
									"policy_ids": {
										Type:        schema.TypeList,
										Computed:    true,
										Description: `Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.`,
										Elem: &schema.Resource{
											Schema: map[string]*schema.Schema{
												"object_id_path": {
													Type:        schema.TypeList,
													Computed:    true,
													Description: `An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.`,
													Elem: &schema.Schema{
														Type: schema.TypeInt,
													},
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
			"create_time": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The time that this resource was created on the server.
This is in RFC3339 text format.`,
			},
			"issuer_certificate_authority": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The resource name of the issuing CertificateAuthority in the format 'projects/*/locations/*/caPools/*/certificateAuthorities/*'.`,
			},
			"pem_certificate": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `Output only. The pem-encoded, signed X.509 certificate.`,
			},
			"pem_certificate_chain": {
				Type:        schema.TypeList,
				Computed:    true,
				Description: `The chain that may be used to verify the X.509 certificate. Expected to be in issuer-to-root order according to RFC 5246.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"pem_certificates": {
				Type:        schema.TypeList,
				Computed:    true,
				Deprecated:  "Deprecated in favor of `pem_certificate_chain`.",
				Description: `Required. Expected to be in leaf-to-root order according to RFC 5246.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"revocation_details": {
				Type:     schema.TypeList,
				Computed: true,
				Description: `Output only. Details regarding the revocation of this Certificate. This Certificate is 
considered revoked if and only if this field is present.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"revocation_state": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `Indicates why a Certificate was revoked.`,
						},
						"revocation_time": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The time at which this Certificate was revoked.`,
						},
					},
				},
			},
			"update_time": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `Output only. The time at which this CertificateAuthority was updated.
This is in RFC3339 text format.`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourcePrivatecaCertificateCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	lifetimeProp, err := expandPrivatecaCertificateLifetime(d.Get("lifetime"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("lifetime"); !isEmptyValue(reflect.ValueOf(lifetimeProp)) && (ok || !reflect.DeepEqual(v, lifetimeProp)) {
		obj["lifetime"] = lifetimeProp
	}
	certificateTemplateProp, err := expandPrivatecaCertificateCertificateTemplate(d.Get("certificate_template"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("certificate_template"); !isEmptyValue(reflect.ValueOf(certificateTemplateProp)) && (ok || !reflect.DeepEqual(v, certificateTemplateProp)) {
		obj["certificateTemplate"] = certificateTemplateProp
	}
	labelsProp, err := expandPrivatecaCertificateLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(labelsProp)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}
	pemCsrProp, err := expandPrivatecaCertificatePemCsr(d.Get("pem_csr"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("pem_csr"); !isEmptyValue(reflect.ValueOf(pemCsrProp)) && (ok || !reflect.DeepEqual(v, pemCsrProp)) {
		obj["pemCsr"] = pemCsrProp
	}
	configProp, err := expandPrivatecaCertificateConfig(d.Get("config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("config"); !isEmptyValue(reflect.ValueOf(configProp)) && (ok || !reflect.DeepEqual(v, configProp)) {
		obj["config"] = configProp
	}

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates?certificateId={{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new Certificate: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Certificate: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	// Only include linked certificate authority if the user specified it
	if p, ok := d.GetOk("certificate_authority"); ok {
		url, err = addQueryParams(url, map[string]string{"issuingCertificateAuthorityId": p.(string)})
		if err != nil {
			return err
		}
	}
	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating Certificate: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating Certificate %q: %#v", d.Id(), res)

	return resourcePrivatecaCertificateRead(d, meta)
}

func resourcePrivatecaCertificateRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Certificate: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("PrivatecaCertificate %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}

	if err := d.Set("issuer_certificate_authority", flattenPrivatecaCertificateIssuerCertificateAuthority(res["issuerCertificateAuthority"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("lifetime", flattenPrivatecaCertificateLifetime(res["lifetime"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("revocation_details", flattenPrivatecaCertificateRevocationDetails(res["revocationDetails"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("pem_certificate", flattenPrivatecaCertificatePemCertificate(res["pemCertificate"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("certificate_description", flattenPrivatecaCertificateCertificateDescription(res["certificateDescription"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("pem_certificate_chain", flattenPrivatecaCertificatePemCertificateChain(res["pemCertificateChain"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("pem_certificates", flattenPrivatecaCertificatePemCertificates(res["pemCertificates"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("create_time", flattenPrivatecaCertificateCreateTime(res["createTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("update_time", flattenPrivatecaCertificateUpdateTime(res["updateTime"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("certificate_template", flattenPrivatecaCertificateCertificateTemplate(res["certificateTemplate"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("labels", flattenPrivatecaCertificateLabels(res["labels"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("pem_csr", flattenPrivatecaCertificatePemCsr(res["pemCsr"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}
	if err := d.Set("config", flattenPrivatecaCertificateConfig(res["config"], d, config)); err != nil {
		return fmt.Errorf("Error reading Certificate: %s", err)
	}

	return nil
}

func resourcePrivatecaCertificateUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Certificate: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	labelsProp, err := expandPrivatecaCertificateLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating Certificate %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("labels") {
		updateMask = append(updateMask, "labels")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating Certificate %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating Certificate %q: %#v", d.Id(), res)
	}

	return resourcePrivatecaCertificateRead(d, meta)
}

func resourcePrivatecaCertificateDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Certificate: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{PrivatecaBasePath}}projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}:revoke")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting Certificate %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "Certificate")
	}

	log.Printf("[DEBUG] Finished deleting Certificate %q: %#v", d.Id(), res)
	return nil
}

func resourcePrivatecaCertificateImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/locations/(?P<location>[^/]+)/caPools/(?P<pool>[^/]+)/certificates/(?P<name>[^/]+)",
		"(?P<project>[^/]+)/(?P<location>[^/]+)/(?P<pool>[^/]+)/(?P<name>[^/]+)",
		"(?P<location>[^/]+)/(?P<pool>[^/]+)/(?P<name>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/caPools/{{pool}}/certificates/{{name}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenPrivatecaCertificateIssuerCertificateAuthority(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateLifetime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateRevocationDetails(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["revocation_state"] =
		flattenPrivatecaCertificateRevocationDetailsRevocationState(original["revocationState"], d, config)
	transformed["revocation_time"] =
		flattenPrivatecaCertificateRevocationDetailsRevocationTime(original["revocationTime"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateRevocationDetailsRevocationState(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateRevocationDetailsRevocationTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificatePemCertificate(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["subject_description"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescription(original["subjectDescription"], d, config)
	transformed["x509_description"] =
		flattenPrivatecaCertificateCertificateDescriptionX509Description(original["x509Description"], d, config)
	transformed["config_values"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValues(original["configValues"], d, config)
	transformed["public_key"] =
		flattenPrivatecaCertificateCertificateDescriptionPublicKey(original["publicKey"], d, config)
	transformed["subject_key_id"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectKeyId(original["subjectKeyId"], d, config)
	transformed["authority_key_id"] =
		flattenPrivatecaCertificateCertificateDescriptionAuthorityKeyId(original["authorityKeyId"], d, config)
	transformed["crl_distribution_points"] =
		flattenPrivatecaCertificateCertificateDescriptionCrlDistributionPoints(original["crlDistributionPoints"], d, config)
	transformed["aia_issuing_certificate_urls"] =
		flattenPrivatecaCertificateCertificateDescriptionAiaIssuingCertificateUrls(original["aiaIssuingCertificateUrls"], d, config)
	transformed["cert_fingerprint"] =
		flattenPrivatecaCertificateCertificateDescriptionCertFingerprint(original["certFingerprint"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionSubjectDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["subject"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubject(original["subject"], d, config)
	transformed["subject_alt_name"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltName(original["subjectAltName"], d, config)
	transformed["hex_serial_number"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionHexSerialNumber(original["hexSerialNumber"], d, config)
	transformed["lifetime"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionLifetime(original["lifetime"], d, config)
	transformed["not_before_time"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionNotBeforeTime(original["notBeforeTime"], d, config)
	transformed["not_after_time"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionNotAfterTime(original["notAfterTime"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["country_code"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectCountryCode(original["countryCode"], d, config)
	transformed["organization"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectOrganization(original["organization"], d, config)
	transformed["organizational_unit"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectOrganizationalUnit(original["organizationalUnit"], d, config)
	transformed["locality"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectLocality(original["locality"], d, config)
	transformed["province"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectProvince(original["province"], d, config)
	transformed["street_address"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectStreetAddress(original["streetAddress"], d, config)
	transformed["postal_code"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectPostalCode(original["postalCode"], d, config)
	transformed["common_name"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectCommonName(original["commonName"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectCountryCode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectOrganization(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectOrganizationalUnit(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectLocality(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectProvince(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectStreetAddress(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectPostalCode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectCommonName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["dns_names"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameDnsNames(original["dnsNames"], d, config)
	transformed["uris"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameUris(original["uris"], d, config)
	transformed["email_addresses"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameEmailAddresses(original["emailAddresses"], d, config)
	transformed["ip_addresses"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameIpAddresses(original["ipAddresses"], d, config)
	transformed["custom_sans"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSans(original["customSans"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameDnsNames(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameUris(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameEmailAddresses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameIpAddresses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSans(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"obect_id": flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectId(original["obectId"], d, config),
			"critical": flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansCritical(original["critical"], d, config),
			"value":    flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansValue(original["value"], d, config),
		})
	}
	return transformed
}
func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["object_id_path"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectIdObjectIdPath(original["objectIdPath"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansObectIdObjectIdPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansCritical(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionSubjectAltNameCustomSansValue(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionHexSerialNumber(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionLifetime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionNotBeforeTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectDescriptionNotAfterTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509Description(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["additional_extensions"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensions(original["additionalExtensions"], d, config)
	transformed["policy_ids"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIds(original["policyIds"], d, config)
	transformed["aia_ocsp_servers"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAiaOcspServers(original["aiaOcspServers"], d, config)
	transformed["ca_options"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionCaOptions(original["caOptions"], d, config)
	transformed["key_usage"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsage(original["keyUsage"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"critical":  flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsCritical(original["critical"], d, config),
			"value":     flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsValue(original["value"], d, config),
			"object_id": flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectId(original["objectId"], d, config),
		})
	}
	return transformed
}
func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsCritical(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsValue(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["object_id_path"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectIdObjectIdPath(original["objectIdPath"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAdditionalExtensionsObjectIdObjectIdPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIds(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"object_id_path": flattenPrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIdsObjectIdPath(original["objectIdPath"], d, config),
		})
	}
	return transformed
}
func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionPolicyIdsObjectIdPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionAiaOcspServers(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionCaOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["is_ca"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsIsCa(original["isCa"], d, config)
	transformed["max_issuer_path_length"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsMaxIssuerPathLength(original["maxIssuerPathLength"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsIsCa(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionCaOptionsMaxIssuerPathLength(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["base_key_usage"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage(original["baseKeyUsage"], d, config)
	transformed["extended_key_usage"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage(original["extendedKeyUsage"], d, config)
	transformed["unknown_extended_key_usages"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsages(original["unknownExtendedKeyUsages"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["digital_signature"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageDigitalSignature(original["digitalSignature"], d, config)
	transformed["content_commitment"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageContentCommitment(original["contentCommitment"], d, config)
	transformed["key_encipherment"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageKeyEncipherment(original["keyEncipherment"], d, config)
	transformed["data_encipherment"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageDataEncipherment(original["dataEncipherment"], d, config)
	transformed["key_agreement"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageKeyAgreement(original["keyAgreement"], d, config)
	transformed["cert_sign"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageCertSign(original["certSign"], d, config)
	transformed["crl_sign"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageCrlSign(original["crlSign"], d, config)
	transformed["encipher_only"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageEncipherOnly(original["encipherOnly"], d, config)
	transformed["decipher_only"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageDecipherOnly(original["decipherOnly"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageDigitalSignature(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageContentCommitment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageKeyEncipherment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageDataEncipherment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageKeyAgreement(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageCertSign(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageCrlSign(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageEncipherOnly(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageBaseKeyUsageDecipherOnly(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["server_auth"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageServerAuth(original["serverAuth"], d, config)
	transformed["client_auth"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageClientAuth(original["clientAuth"], d, config)
	transformed["code_signing"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageCodeSigning(original["codeSigning"], d, config)
	transformed["email_protection"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageEmailProtection(original["emailProtection"], d, config)
	transformed["time_stamping"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageTimeStamping(original["timeStamping"], d, config)
	transformed["ocsp_signing"] =
		flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageOcspSigning(original["ocspSigning"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageServerAuth(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageClientAuth(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageCodeSigning(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageEmailProtection(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageTimeStamping(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageExtendedKeyUsageOcspSigning(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"object_id_path": flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsagesObjectIdPath(original["objectIdPath"], d, config),
		})
	}
	return transformed
}
func flattenPrivatecaCertificateCertificateDescriptionX509DescriptionKeyUsageUnknownExtendedKeyUsagesObjectIdPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValues(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["key_usage"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsage(original["keyUsage"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["base_key_usage"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage(original["baseKeyUsage"], d, config)
	transformed["extended_key_usage"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage(original["extendedKeyUsage"], d, config)
	transformed["unknown_extended_key_usages"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsages(original["unknownExtendedKeyUsages"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["key_usage_options"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions(original["keyUsageOptions"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptions(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["digital_signature"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsDigitalSignature(original["digitalSignature"], d, config)
	transformed["content_commitment"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsContentCommitment(original["contentCommitment"], d, config)
	transformed["key_encipherment"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsKeyEncipherment(original["keyEncipherment"], d, config)
	transformed["data_encipherment"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsDataEncipherment(original["dataEncipherment"], d, config)
	transformed["key_agreement"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsKeyAgreement(original["keyAgreement"], d, config)
	transformed["cert_sign"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsCertSign(original["certSign"], d, config)
	transformed["crl_sign"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsCrlSign(original["crlSign"], d, config)
	transformed["encipher_only"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsEncipherOnly(original["encipherOnly"], d, config)
	transformed["decipher_only"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsDecipherOnly(original["decipherOnly"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsDigitalSignature(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsContentCommitment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsKeyEncipherment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsDataEncipherment(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsKeyAgreement(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsCertSign(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsCrlSign(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsEncipherOnly(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageBaseKeyUsageKeyUsageOptionsDecipherOnly(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsage(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["server_auth"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageServerAuth(original["serverAuth"], d, config)
	transformed["client_auth"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageClientAuth(original["clientAuth"], d, config)
	transformed["code_signing"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageCodeSigning(original["codeSigning"], d, config)
	transformed["email_protection"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageEmailProtection(original["emailProtection"], d, config)
	transformed["time_stamping"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageTimeStamping(original["timeStamping"], d, config)
	transformed["ocsp_signing"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageOcspSigning(original["ocspSigning"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageServerAuth(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageClientAuth(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageCodeSigning(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageEmailProtection(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageTimeStamping(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageExtendedKeyUsageOcspSigning(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsages(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.([]interface{})
	transformed := make([]interface{}, 0, len(l))
	for _, raw := range l {
		original := raw.(map[string]interface{})
		if len(original) < 1 {
			// Do not include empty json objects coming back from the api
			continue
		}
		transformed = append(transformed, map[string]interface{}{
			"obect_id": flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsagesObectId(original["obectId"], d, config),
		})
	}
	return transformed
}
func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsagesObectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["object_id_path"] =
		flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsagesObectIdObjectIdPath(original["objectIdPath"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionConfigValuesKeyUsageUnknownExtendedKeyUsagesObectIdObjectIdPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionPublicKey(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["key"] =
		flattenPrivatecaCertificateCertificateDescriptionPublicKeyKey(original["key"], d, config)
	transformed["format"] =
		flattenPrivatecaCertificateCertificateDescriptionPublicKeyFormat(original["format"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionPublicKeyKey(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionPublicKeyFormat(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionSubjectKeyId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["key_id"] =
		flattenPrivatecaCertificateCertificateDescriptionSubjectKeyIdKeyId(original["keyId"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionSubjectKeyIdKeyId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionAuthorityKeyId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["key_id"] =
		flattenPrivatecaCertificateCertificateDescriptionAuthorityKeyIdKeyId(original["keyId"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionAuthorityKeyIdKeyId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionCrlDistributionPoints(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionAiaIssuingCertificateUrls(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateDescriptionCertFingerprint(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["sha256_hash"] =
		flattenPrivatecaCertificateCertificateDescriptionCertFingerprintSha256Hash(original["sha256Hash"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateCertificateDescriptionCertFingerprintSha256Hash(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificatePemCertificateChain(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificatePemCertificates(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCreateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateUpdateTime(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateCertificateTemplate(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificatePemCsr(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["x509_config"] =
		flattenPrivatecaCertificateConfigX509Config(original["x509Config"], d, config)
	transformed["subject_config"] =
		flattenPrivatecaCertificateConfigSubjectConfig(original["subjectConfig"], d, config)
	transformed["public_key"] =
		flattenPrivatecaCertificateConfigPublicKey(original["publicKey"], d, config)
	return []interface{}{transformed}
}

func flattenPrivatecaCertificateConfigX509Config(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		v = make(map[string]interface{})
	}
	original := v.(map[string]interface{})
	transformed := make(map[string]interface{})
	transformed["additional_extensions"] =
		flattenPrivatecaCertificateConfigX509ConfigAdditionalExtensions(original["additionalExtensions"], d, config)
	transformed["policy_ids"] =
		flattenPrivatecaCertificateConfigX509ConfigPolicyIds(original["policyIds"], d, config)
	transformed["aia_ocsp_servers"] = flattenPrivatecaCertificateConfigX509ConfigAiaOcspServers(original["aiaOcspServers"], d, config)
	transformed["ca_options"] =
		flattenPrivatecaCertificateConfigX509ConfigCaOptions(original["caOptions"], d, config)
	transformed["key_usage"] =
		flattenPrivatecaCertificateConfigX509ConfigKeyUsage(original["keyUsage"], d, config)
	return []interface{}{transformed}
}

func flattenPrivatecaCertificateConfigSubjectConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["subject"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubject(original["subject"], d, config)
	transformed["subject_alt_name"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectAltName(original["subjectAltName"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateConfigSubjectConfigSubject(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["country_code"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectCountryCode(original["countryCode"], d, config)
	transformed["organization"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectOrganization(original["organization"], d, config)
	transformed["organizational_unit"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectOrganizationalUnit(original["organizationalUnit"], d, config)
	transformed["locality"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectLocality(original["locality"], d, config)
	transformed["province"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectProvince(original["province"], d, config)
	transformed["street_address"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectStreetAddress(original["streetAddress"], d, config)
	transformed["postal_code"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectPostalCode(original["postalCode"], d, config)
	transformed["common_name"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectCommonName(original["commonName"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateConfigSubjectConfigSubjectCountryCode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectOrganization(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectOrganizationalUnit(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectLocality(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectProvince(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectStreetAddress(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectPostalCode(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectCommonName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectAltName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["dns_names"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectAltNameDnsNames(original["dnsNames"], d, config)
	transformed["uris"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectAltNameUris(original["uris"], d, config)
	transformed["email_addresses"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectAltNameEmailAddresses(original["emailAddresses"], d, config)
	transformed["ip_addresses"] =
		flattenPrivatecaCertificateConfigSubjectConfigSubjectAltNameIpAddresses(original["ipAddresses"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateConfigSubjectConfigSubjectAltNameDnsNames(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectAltNameUris(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectAltNameEmailAddresses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigSubjectConfigSubjectAltNameIpAddresses(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigPublicKey(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["key"] =
		flattenPrivatecaCertificateConfigPublicKeyKey(original["key"], d, config)
	transformed["format"] =
		flattenPrivatecaCertificateConfigPublicKeyFormat(original["format"], d, config)
	return []interface{}{transformed}
}
func flattenPrivatecaCertificateConfigPublicKeyKey(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenPrivatecaCertificateConfigPublicKeyFormat(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandPrivatecaCertificateLifetime(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateCertificateTemplate(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandPrivatecaCertificatePemCsr(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedX509Config, err := expandPrivatecaCertificateConfigX509Config(original["x509_config"], d, config)
	if err != nil {
		return nil, err
	} else {
		transformed["x509Config"] = transformedX509Config
	}

	transformedSubjectConfig, err := expandPrivatecaCertificateConfigSubjectConfig(original["subject_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubjectConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["subjectConfig"] = transformedSubjectConfig
	}

	transformedPublicKey, err := expandPrivatecaCertificateConfigPublicKey(original["public_key"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPublicKey); val.IsValid() && !isEmptyValue(val) {
		transformed["publicKey"] = transformedPublicKey
	}

	return transformed, nil
}

func expandPrivatecaCertificateConfigX509Config(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	if v == nil {
		return v, nil
	}
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	if len(original) == 0 {
		return nil, nil
	}
	transformed := make(map[string]interface{})

	caOptions, err := expandPrivatecaCertificateConfigX509ConfigCaOptions(original["ca_options"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["caOptions"] = caOptions

	keyUsage, err := expandPrivatecaCertificateConfigX509ConfigKeyUsage(original["key_usage"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["keyUsage"] = keyUsage

	policyIds, err := expandPrivatecaCertificateConfigX509ConfigPolicyIds(original["policy_ids"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["policyIds"] = policyIds

	aiaOcspServers, err := expandPrivatecaCertificateConfigX509ConfigAiaOcspServers(original["aia_ocsp_servers"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["aiaOcspServers"] = aiaOcspServers

	addExts, err := expandPrivatecaCertificateConfigX509ConfigAdditionalExtensions(original["additional_extensions"], d, config)
	if err != nil {
		return nil, err
	}
	transformed["additionalExtensions"] = addExts

	return transformed, nil
}

func expandPrivatecaCertificateConfigSubjectConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedSubject, err := expandPrivatecaCertificateConfigSubjectConfigSubject(original["subject"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubject); val.IsValid() && !isEmptyValue(val) {
		transformed["subject"] = transformedSubject
	}

	transformedSubjectAltName, err := expandPrivatecaCertificateConfigSubjectConfigSubjectAltName(original["subject_alt_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSubjectAltName); val.IsValid() && !isEmptyValue(val) {
		transformed["subjectAltName"] = transformedSubjectAltName
	}

	return transformed, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubject(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedCountryCode, err := expandPrivatecaCertificateConfigSubjectConfigSubjectCountryCode(original["country_code"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCountryCode); val.IsValid() && !isEmptyValue(val) {
		transformed["countryCode"] = transformedCountryCode
	}

	transformedOrganization, err := expandPrivatecaCertificateConfigSubjectConfigSubjectOrganization(original["organization"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOrganization); val.IsValid() && !isEmptyValue(val) {
		transformed["organization"] = transformedOrganization
	}

	transformedOrganizationalUnit, err := expandPrivatecaCertificateConfigSubjectConfigSubjectOrganizationalUnit(original["organizational_unit"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedOrganizationalUnit); val.IsValid() && !isEmptyValue(val) {
		transformed["organizationalUnit"] = transformedOrganizationalUnit
	}

	transformedLocality, err := expandPrivatecaCertificateConfigSubjectConfigSubjectLocality(original["locality"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedLocality); val.IsValid() && !isEmptyValue(val) {
		transformed["locality"] = transformedLocality
	}

	transformedProvince, err := expandPrivatecaCertificateConfigSubjectConfigSubjectProvince(original["province"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedProvince); val.IsValid() && !isEmptyValue(val) {
		transformed["province"] = transformedProvince
	}

	transformedStreetAddress, err := expandPrivatecaCertificateConfigSubjectConfigSubjectStreetAddress(original["street_address"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedStreetAddress); val.IsValid() && !isEmptyValue(val) {
		transformed["streetAddress"] = transformedStreetAddress
	}

	transformedPostalCode, err := expandPrivatecaCertificateConfigSubjectConfigSubjectPostalCode(original["postal_code"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPostalCode); val.IsValid() && !isEmptyValue(val) {
		transformed["postalCode"] = transformedPostalCode
	}

	transformedCommonName, err := expandPrivatecaCertificateConfigSubjectConfigSubjectCommonName(original["common_name"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCommonName); val.IsValid() && !isEmptyValue(val) {
		transformed["commonName"] = transformedCommonName
	}

	return transformed, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectCountryCode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectOrganization(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectOrganizationalUnit(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectLocality(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectProvince(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectStreetAddress(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectPostalCode(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectCommonName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectAltName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedDnsNames, err := expandPrivatecaCertificateConfigSubjectConfigSubjectAltNameDnsNames(original["dns_names"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDnsNames); val.IsValid() && !isEmptyValue(val) {
		transformed["dnsNames"] = transformedDnsNames
	}

	transformedUris, err := expandPrivatecaCertificateConfigSubjectConfigSubjectAltNameUris(original["uris"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUris); val.IsValid() && !isEmptyValue(val) {
		transformed["uris"] = transformedUris
	}

	transformedEmailAddresses, err := expandPrivatecaCertificateConfigSubjectConfigSubjectAltNameEmailAddresses(original["email_addresses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedEmailAddresses); val.IsValid() && !isEmptyValue(val) {
		transformed["emailAddresses"] = transformedEmailAddresses
	}

	transformedIpAddresses, err := expandPrivatecaCertificateConfigSubjectConfigSubjectAltNameIpAddresses(original["ip_addresses"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIpAddresses); val.IsValid() && !isEmptyValue(val) {
		transformed["ipAddresses"] = transformedIpAddresses
	}

	return transformed, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectAltNameDnsNames(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectAltNameUris(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectAltNameEmailAddresses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigSubjectConfigSubjectAltNameIpAddresses(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigPublicKey(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedKey, err := expandPrivatecaCertificateConfigPublicKeyKey(original["key"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedKey); val.IsValid() && !isEmptyValue(val) {
		transformed["key"] = transformedKey
	}

	transformedFormat, err := expandPrivatecaCertificateConfigPublicKeyFormat(original["format"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedFormat); val.IsValid() && !isEmptyValue(val) {
		transformed["format"] = transformedFormat
	}

	return transformed, nil
}

func expandPrivatecaCertificateConfigPublicKeyKey(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandPrivatecaCertificateConfigPublicKeyFormat(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}
