/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.shutdown;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ShutdownHooks {
    private static final Map<Runnable, Thread> HOOKS = new ConcurrentHashMap<Runnable, Thread>();

    public static void addShutdownHook(Runnable shutdownHook) {
        Thread thread = new Thread(shutdownHook, "gradle-shutdown-hook");
        HOOKS.put(shutdownHook, thread);
        Runtime.getRuntime().addShutdownHook(thread);
    }

    public static void removeShutdownHook(Runnable shutdownHook) {
        Thread thread = HOOKS.remove(shutdownHook);
        if (thread != null) {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
    }
}

