/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.JavaVersion;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;

public class JavaPlatformResolver
implements PlatformResolver<JavaPlatform> {
    private final List<JavaPlatform> platforms = Lists.newArrayList();

    public JavaPlatformResolver() {
        for (JavaVersion javaVersion : JavaVersion.values()) {
            DefaultJavaPlatform javaPlatform = new DefaultJavaPlatform(javaVersion);
            this.platforms.add(javaPlatform);
        }
    }

    public Class<JavaPlatform> getType() {
        return JavaPlatform.class;
    }

    public JavaPlatform resolve(PlatformRequirement platformRequirement) {
        for (JavaPlatform platform : this.platforms) {
            if (!platform.getName().equals(platformRequirement.getPlatformName())) continue;
            return platform;
        }
        return null;
    }
}

