/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.TypeHelper;

public class NewArrayCheckAdapter
extends RuleCheckAdapter {
    private String typeName;
    private int count;
    private int dims;
    private boolean whenComplete;

    public NewArrayCheckAdapter(ClassVisitor cv, TransformContext transformContext, String typeName, int count, int dims, boolean whenComplete) {
        super(cv, transformContext);
        this.typeName = typeName;
        this.count = count;
        this.dims = dims;
        this.whenComplete = whenComplete;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(access, name, desc)) {
            this.setVisited();
            return new NewArrayCheckMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class NewArrayCheckMethodAdapter
    extends RuleCheckMethodAdapter {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;
        private boolean visited;
        private int visitedCount;
        String matchedBaseName;

        NewArrayCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            this.visitedCount = 0;
            this.matchedBaseName = null;
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            boolean triggerReady = false;
            int elementDims = TypeHelper.dimCount(type);
            if (opcode == 189 && (NewArrayCheckAdapter.this.count == 0 || this.visitedCount < NewArrayCheckAdapter.this.count) && NewArrayCheckAdapter.this.dims == elementDims + 1 && this.matchType(type)) {
                ++this.visitedCount;
                if (NewArrayCheckAdapter.this.count == 0 || this.visitedCount == NewArrayCheckAdapter.this.count) {
                    if (NewArrayCheckAdapter.this.whenComplete) {
                        triggerReady = true;
                    } else {
                        this.setTriggerPoint();
                    }
                }
            }
            super.visitTypeInsn(opcode, type);
            if (triggerReady) {
                this.setTriggerPoint();
            }
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            boolean triggerReady = false;
            if (opcode == 188 && NewArrayCheckAdapter.this.dims == 1 && (NewArrayCheckAdapter.this.count == 0 || this.visitedCount < NewArrayCheckAdapter.this.count) && this.matchType(operand)) {
                ++this.visitedCount;
                if (NewArrayCheckAdapter.this.count == 0 || this.visitedCount == NewArrayCheckAdapter.this.count) {
                    if (NewArrayCheckAdapter.this.whenComplete) {
                        triggerReady = true;
                    } else {
                        this.setTriggerPoint();
                    }
                }
            }
            super.visitIntInsn(opcode, operand);
            if (triggerReady) {
                this.setTriggerPoint();
            }
        }

        @Override
        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            boolean triggerReady = false;
            int totalDims = TypeHelper.dimCount(descriptor);
            if (NewArrayCheckAdapter.this.dims == totalDims && (NewArrayCheckAdapter.this.count == 0 || this.visitedCount < NewArrayCheckAdapter.this.count) && this.matchType(descriptor)) {
                ++this.visitedCount;
                if (NewArrayCheckAdapter.this.count == 0 || this.visitedCount == NewArrayCheckAdapter.this.count) {
                    if (NewArrayCheckAdapter.this.whenComplete) {
                        triggerReady = true;
                    } else {
                        this.setTriggerPoint();
                    }
                }
            }
            super.visitMultiANewArrayInsn(descriptor, numDimensions);
            if (triggerReady) {
                this.setTriggerPoint();
            }
        }

        private boolean matchType(int operand) {
            String baseName = null;
            switch (operand) {
                case 4: {
                    baseName = "boolean";
                    break;
                }
                case 8: {
                    baseName = "byte";
                    break;
                }
                case 5: {
                    baseName = "char";
                    break;
                }
                case 9: {
                    baseName = "short";
                    break;
                }
                case 10: {
                    baseName = "int";
                    break;
                }
                case 11: {
                    baseName = "long";
                    break;
                }
                case 6: {
                    baseName = "float";
                    break;
                }
                case 7: {
                    baseName = "double";
                    break;
                }
            }
            if (NewArrayCheckAdapter.this.typeName.length() == 0 || NewArrayCheckAdapter.this.typeName.equals(baseName)) {
                this.matchedBaseName = baseName;
                return true;
            }
            return false;
        }

        private boolean matchType(String type) {
            String baseName = TypeHelper.internalizeClass(type, true);
            boolean matched = false;
            if (NewArrayCheckAdapter.this.typeName.length() == 0) {
                matched = true;
            } else if (NewArrayCheckAdapter.this.typeName.equals(baseName)) {
                matched = true;
            } else if (!NewArrayCheckAdapter.this.typeName.contains(".") && baseName.contains(".")) {
                int tailIdx = baseName.lastIndexOf(".");
                matched = NewArrayCheckAdapter.this.typeName.equals(baseName.substring(tailIdx + 1));
            }
            if (matched) {
                this.matchedBaseName = baseName;
            }
            return matched;
        }

        @Override
        public String getNewTypeParamDescriptor() {
            StringBuilder builder = new StringBuilder(this.matchedBaseName);
            for (int i = 0; i < NewArrayCheckAdapter.this.dims; ++i) {
                builder.append("[]");
            }
            return TypeHelper.externalizeType(builder.toString());
        }
    }
}

