/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.ModelException;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;

public class LDAPTransaction
extends AbstractKeycloakTransaction {
    public static final Logger logger = Logger.getLogger(LDAPTransaction.class);
    private final LDAPStorageProvider ldapProvider;
    private final LDAPObject ldapUser;
    private final Set<String> updatedAttributes = new HashSet<String>();

    public LDAPTransaction(LDAPStorageProvider ldapProvider, LDAPObject ldapUser) {
        this.ldapProvider = ldapProvider;
        this.ldapUser = ldapUser;
    }

    protected void commitImpl() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Transaction commit! Updating LDAP attributes for object " + this.ldapUser.getDn() + ", attributes: " + this.ldapUser.getAttributes()));
        }
        if (this.ldapUser.isWaitingForExecutionOnMandatoryAttributesComplete()) {
            throw new ModelException("LDAPObject cannot be commited because some mandatory attributes are not set: " + this.ldapUser.getMandatoryAttributeNamesRemaining());
        }
        if (!this.updatedAttributes.isEmpty()) {
            this.ldapProvider.getLdapIdentityStore().update(this.ldapUser);
        }
    }

    protected void rollbackImpl() {
        logger.warn((Object)("Transaction rollback! Ignoring LDAP updates for object " + this.ldapUser.getDn()));
    }

    public void addUpdatedAttribute(String attributeName) {
        if (this.ldapUser.getDn() != null) {
            this.updatedAttributes.add(attributeName);
        }
    }

    public boolean isAttributeUpdated(String attributeName) {
        return this.updatedAttributes.contains(attributeName);
    }

    public void addUpdatedRequiredAction(String requiredActionName) {
        this.updatedAttributes.add("requiredAction(" + requiredActionName + ")");
    }

    public boolean isRequiredActionUpdated(String requiredActionName) {
        return this.updatedAttributes.contains("requiredAction(" + requiredActionName + ")");
    }
}

