/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder.mpmetrics;

import io.quarkus.arc.processor.BuiltinScope;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class MetricDotNames {
    static final String MICROMETER_EXTENSION_PKG = "io.quarkus.micrometer.runtime.binder.mpmetrics";
    static final DotName MP_METRICS_BINDER = DotName.createSimple((String)"io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetricsBinder");
    static final DotName CONCURRENT_GAUGE_ANNOTATION = DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.ConcurrentGauge");
    static final DotName COUNTED_ANNOTATION = DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.Counted");
    static final DotName GAUGE_ANNOTATION = DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.Gauge");
    static final DotName METERED_ANNOTATION = DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.Metered");
    static final DotName SIMPLY_TIMED_ANNOTATION = DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.SimplyTimed");
    static final DotName TIMED_ANNOTATION = DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.Timed");
    static final Set<DotName> individualMetrics = new HashSet<DotName>(Arrays.asList(CONCURRENT_GAUGE_ANNOTATION, COUNTED_ANNOTATION, GAUGE_ANNOTATION, METERED_ANNOTATION, SIMPLY_TIMED_ANNOTATION, TIMED_ANNOTATION));
    static final DotName METRIC_REGISTRY = DotName.createSimple((String)"org.eclipse.microprofile.metrics.MetricRegistry");
    static final DotName METRIC_ANNOTATION = DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.Metric");
    static final DotName ANNOTATED_GAUGE_ADAPTER = DotName.createSimple((String)"io.quarkus.micrometer.runtime.binder.mpmetrics.AnnotatedGaugeAdapter");
    static final DotName METRIC = DotName.createSimple((String)"org.eclipse.microprofile.metrics.Metric");
    static final DotName JAXRS_PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    static final DotName REST_CONTROLLER = DotName.createSimple((String)"org.springframework.web.bind.annotation.RestController");
    static final DotName CONCURRENT_GAUGE_INTERCEPTOR = DotName.createSimple((String)"io.quarkus.micrometer.runtime.binder.mpmetrics.ConcurrentGaugeInterceptor");
    static final DotName COUNTED_INTERCEPTOR = DotName.createSimple((String)"io.quarkus.micrometer.runtime.binder.mpmetrics.CountedInterceptor");
    static final DotName INJECTED_METRIC_PRODUCER = DotName.createSimple((String)"io.quarkus.micrometer.runtime.binder.mpmetrics.InjectedMetricProducer");
    static final DotName TIMED_INTERCEPTOR = DotName.createSimple((String)"io.quarkus.micrometer.runtime.binder.mpmetrics.TimedInterceptor");
    static final DotName MP_METRICS_REGISTRY_PRODUCER = DotName.createSimple((String)"io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetricsRegistryProducer");

    static boolean containsMetricAnnotation(Map<DotName, List<AnnotationInstance>> annotations) {
        for (DotName name : individualMetrics) {
            if (!annotations.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    static boolean knownClass(ClassInfo classInfo) {
        return classInfo.name().toString().startsWith(MICROMETER_EXTENSION_PKG);
    }

    static boolean isSingleInstance(ClassInfo classInfo) {
        BuiltinScope beanScope = BuiltinScope.from((ClassInfo)classInfo);
        return classInfo.annotationsMap().containsKey(REST_CONTROLLER) || classInfo.annotationsMap().containsKey(JAXRS_PATH) || BuiltinScope.APPLICATION.equals((Object)beanScope) || BuiltinScope.SINGLETON.equals((Object)beanScope);
    }
}

