/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runner.bootstrap;

import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassNameBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.RuntimeApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.runner.bootstrap.ForkJoinClassLoading;
import io.quarkus.runner.bootstrap.RunningQuarkusApplicationImpl;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class StartupActionImpl
implements StartupAction {
    private static final Logger log = Logger.getLogger(StartupActionImpl.class);
    private final CuratedApplication curatedApplication;
    private final BuildResult buildResult;
    private final QuarkusClassLoader runtimeClassLoader;

    public StartupActionImpl(CuratedApplication curatedApplication, BuildResult buildResult) {
        QuarkusClassLoader runtimeClassLoader;
        this.curatedApplication = curatedApplication;
        this.buildResult = buildResult;
        HashSet<String> eagerClasses = new HashSet<String>();
        Map<String, byte[]> transformedClasses = this.extractTransformers(eagerClasses);
        QuarkusClassLoader baseClassLoader = curatedApplication.getBaseRuntimeClassLoader();
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>(this.extractGeneratedResources(true));
        if (curatedApplication.isFlatClassPath()) {
            resources.putAll(this.extractGeneratedResources(false));
            baseClassLoader.reset(resources, transformedClasses);
            runtimeClassLoader = baseClassLoader;
        } else {
            baseClassLoader.reset(this.extractGeneratedResources(false), transformedClasses);
            runtimeClassLoader = curatedApplication.createRuntimeClassLoader(resources, transformedClasses);
        }
        this.runtimeClassLoader = runtimeClassLoader;
    }

    public RunningQuarkusApplication runMainClass(final String ... args) throws Exception {
        ForkJoinClassLoading.setForkJoinClassLoader((ClassLoader)this.runtimeClassLoader);
        ApplicationStateNotification.reset();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.runtimeClassLoader);
        String className = ((MainClassBuildItem)this.buildResult.consume(MainClassBuildItem.class)).getClassName();
        try {
            Class<?> appClass = Class.forName(className, true, (ClassLoader)this.runtimeClassLoader);
            final Method start = appClass.getMethod("main", String[].class);
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread.currentThread().setContextClassLoader((ClassLoader)StartupActionImpl.this.runtimeClassLoader);
                    try {
                        start.invoke(null, new Object[]{args == null ? new String[]{} : args});
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error running Quarkus", e);
                        if (ApplicationStateNotification.getState() == ApplicationStateNotification.State.INITIAL) {
                            ApplicationStateNotification.notifyStartupFailed((Throwable)e);
                        }
                    }
                    finally {
                        for (RuntimeApplicationShutdownBuildItem i : StartupActionImpl.this.buildResult.consumeMulti(RuntimeApplicationShutdownBuildItem.class)) {
                            try {
                                i.getCloseTask().run();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to run close task", t);
                            }
                        }
                    }
                }
            }, "Quarkus Main Thread");
            t.start();
            ApplicationStateNotification.waitForApplicationStart();
            RunningQuarkusApplicationImpl runningQuarkusApplicationImpl = new RunningQuarkusApplicationImpl(new Closeable(){

                @Override
                public void close() throws IOException {
                    try {
                        StartupActionImpl.this.runtimeClassLoader.loadClass(Quarkus.class.getName()).getMethod("blockingExit", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        log.error((Object)"Failed to stop Quarkus", (Throwable)e);
                    }
                    finally {
                        ForkJoinClassLoading.setForkJoinClassLoader(ClassLoader.getSystemClassLoader());
                        if (StartupActionImpl.this.curatedApplication.getQuarkusBootstrap().getMode() == QuarkusBootstrap.Mode.TEST) {
                            StartupActionImpl.this.curatedApplication.close();
                        }
                    }
                }
            }, this.runtimeClassLoader);
            return runningQuarkusApplicationImpl;
        }
        catch (Throwable t) {
            try {
                Class<?> configClass = Class.forName("io.quarkus.runtime.generated.Config", true, (ClassLoader)this.runtimeClassLoader);
                configClass.getDeclaredMethod(RunTimeConfigurationGenerator.C_CREATE_BOOTSTRAP_CONFIG.getName(), new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runMainClassBlocking(String ... args) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.runtimeClassLoader);
        String className = ((MainClassBuildItem)this.buildResult.consume(MainClassBuildItem.class)).getClassName();
        try {
            final AtomicInteger result = new AtomicInteger();
            Class<?> lifecycleManager = Class.forName(ApplicationLifecycleManager.class.getName(), true, (ClassLoader)this.runtimeClassLoader);
            Method getCurrentApplication = lifecycleManager.getDeclaredMethod("getCurrentApplication", new Class[0]);
            Object oldApplication = getCurrentApplication.invoke(null, new Object[0]);
            lifecycleManager.getDeclaredMethod("setDefaultExitCodeHandler", Consumer.class).invoke(null, new Consumer<Integer>(){

                @Override
                public void accept(Integer integer) {
                    result.set(integer);
                }
            });
            Class<?> appClass = Class.forName(className, true, (ClassLoader)this.runtimeClassLoader);
            Method start = appClass.getMethod("main", String[].class);
            start.invoke(null, new Object[]{args == null ? new String[]{} : args});
            final CountDownLatch latch = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Class<?> q = Class.forName(Quarkus.class.getName(), true, (ClassLoader)StartupActionImpl.this.runtimeClassLoader);
                        q.getMethod("blockingExit", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }).start();
            latch.await();
            Object newApplication = getCurrentApplication.invoke(null, new Object[0]);
            if (oldApplication == newApplication) {
                int n = 0;
                return n;
            }
            int n = result.get();
            return n;
        }
        finally {
            this.runtimeClassLoader.close();
            Thread.currentThread().setContextClassLoader(old);
            for (RuntimeApplicationShutdownBuildItem i : this.buildResult.consumeMulti(RuntimeApplicationShutdownBuildItem.class)) {
                try {
                    i.getCloseTask().run();
                }
                catch (Throwable t) {
                    log.error((Object)"Failed to run close task", t);
                }
            }
        }
    }

    public void overrideConfig(Map<String, String> config) {
        RuntimeOverrideConfigSource.setConfig((ClassLoader)this.runtimeClassLoader, config);
    }

    public RunningQuarkusApplication run(String ... args) throws Exception {
        ForkJoinClassLoading.setForkJoinClassLoader((ClassLoader)this.runtimeClassLoader);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> appClass;
            Thread.currentThread().setContextClassLoader((ClassLoader)this.runtimeClassLoader);
            String className = ((ApplicationClassNameBuildItem)this.buildResult.consume(ApplicationClassNameBuildItem.class)).getClassName();
            try {
                appClass = Class.forName(className, true, (ClassLoader)this.runtimeClassLoader);
            }
            catch (Throwable t) {
                try {
                    Class<?> configClass = Class.forName("io.quarkus.runtime.generated.Config", true, (ClassLoader)this.runtimeClassLoader);
                    configClass.getDeclaredMethod(RunTimeConfigurationGenerator.C_CREATE_BOOTSTRAP_CONFIG.getName(), new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
            Method start = appClass.getMethod("start", String[].class);
            Object application = appClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            start.invoke(application, new Object[]{args});
            final Closeable closeTask = (Closeable)application;
            RunningQuarkusApplicationImpl runningQuarkusApplicationImpl = new RunningQuarkusApplicationImpl(new Closeable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        ClassLoader original = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader((ClassLoader)StartupActionImpl.this.runtimeClassLoader);
                            closeTask.close();
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(original);
                            StartupActionImpl.this.runtimeClassLoader.close();
                        }
                    }
                    finally {
                        ForkJoinClassLoading.setForkJoinClassLoader(ClassLoader.getSystemClassLoader());
                        for (RuntimeApplicationShutdownBuildItem i : StartupActionImpl.this.buildResult.consumeMulti(RuntimeApplicationShutdownBuildItem.class)) {
                            try {
                                i.getCloseTask().run();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to run close task", t);
                            }
                        }
                        if (StartupActionImpl.this.curatedApplication.getQuarkusBootstrap().getMode() == QuarkusBootstrap.Mode.TEST && !StartupActionImpl.this.curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication()) {
                            StartupActionImpl.this.curatedApplication.close();
                        }
                    }
                }
            }, this.runtimeClassLoader);
            return runningQuarkusApplicationImpl;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new RuntimeException("Failed to start Quarkus", e.getCause());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public ClassLoader getClassLoader() {
        return this.runtimeClassLoader;
    }

    public Map<String, String> getDevServicesProperties() {
        DevServicesLauncherConfigResultBuildItem result = (DevServicesLauncherConfigResultBuildItem)this.buildResult.consumeOptional(DevServicesLauncherConfigResultBuildItem.class);
        if (result == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(result.getConfig());
    }

    private Map<String, byte[]> extractTransformers(Set<String> eagerClasses) {
        HashMap<String, byte[]> ret = new HashMap<String, byte[]>();
        TransformedClassesBuildItem transformers = (TransformedClassesBuildItem)this.buildResult.consume(TransformedClassesBuildItem.class);
        for (Set<TransformedClassesBuildItem.TransformedClass> i : transformers.getTransformedClassesByJar().values()) {
            for (TransformedClassesBuildItem.TransformedClass clazz : i) {
                if (clazz.getData() == null) continue;
                ret.put(clazz.getFileName(), clazz.getData());
                if (!clazz.isEager()) continue;
                eagerClasses.add(clazz.getClassName());
            }
        }
        return ret;
    }

    private Map<String, byte[]> extractGeneratedResources(boolean applicationClasses) {
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        for (MultiBuildItem i : this.buildResult.consumeMulti(GeneratedClassBuildItem.class)) {
            String debugSourcesDir;
            if (i.isApplicationClass() != applicationClasses) continue;
            data.put(i.getName().replace('.', '/') + ".class", i.getClassData());
            if (BootstrapDebug.DEBUG_CLASSES_DIR != null) {
                try {
                    File debugPath = new File(BootstrapDebug.DEBUG_CLASSES_DIR);
                    if (!debugPath.exists()) {
                        debugPath.mkdir();
                    }
                    File classFile = new File(debugPath, i.getName() + ".class");
                    classFile.getParentFile().mkdirs();
                    try (FileOutputStream classWriter = new FileOutputStream(classFile);){
                        classWriter.write(i.getClassData());
                    }
                    log.infof("Wrote %s", (Object)classFile.getAbsolutePath());
                }
                catch (Exception t) {
                    log.errorf((Throwable)t, "Failed to write debug class files %s", (Object)i.getName());
                }
            }
            if ((debugSourcesDir = BootstrapDebug.DEBUG_SOURCES_DIR) == null) continue;
            try {
                if (i.getSource() != null) {
                    File debugPath = new File(debugSourcesDir);
                    if (!debugPath.exists()) {
                        debugPath.mkdir();
                    }
                    File sourceFile = new File(debugPath, i.getName() + ".zig");
                    sourceFile.getParentFile().mkdirs();
                    Files.write(sourceFile.toPath(), i.getSource().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                    log.infof("Wrote source %s", (Object)sourceFile.getAbsolutePath());
                    continue;
                }
                log.infof("Source not available: %s", (Object)i.getName());
            }
            catch (Exception t) {
                log.errorf((Throwable)t, "Failed to write debug source file %s", (Object)i.getName());
            }
        }
        if (applicationClasses) {
            for (MultiBuildItem i : this.buildResult.consumeMulti(GeneratedResourceBuildItem.class)) {
                if (i.isExcludeFromDevCL()) continue;
                data.put(i.getName(), i.getClassData());
            }
        }
        return data;
    }
}

