/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.userprofile.ValidationException;

public class Validation {
    public static final String FIELD_PASSWORD_CONFIRM = "password-confirm";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_PASSWORD = "password";
    public static final String FIELD_USERNAME = "username";
    public static final String FIELD_OTP_CODE = "totp";
    public static final String FIELD_OTP_LABEL = "userLabel";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*");
    private static final Pattern USERNAME_PATTERN = Pattern.compile("^[\\p{IsLatin}|\\p{IsCommon}]+$");

    private static void addError(List<FormMessage> errors, String field, String message, Object ... parameters) {
        errors.add(new FormMessage(field, message, parameters));
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmailValid(String email) {
        return EMAIL_PATTERN.matcher(email).matches();
    }

    public static boolean isUsernameValid(String username) {
        return USERNAME_PATTERN.matcher(username).matches();
    }

    public static List<FormMessage> getFormErrorsFromValidation(List<ValidationException.Error> errors) {
        ArrayList<FormMessage> messages = new ArrayList<FormMessage>();
        for (ValidationException.Error error : errors) {
            Validation.addError(messages, error.getAttribute(), error.getMessage(), error.getMessageParameters());
        }
        return messages;
    }
}

