/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkClearDepthStencilValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEPTH;
    public static final int STENCIL;

    public VkClearDepthStencilValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkClearDepthStencilValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float depth() {
        return VkClearDepthStencilValue.ndepth(this.address());
    }

    @NativeType(value="uint32_t")
    public int stencil() {
        return VkClearDepthStencilValue.nstencil(this.address());
    }

    public VkClearDepthStencilValue depth(float value) {
        VkClearDepthStencilValue.ndepth(this.address(), value);
        return this;
    }

    public VkClearDepthStencilValue stencil(@NativeType(value="uint32_t") int value) {
        VkClearDepthStencilValue.nstencil(this.address(), value);
        return this;
    }

    public VkClearDepthStencilValue set(float depth, int stencil) {
        this.depth(depth);
        this.stencil(stencil);
        return this;
    }

    public VkClearDepthStencilValue set(VkClearDepthStencilValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkClearDepthStencilValue malloc() {
        return (VkClearDepthStencilValue)VkClearDepthStencilValue.wrap(VkClearDepthStencilValue.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkClearDepthStencilValue calloc() {
        return (VkClearDepthStencilValue)VkClearDepthStencilValue.wrap(VkClearDepthStencilValue.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkClearDepthStencilValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkClearDepthStencilValue)VkClearDepthStencilValue.wrap(VkClearDepthStencilValue.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkClearDepthStencilValue create(long address) {
        return (VkClearDepthStencilValue)VkClearDepthStencilValue.wrap(VkClearDepthStencilValue.class, (long)address);
    }

    @Nullable
    public static VkClearDepthStencilValue createSafe(long address) {
        return address == 0L ? null : (VkClearDepthStencilValue)VkClearDepthStencilValue.wrap(VkClearDepthStencilValue.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkClearDepthStencilValue.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkClearDepthStencilValue.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkClearDepthStencilValue.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearDepthStencilValue.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkClearDepthStencilValue.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkClearDepthStencilValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkClearDepthStencilValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkClearDepthStencilValue mallocStack() {
        return VkClearDepthStencilValue.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearDepthStencilValue callocStack() {
        return VkClearDepthStencilValue.callocStack(MemoryStack.stackGet());
    }

    public static VkClearDepthStencilValue mallocStack(MemoryStack stack) {
        return (VkClearDepthStencilValue)VkClearDepthStencilValue.wrap(VkClearDepthStencilValue.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearDepthStencilValue callocStack(MemoryStack stack) {
        return (VkClearDepthStencilValue)VkClearDepthStencilValue.wrap(VkClearDepthStencilValue.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearDepthStencilValue.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearDepthStencilValue.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearDepthStencilValue.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearDepthStencilValue.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float ndepth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DEPTH);
    }

    public static int nstencil(long struct) {
        return UNSAFE.getInt(null, struct + (long)STENCIL);
    }

    public static void ndepth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)DEPTH, value);
    }

    public static void nstencil(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STENCIL, value);
    }

    static {
        Struct.Layout layout = VkClearDepthStencilValue.__struct((Struct.Member[])new Struct.Member[]{VkClearDepthStencilValue.__member((int)4), VkClearDepthStencilValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEPTH = layout.offsetof(0);
        STENCIL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkClearDepthStencilValue, Buffer>
    implements NativeResource {
        private static final VkClearDepthStencilValue ELEMENT_FACTORY = VkClearDepthStencilValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkClearDepthStencilValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float depth() {
            return VkClearDepthStencilValue.ndepth(this.address());
        }

        @NativeType(value="uint32_t")
        public int stencil() {
            return VkClearDepthStencilValue.nstencil(this.address());
        }

        public Buffer depth(float value) {
            VkClearDepthStencilValue.ndepth(this.address(), value);
            return this;
        }

        public Buffer stencil(@NativeType(value="uint32_t") int value) {
            VkClearDepthStencilValue.nstencil(this.address(), value);
            return this;
        }
    }
}

