/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSpecializationInfo;

public class VkPipelineShaderStageCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGE;
    public static final int MODULE;
    public static final int PNAME;
    public static final int PSPECIALIZATIONINFO;

    public VkPipelineShaderStageCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineShaderStageCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineShaderStageCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineShaderStageCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineShaderStageCreateFlags")
    public int flags() {
        return VkPipelineShaderStageCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkShaderStageFlagBits")
    public int stage() {
        return VkPipelineShaderStageCreateInfo.nstage(this.address());
    }

    @NativeType(value="VkShaderModule")
    public long module() {
        return VkPipelineShaderStageCreateInfo.nmodule(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pName() {
        return VkPipelineShaderStageCreateInfo.npName(this.address());
    }

    @NativeType(value="char const *")
    public String pNameString() {
        return VkPipelineShaderStageCreateInfo.npNameString(this.address());
    }

    @Nullable
    @NativeType(value="VkSpecializationInfo const *")
    public VkSpecializationInfo pSpecializationInfo() {
        return VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address());
    }

    public VkPipelineShaderStageCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineShaderStageCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineShaderStageCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo flags(@NativeType(value="VkPipelineShaderStageCreateFlags") int value) {
        VkPipelineShaderStageCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo stage(@NativeType(value="VkShaderStageFlagBits") int value) {
        VkPipelineShaderStageCreateInfo.nstage(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo module(@NativeType(value="VkShaderModule") long value) {
        VkPipelineShaderStageCreateInfo.nmodule(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo pName(@NativeType(value="char const *") ByteBuffer value) {
        VkPipelineShaderStageCreateInfo.npName(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo pSpecializationInfo(@Nullable @NativeType(value="VkSpecializationInfo const *") VkSpecializationInfo value) {
        VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address(), value);
        return this;
    }

    public VkPipelineShaderStageCreateInfo set(int sType, long pNext, int flags, int stage, long module, ByteBuffer pName, @Nullable VkSpecializationInfo pSpecializationInfo) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.stage(stage);
        this.module(module);
        this.pName(pName);
        this.pSpecializationInfo(pSpecializationInfo);
        return this;
    }

    public VkPipelineShaderStageCreateInfo set(VkPipelineShaderStageCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineShaderStageCreateInfo malloc() {
        return (VkPipelineShaderStageCreateInfo)VkPipelineShaderStageCreateInfo.wrap(VkPipelineShaderStageCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPipelineShaderStageCreateInfo calloc() {
        return (VkPipelineShaderStageCreateInfo)VkPipelineShaderStageCreateInfo.wrap(VkPipelineShaderStageCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPipelineShaderStageCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPipelineShaderStageCreateInfo)VkPipelineShaderStageCreateInfo.wrap(VkPipelineShaderStageCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPipelineShaderStageCreateInfo create(long address) {
        return (VkPipelineShaderStageCreateInfo)VkPipelineShaderStageCreateInfo.wrap(VkPipelineShaderStageCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkPipelineShaderStageCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkPipelineShaderStageCreateInfo)VkPipelineShaderStageCreateInfo.wrap(VkPipelineShaderStageCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPipelineShaderStageCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPipelineShaderStageCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPipelineShaderStageCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineShaderStageCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPipelineShaderStageCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPipelineShaderStageCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPipelineShaderStageCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPipelineShaderStageCreateInfo mallocStack() {
        return VkPipelineShaderStageCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineShaderStageCreateInfo callocStack() {
        return VkPipelineShaderStageCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineShaderStageCreateInfo mallocStack(MemoryStack stack) {
        return (VkPipelineShaderStageCreateInfo)VkPipelineShaderStageCreateInfo.wrap(VkPipelineShaderStageCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineShaderStageCreateInfo callocStack(MemoryStack stack) {
        return (VkPipelineShaderStageCreateInfo)VkPipelineShaderStageCreateInfo.wrap(VkPipelineShaderStageCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineShaderStageCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineShaderStageCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPipelineShaderStageCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPipelineShaderStageCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nstage(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGE);
    }

    public static long nmodule(long struct) {
        return UNSAFE.getLong(null, struct + (long)MODULE);
    }

    public static ByteBuffer npName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    public static String npNameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    @Nullable
    public static VkSpecializationInfo npSpecializationInfo(long struct) {
        return VkSpecializationInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSPECIALIZATIONINFO)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nstage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGE, value);
    }

    public static void nmodule(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MODULE, value);
    }

    public static void npName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void npSpecializationInfo(long struct, @Nullable VkSpecializationInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSPECIALIZATIONINFO), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
        long pSpecializationInfo = MemoryUtil.memGetAddress((long)(struct + (long)PSPECIALIZATIONINFO));
        if (pSpecializationInfo != 0L) {
            VkSpecializationInfo.validate(pSpecializationInfo);
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkPipelineShaderStageCreateInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkPipelineShaderStageCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkPipelineShaderStageCreateInfo.__member((int)4), VkPipelineShaderStageCreateInfo.__member((int)POINTER_SIZE), VkPipelineShaderStageCreateInfo.__member((int)4), VkPipelineShaderStageCreateInfo.__member((int)4), VkPipelineShaderStageCreateInfo.__member((int)8), VkPipelineShaderStageCreateInfo.__member((int)POINTER_SIZE), VkPipelineShaderStageCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGE = layout.offsetof(3);
        MODULE = layout.offsetof(4);
        PNAME = layout.offsetof(5);
        PSPECIALIZATIONINFO = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineShaderStageCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineShaderStageCreateInfo ELEMENT_FACTORY = VkPipelineShaderStageCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPipelineShaderStageCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineShaderStageCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineShaderStageCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineShaderStageCreateFlags")
        public int flags() {
            return VkPipelineShaderStageCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkShaderStageFlagBits")
        public int stage() {
            return VkPipelineShaderStageCreateInfo.nstage(this.address());
        }

        @NativeType(value="VkShaderModule")
        public long module() {
            return VkPipelineShaderStageCreateInfo.nmodule(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pName() {
            return VkPipelineShaderStageCreateInfo.npName(this.address());
        }

        @NativeType(value="char const *")
        public String pNameString() {
            return VkPipelineShaderStageCreateInfo.npNameString(this.address());
        }

        @Nullable
        @NativeType(value="VkSpecializationInfo const *")
        public VkSpecializationInfo pSpecializationInfo() {
            return VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineShaderStageCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineShaderStageCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineShaderStageCreateFlags") int value) {
            VkPipelineShaderStageCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer stage(@NativeType(value="VkShaderStageFlagBits") int value) {
            VkPipelineShaderStageCreateInfo.nstage(this.address(), value);
            return this;
        }

        public Buffer module(@NativeType(value="VkShaderModule") long value) {
            VkPipelineShaderStageCreateInfo.nmodule(this.address(), value);
            return this;
        }

        public Buffer pName(@NativeType(value="char const *") ByteBuffer value) {
            VkPipelineShaderStageCreateInfo.npName(this.address(), value);
            return this;
        }

        public Buffer pSpecializationInfo(@Nullable @NativeType(value="VkSpecializationInfo const *") VkSpecializationInfo value) {
            VkPipelineShaderStageCreateInfo.npSpecializationInfo(this.address(), value);
            return this;
        }
    }
}

