"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDslRoute = registerDslRoute;

var _configSchema = require("@osd/config-schema");

var _common = require("../../common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerDslRoute({
  router
}) {
  router.post({
    path: _common.ServiceEndpoints.GetSearchResults,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index,
      size,
      body: rest
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      var _error$body, _error$body$error, _error$body2, _error$body2$error;

      if (error.statusCode !== 404) console.error(error); // Template: Error: {{Error.type}} – {{Error.reason}}

      const errorMessage = `Error: ${(_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$error = _error$body.error) === null || _error$body$error === void 0 ? void 0 : _error$body$error.type} - ${(_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : (_error$body2$error = _error$body2.error) === null || _error$body2$error === void 0 ? void 0 : _error$body2$error.reason}`;
      return response.custom({
        statusCode: error.statusCode || 500,
        body: errorMessage
      });
    }
  });
  router.get({
    path: _common.ServiceEndpoints.GetIndexes,
    validate: {}
  }, async (context, request, response) => {
    const params = {
      format: 'json'
    };

    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('cat.indices', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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