/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.base.MoreObjects;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.RoutedAliasTypes;
import org.apache.solr.cloud.api.collections.RoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.TimeZoneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRoutedAlias
extends RoutedAlias {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final RoutedAliasTypes TYPE = RoutedAliasTypes.TIME;
    private List<Map.Entry<Instant, String>> parsedCollectionsDesc;
    private Aliases parsedCollectionsAliases;
    public static final String ROUTER_START = "router.start";
    public static final String ROUTER_INTERVAL = "router.interval";
    public static final String ROUTER_MAX_FUTURE = "router.maxFutureMs";
    public static final String ROUTER_AUTO_DELETE_AGE = "router.autoDeleteAge";
    public static final String ROUTER_PREEMPTIVE_CREATE_MATH = "router.preemptiveCreateMath";
    public static final Set<String> REQUIRED_ROUTER_PARAMS = Set.of("name", "router.name", "router.field", "router.start", "router.interval");
    public static final Set<String> OPTIONAL_ROUTER_PARAMS = Set.of("router.maxFutureMs", "router.autoDeleteAge", "router.preemptiveCreateMath", "TZ");
    static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendPattern("[_HH[_mm[_ss]]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.ROOT).withZone(ZoneOffset.UTC);
    private final String aliasName;
    private final Map<String, String> aliasMetadata;
    private final String routeField;
    private final String intervalMath;
    private final long maxFutureMs;
    private final String preemptiveCreateMath;
    private final String autoDeleteAgeMath;
    private final TimeZone timeZone;
    private String start;

    TimeRoutedAlias(String aliasName, Map<String, String> aliasMetadata) throws SolrException {
        if (!aliasMetadata.keySet().containsAll(REQUIRED_ROUTER_PARAMS)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A time routed alias requires these params: " + REQUIRED_ROUTER_PARAMS + " plus some create-collection prefixed ones.");
        }
        this.aliasMetadata = aliasMetadata;
        this.start = this.aliasMetadata.get(ROUTER_START);
        this.aliasName = aliasName;
        MapSolrParams params = new MapSolrParams(this.aliasMetadata);
        RequiredSolrParams required = params.required();
        String type = required.get("router.name").toLowerCase(Locale.ROOT);
        if (!"time".equals(type)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only 'time' routed aliases is supported by TimeRoutedAlias, found:" + type);
        }
        this.routeField = required.get("router.field");
        this.intervalMath = required.get(ROUTER_INTERVAL);
        this.maxFutureMs = params.getLong(ROUTER_MAX_FUTURE, TimeUnit.MINUTES.toMillis(10L));
        String pcmTmp = params.get(ROUTER_PREEMPTIVE_CREATE_MATH);
        this.preemptiveCreateMath = pcmTmp != null ? (pcmTmp.startsWith("-") ? pcmTmp : "-" + pcmTmp) : null;
        this.autoDeleteAgeMath = params.get(ROUTER_AUTO_DELETE_AGE);
        this.timeZone = TimeZoneUtils.parseTimezone(this.aliasMetadata.get("TZ"));
        Date now = new Date();
        try {
            Date after = new DateMathParser(now, this.timeZone).parseMath(this.getIntervalMath());
            if (!after.after(now)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "duration must add to produce a time in the future");
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "bad router.interval, " + e, (Throwable)e);
        }
        if (this.autoDeleteAgeMath != null) {
            try {
                Date before = new DateMathParser(now, this.timeZone).parseMath(this.autoDeleteAgeMath);
                if (now.before(before)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "duration must round or subtract to produce a time in the past");
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "bad router.autoDeleteAge, " + e, (Throwable)e);
            }
        }
        if (this.preemptiveCreateMath != null) {
            try {
                new DateMathParser().parseMath(this.preemptiveCreateMath);
            }
            catch (ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid date math for preemptiveCreateMath:" + this.preemptiveCreateMath);
            }
        }
        if (this.maxFutureMs < 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "router.maxFutureMs must be >= 0");
        }
    }

    @Override
    public String computeInitialCollectionName() {
        return TimeRoutedAlias.formatCollectionNameFromInstant(this.aliasName, this.parseStringAsInstant(this.start, this.timeZone));
    }

    @Override
    String[] formattedRouteValues(SolrInputDocument doc) {
        String routeField = this.getRouteField();
        Date fieldValue = (Date)doc.getFieldValue(routeField);
        String dest = this.calcCandidateCollection(fieldValue.toInstant()).getDestinationCollection();
        int nonValuePrefix = this.getAliasName().length() + this.getRoutedAliasType().getSeparatorPrefix().length();
        return new String[]{dest.substring(nonValuePrefix)};
    }

    public static Instant parseInstantFromCollectionName(String aliasName, String collection) {
        String separatorPrefix = TYPE.getSeparatorPrefix();
        String dateTimePart = collection.contains(separatorPrefix) ? collection.substring(collection.lastIndexOf(separatorPrefix) + separatorPrefix.length()) : collection.substring(aliasName.length() + 1);
        return DATE_TIME_FORMATTER.parse((CharSequence)dateTimePart, Instant::from);
    }

    public static String formatCollectionNameFromInstant(String aliasName, Instant timestamp) {
        String nextCollName = DATE_TIME_FORMATTER.format(timestamp);
        for (int i = 0; i < 3; ++i) {
            if (!nextCollName.endsWith("_00")) continue;
            nextCollName = nextCollName.substring(0, nextCollName.length() - 3);
        }
        assert (DATE_TIME_FORMATTER.parse((CharSequence)nextCollName, Instant::from).equals(timestamp));
        return aliasName + TYPE.getSeparatorPrefix() + nextCollName;
    }

    private Instant parseStringAsInstant(String str, TimeZone zone) {
        Instant start = DateMathParser.parseMath(new Date(), str, zone).toInstant();
        this.checkMillis(start);
        return start;
    }

    private void checkMillis(Instant date) {
        if (!date.truncatedTo(ChronoUnit.SECONDS).equals(date)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Date or date math for start time includes milliseconds, which is not supported. (Hint: 'NOW' used without rounding always has this problem)");
        }
    }

    @Override
    public boolean updateParsedCollectionAliases(ZkStateReader zkStateReader, boolean contextualize) {
        Aliases aliases = zkStateReader.getAliases();
        if (this.parsedCollectionsAliases != aliases) {
            if (this.parsedCollectionsAliases != null && log.isDebugEnabled()) {
                log.debug("Observing possibly updated alias: {}", (Object)this.getAliasName());
            }
            this.parsedCollectionsDesc = this.parseCollections(aliases);
            this.parsedCollectionsAliases = aliases;
            return true;
        }
        if (contextualize) {
            this.parsedCollectionsDesc = this.parseCollections(aliases);
        }
        return false;
    }

    @Override
    public String getAliasName() {
        return this.aliasName;
    }

    @Override
    public String getRouteField() {
        return this.routeField;
    }

    @Override
    public RoutedAliasTypes getRoutedAliasType() {
        return RoutedAliasTypes.TIME;
    }

    public String getIntervalMath() {
        return this.intervalMath;
    }

    public long getMaxFutureMs() {
        return this.maxFutureMs;
    }

    public String getPreemptiveCreateWindow() {
        return this.preemptiveCreateMath;
    }

    public String getAutoDeleteAgeMath() {
        return this.autoDeleteAgeMath;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("aliasName", (Object)this.aliasName).add("routeField", (Object)this.routeField).add("intervalMath", (Object)this.intervalMath).add("maxFutureMs", this.maxFutureMs).add("preemptiveCreateMath", (Object)this.preemptiveCreateMath).add("autoDeleteAgeMath", (Object)this.autoDeleteAgeMath).add("timeZone", (Object)this.timeZone).toString();
    }

    private List<Map.Entry<Instant, String>> parseCollections(Aliases aliases) {
        List<String> collections = this.getCollectionList(aliases);
        if (collections == null) {
            throw RoutedAlias.newAliasMustExistException(this.getAliasName());
        }
        ArrayList<Map.Entry<Instant, String>> result = new ArrayList<Map.Entry<Instant, String>>(collections.size());
        for (String collection : collections) {
            Instant colStartTime = TimeRoutedAlias.parseInstantFromCollectionName(this.aliasName, collection);
            result.add(new AbstractMap.SimpleImmutableEntry<Instant, String>(colStartTime, collection));
        }
        result.sort((e1, e2) -> ((Instant)e2.getKey()).compareTo((Instant)e1.getKey()));
        return result;
    }

    private Instant computeNextCollTimestamp(Instant fromTimestamp) {
        Instant nextCollTimestamp = DateMathParser.parseMath(Date.from(fromTimestamp), "NOW" + this.intervalMath, this.timeZone).toInstant();
        assert (nextCollTimestamp.isAfter(fromTimestamp));
        return nextCollTimestamp;
    }

    @Override
    public void validateRouteValue(AddUpdateCommand cmd) throws SolrException {
        Instant startTime;
        Instant docTimestamp = this.parseRouteKey(cmd.getSolrInputDocument().getFieldValue(this.getRouteField()));
        if (docTimestamp.isAfter(Instant.now().plusMillis(this.getMaxFutureMs()))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The document's time routed key of " + docTimestamp + " is too far in the future given router.maxFutureMs=" + this.getMaxFutureMs());
        }
        try {
            startTime = Instant.parse(this.start);
        }
        catch (DateTimeParseException e) {
            startTime = DateMathParser.parseMath(new Date(), this.start).toInstant();
            SolrCore core = cmd.getReq().getCore();
            ZkStateReader zkStateReader = core.getCoreContainer().getZkController().zkStateReader;
            Aliases aliases = zkStateReader.getAliases();
            HashMap<String, String> props = new HashMap<String, String>(aliases.getCollectionAliasProperties(this.aliasName));
            this.start = DateTimeFormatter.ISO_INSTANT.format(startTime);
            props.put(ROUTER_START, this.start);
            core.runAsync(() -> zkStateReader.aliasesManager.applyModificationAndExportToZk(a -> aliases.cloneWithCollectionAliasProperties(this.aliasName, props)));
        }
        if (docTimestamp.isBefore(startTime)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The document couldn't be routed because " + docTimestamp + " is before the start time for this alias " + this.start + ")");
        }
    }

    @Override
    public Map<String, String> getAliasMetadata() {
        return this.aliasMetadata;
    }

    @Override
    public Set<String> getRequiredParams() {
        return REQUIRED_ROUTER_PARAMS;
    }

    @Override
    public Set<String> getOptionalParams() {
        return OPTIONAL_ROUTER_PARAMS;
    }

    @Override
    protected String getHeadCollectionIfOrdered(AddUpdateCommand cmd) {
        return this.parsedCollectionsDesc.get(0).getValue();
    }

    private Instant calcPreemptNextColCreateTime(String preemptiveCreateMath, Instant nextCollTimestamp) {
        DateMathParser dateMathParser = new DateMathParser();
        dateMathParser.setNow(Date.from(nextCollTimestamp));
        try {
            return dateMathParser.parseMath(preemptiveCreateMath).toInstant();
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Preemptive Create Window Math:'" + preemptiveCreateMath + "'", (Throwable)e);
        }
    }

    private Instant parseRouteKey(Object routeKey) {
        Instant docTimestamp;
        if (routeKey instanceof Instant) {
            docTimestamp = (Instant)routeKey;
        } else if (routeKey instanceof Date) {
            docTimestamp = ((Date)routeKey).toInstant();
        } else if (routeKey instanceof CharSequence) {
            docTimestamp = Instant.parse((CharSequence)routeKey);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected type of routeKey: " + routeKey);
        }
        return docTimestamp;
    }

    @Override
    public RoutedAlias.CandidateCollection findCandidateGivenValue(AddUpdateCommand cmd) {
        Object value = cmd.getSolrInputDocument().getFieldValue(this.getRouteField());
        ZkStateReader zkStateReader = cmd.getReq().getCoreContainer().getZkController().zkStateReader;
        String printableId = cmd.getPrintableId();
        this.updateParsedCollectionAliases(zkStateReader, true);
        Instant docTimestamp = this.parseRouteKey(value);
        this.parsedCollectionsDesc = this.parseCollections(zkStateReader.getAliases());
        RoutedAlias.CandidateCollection next1 = this.calcCandidateCollection(docTimestamp);
        if (next1 != null) {
            return next1;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Doc " + printableId + " couldn't be routed with " + this.getRouteField() + "=" + docTimestamp);
    }

    private RoutedAlias.CandidateCollection calcCandidateCollection(Instant docTimestamp) {
        Instant next = null;
        if (this.parsedCollectionsDesc.isEmpty()) {
            String firstCol = this.computeInitialCollectionName();
            return new RoutedAlias.CandidateCollection(RoutedAlias.CreationType.SYNCHRONOUS, firstCol);
        }
        Instant mostRecentCol = this.parsedCollectionsDesc.get(0).getKey();
        for (int i = 0; i < this.parsedCollectionsDesc.size(); ++i) {
            Instant time2Create;
            RoutedAlias.CandidateCollection candidate;
            Map.Entry<Instant, String> entry = this.parsedCollectionsDesc.get(i);
            Instant colStartTime = entry.getKey();
            if (i == 0) {
                next = this.computeNextCollTimestamp(colStartTime);
            }
            if (docTimestamp.isBefore(colStartTime)) continue;
            if (i == 0) {
                if (docTimestamp.isBefore(next)) {
                    candidate = new RoutedAlias.CandidateCollection(RoutedAlias.CreationType.NONE, entry.getValue());
                } else {
                    Instant colDestTime;
                    String creationCol = this.calcNextCollection(colStartTime);
                    Instant possibleDestTime = colDestTime = colStartTime;
                    while (!docTimestamp.isBefore(possibleDestTime) || docTimestamp.equals(possibleDestTime)) {
                        colDestTime = possibleDestTime;
                        possibleDestTime = this.computeNextCollTimestamp(colDestTime);
                    }
                    String destCol = TimeRoutedAlias.formatCollectionNameFromInstant(this.getAliasName(), colDestTime);
                    candidate = new RoutedAlias.CandidateCollection(RoutedAlias.CreationType.SYNCHRONOUS, destCol, creationCol);
                }
            } else {
                candidate = new RoutedAlias.CandidateCollection(RoutedAlias.CreationType.NONE, entry.getValue());
            }
            if (candidate.getCreationType() == RoutedAlias.CreationType.NONE && StringUtils.isNotBlank((CharSequence)this.getPreemptiveCreateWindow()) && !this.preemptiveCreateOnceAlready && !docTimestamp.isBefore(time2Create = this.calcPreemptNextColCreateTime(this.getPreemptiveCreateWindow(), this.computeNextCollTimestamp(mostRecentCol)))) {
                String destinationCollection = candidate.getDestinationCollection();
                String creationCollection = this.calcNextCollection(mostRecentCol);
                return new RoutedAlias.CandidateCollection(RoutedAlias.CreationType.ASYNC_PREEMPTIVE, destinationCollection, creationCollection);
            }
            return candidate;
        }
        return null;
    }

    private List<RoutedAlias.Action> calcDeletes(List<RoutedAlias.Action> actions) {
        Instant delBefore;
        String autoDeleteAgeMathStr = this.getAutoDeleteAgeMath();
        if (autoDeleteAgeMathStr == null || actions.size() == 0) {
            return Collections.emptyList();
        }
        if (actions.size() > 1) {
            throw new IllegalStateException("We are not supposed to be creating more than one collection at a time");
        }
        String deletionReferenceCollection = actions.get((int)0).targetCollection;
        Instant deletionReferenceInstant = TimeRoutedAlias.parseInstantFromCollectionName(this.getAliasName(), deletionReferenceCollection);
        try {
            delBefore = new DateMathParser(Date.from(this.computeNextCollTimestamp(deletionReferenceInstant)), this.getTimeZone()).parseMath(autoDeleteAgeMathStr).toInstant();
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        ArrayList<RoutedAlias.Action> collectionsToDelete = new ArrayList<RoutedAlias.Action>();
        int numToKeep = 0;
        DateTimeFormatter dtf = null;
        if (log.isDebugEnabled()) {
            dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.n", Locale.ROOT);
            dtf = dtf.withZone(ZoneId.of("UTC"));
        }
        for (Map.Entry<Instant, String> parsedCollection : this.parsedCollectionsDesc) {
            ++numToKeep;
            Instant colInstant = parsedCollection.getKey();
            if (colInstant.isBefore(delBefore) || colInstant.equals(delBefore)) {
                if (!log.isDebugEnabled()) break;
                assert (dtf != null);
                if (!log.isDebugEnabled()) break;
                log.debug("{} is equal to or before {} deletions may be required", (Object)dtf.format(colInstant), (Object)dtf.format(delBefore));
                break;
            }
            if (!log.isDebugEnabled()) continue;
            assert (dtf != null);
            if (!log.isDebugEnabled()) continue;
            log.debug("{} is not before {} and will be retained", (Object)dtf.format(colInstant), (Object)dtf.format(delBefore));
        }
        log.debug("Collections will be deleted... parsed collections={}", this.parsedCollectionsDesc);
        List targetList = this.parsedCollectionsDesc.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        log.debug("Iterating backwards on collection list to find deletions: {}", targetList);
        for (int i = this.parsedCollectionsDesc.size() - 1; i >= numToKeep; --i) {
            String toDelete = (String)targetList.get(i);
            log.debug("Adding to TRA delete list:{}", (Object)toDelete);
            collectionsToDelete.add(new RoutedAlias.Action(this, RoutedAlias.ActionType.ENSURE_REMOVED, toDelete));
        }
        return collectionsToDelete;
    }

    private List<RoutedAlias.Action> calcAdd(String targetCol) {
        List<String> collectionList = this.getCollectionList(this.parsedCollectionsAliases);
        if (!collectionList.contains(targetCol) && !collectionList.isEmpty()) {
            String pfx;
            String mostRecentCol = collectionList.get(0);
            int sepLen = mostRecentCol.contains(pfx = this.getRoutedAliasType().getSeparatorPrefix()) ? pfx.length() : 1;
            String mostRecentTime = mostRecentCol.substring(this.getAliasName().length() + sepLen);
            Instant parsed = DATE_TIME_FORMATTER.parse((CharSequence)mostRecentTime, Instant::from);
            String nextCol = this.calcNextCollection(parsed);
            return Collections.singletonList(new RoutedAlias.Action(this, RoutedAlias.ActionType.ENSURE_EXISTS, nextCol));
        }
        return Collections.emptyList();
    }

    private String calcNextCollection(Instant mostRecentCollTimestamp) {
        Instant nextCollTimestamp = this.computeNextCollTimestamp(mostRecentCollTimestamp);
        return TimeRoutedAlias.formatCollectionNameFromInstant(this.aliasName, nextCollTimestamp);
    }

    @Override
    protected List<RoutedAlias.Action> calculateActions(String targetCol) {
        ArrayList<RoutedAlias.Action> actions = new ArrayList<RoutedAlias.Action>();
        actions.addAll(this.calcAdd(targetCol));
        actions.addAll(this.calcDeletes(actions));
        return actions;
    }
}

