/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TracerConfigurator
implements NamedListInitializedPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public abstract Tracer getTracer();

    public static Tracer loadTracer(SolrResourceLoader loader, PluginInfo info) {
        if (info != null && info.isEnabled()) {
            GlobalTracer.registerIfAbsent(() -> {
                TracerConfigurator configurator = loader.newInstance(info.className, TracerConfigurator.class);
                configurator.init(info.initArgs);
                return configurator.getTracer();
            });
        }
        if (GlobalTracer.isRegistered()) {
            ExecutorUtil.addThreadLocalProvider((ExecutorUtil.InheritableThreadLocalProvider)new SpanThreadLocalProvider());
        }
        return GlobalTracer.get();
    }

    private static class SpanThreadLocalProvider
    implements ExecutorUtil.InheritableThreadLocalProvider {
        private final Tracer tracer = GlobalTracer.get();

        private SpanThreadLocalProvider() {
        }

        public void store(AtomicReference<Object> ctx) {
            assert (this.tracer == GlobalTracer.get()) : "Tracer changed; not supported!";
            ctx.set(this.tracer.scopeManager().activeSpan());
        }

        public void set(AtomicReference<Object> ctx) {
            Span span = (Span)ctx.get();
            if (span != null) {
                log.trace("Thread received span to do async work: {}", (Object)span);
                Scope scope = this.tracer.scopeManager().activate(span);
                ctx.set(scope);
            }
        }

        public void clean(AtomicReference<Object> ctx) {
            Scope scope = (Scope)ctx.get();
            if (scope != null) {
                scope.close();
            }
        }
    }
}

