/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import com.carrotsearch.hppc.IntObjectHashMap;
import java.io.IOException;
import java.util.Date;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.common.MapWriter;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;

class DateFieldWriter
extends FieldWriter {
    private String field;
    private IntObjectHashMap<NumericDocValues> docValuesCache = new IntObjectHashMap();

    public DateFieldWriter(String field) {
        this.field = field;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean write(SortDoc sortDoc, LeafReaderContext readerContext, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
        Long val;
        SortValue sortValue = sortDoc.getSortValue(this.field);
        if (sortValue != null) {
            if (!sortValue.isPresent()) return false;
            val = (long)((Long)sortValue.getCurrentValue());
        } else {
            NumericDocValues numericDocValues;
            int readerOrd = readerContext.ord;
            NumericDocValues vals = null;
            if (this.docValuesCache.containsKey(readerOrd) && (numericDocValues = (NumericDocValues)this.docValuesCache.get(readerOrd)).docID() < sortDoc.docId) {
                vals = numericDocValues;
            }
            if (vals == null) {
                vals = DocValues.getNumeric((LeafReader)readerContext.reader(), (String)this.field);
                this.docValuesCache.put(readerOrd, (Object)vals);
            }
            if (vals.advance(sortDoc.docId) != sortDoc.docId) return false;
            val = vals.longValue();
        }
        ew.put((CharSequence)this.field, (Object)new Date(val));
        return true;
    }
}

