/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateHttp2SolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.update.ErrorReportingConcurrentUpdateSolrClient;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.UpdateShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSolrClients {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int runnerCount = Integer.getInteger("solr.cloud.replication.runners", 1);
    private final int pollQueueTime = Integer.getInteger("solr.cloud.client.pollQueueTime", 10000);
    private Http2SolrClient httpClient;
    private Map<String, ConcurrentUpdateHttp2SolrClient> solrClients = new HashMap<String, ConcurrentUpdateHttp2SolrClient>();
    private List<SolrCmdDistributor.Error> errors = Collections.synchronizedList(new ArrayList());
    private ExecutorService updateExecutor;

    public StreamingSolrClients(UpdateShardHandler updateShardHandler) {
        this.updateExecutor = updateShardHandler.getUpdateExecutor();
        this.httpClient = updateShardHandler.getUpdateOnlyHttpClient();
    }

    public List<SolrCmdDistributor.Error> getErrors() {
        return this.errors;
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public synchronized SolrClient getSolrClient(SolrCmdDistributor.Req req) {
        String url = this.getFullUrl(req.node.getUrl());
        ConcurrentUpdateHttp2SolrClient client = this.solrClients.get(url);
        if (client == null) {
            client = new ErrorReportingConcurrentUpdateSolrClient.Builder(url, this.httpClient, req, this.errors).withQueueSize(100).withThreadCount(this.runnerCount).withExecutorService(this.updateExecutor).alwaysStreamDeletes().build();
            client.setPollQueueTime(this.pollQueueTime);
            this.solrClients.put(url, client);
        }
        return client;
    }

    public synchronized void blockUntilFinished() throws IOException {
        for (ConcurrentUpdateHttp2SolrClient client : this.solrClients.values()) {
            client.blockUntilFinished();
        }
    }

    public synchronized void shutdown() {
        for (ConcurrentUpdateHttp2SolrClient client : this.solrClients.values()) {
            client.close();
        }
    }

    private String getFullUrl(String url) {
        Object fullUrl = !url.startsWith("http://") && !url.startsWith("https://") ? "http://" + url : url;
        return fullUrl;
    }

    public Http2SolrClient getHttpClient() {
        return this.httpClient;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }
}

