/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.ExpressionParser;
import java.util.Locale;
import org.apache.solr.common.SolrException;

public final class SolrVersion
implements Comparable<SolrVersion> {
    private final Version version;
    private static final String LATEST_STRING = "9.1.1";
    public static final SolrVersion LATEST = SolrVersion.valueOf("9.1.1");

    public static SolrVersion valueOf(String version) {
        return new SolrVersion(Version.valueOf((String)version));
    }

    public static SolrVersion forIntegers(int major, int minor, int patch) {
        return new SolrVersion(Version.forIntegers((int)major, (int)minor, (int)patch));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format(Locale.ROOT, "%d.%d.%d", this.version.getMajorVersion(), this.version.getMinorVersion(), this.version.getPatchVersion()));
        if (!this.version.getPreReleaseVersion().isEmpty()) {
            sb.append("-").append(this.version.getPreReleaseVersion());
        }
        if (!this.version.getBuildMetadata().isEmpty()) {
            sb.append("+").append(this.version.getBuildMetadata());
        }
        return sb.toString();
    }

    public boolean greaterThan(SolrVersion other) {
        return this.version.greaterThan(other.version);
    }

    public boolean greaterThanOrEqualTo(SolrVersion other) {
        return this.version.greaterThanOrEqualTo(other.version);
    }

    public boolean lessThan(SolrVersion other) {
        return this.version.lessThan(other.version);
    }

    public boolean lessThanOrEqualTo(SolrVersion other) {
        return this.version.lessThanOrEqualTo(other.version);
    }

    public boolean satisfies(String semVerExpression) {
        try {
            return ((Expression)ExpressionParser.newInstance().parse(semVerExpression)).interpret(this.version);
        }
        catch (ParseException parseException) {
            throw new InvalidSemVerExpressionException();
        }
    }

    public int getMajorVersion() {
        return this.version.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.version.getMinorVersion();
    }

    public int getPatchVersion() {
        return this.version.getPatchVersion();
    }

    public String getPrereleaseVersion() {
        return this.version.getPreReleaseVersion();
    }

    private SolrVersion(Version version) {
        this.version = version;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    @Override
    public int compareTo(SolrVersion other) {
        return this.version.compareTo(other.version);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SolrVersion)) {
            return false;
        }
        return this.compareTo((SolrVersion)other) == 0;
    }

    public static class InvalidSemVerExpressionException
    extends SolrException {
        public InvalidSemVerExpressionException() {
            super(SolrException.ErrorCode.BAD_REQUEST, "Invalid SemVer expression");
        }
    }
}

