/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.util.Hashtable;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.trans.Messages;
import org.pentaho.di.trans.StepPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobPlugin
extends Plugin<String> {
    private String category;
    private JobEntryType jobType;
    private Map<String, String> localizedCategories;
    private Map<String, String> localizedDescriptions;
    private Map<String, String> localizedTooltips;

    public JobPlugin(int type, String id, JobEntryType jobType, String tooltip, String directory, String[] jarfiles, String icon_filename, String classname, String category) {
        super(type, (Object)id, jobType.getDescription(), tooltip, directory, jarfiles, icon_filename, classname);
        this.jobType = jobType;
        this.category = category;
        this.localizedCategories = new Hashtable<String, String>();
        this.localizedDescriptions = new Hashtable<String, String>();
        this.localizedTooltips = new Hashtable<String, String>();
    }

    public JobPlugin(int type, String id, String description, String tooltip, String directory, String[] jarfiles, String icon_filename, String classname, String category) {
        super(type, (Object)id, description, tooltip, directory, jarfiles, icon_filename, classname);
        this.category = category;
        this.localizedCategories = new Hashtable<String, String>();
        this.localizedDescriptions = new Hashtable<String, String>();
        this.localizedTooltips = new Hashtable<String, String>();
    }

    public JobEntryType getJobType() {
        return this.jobType;
    }

    public int hashCode() {
        return ((String)this.getID()).hashCode();
    }

    public boolean equals(Object obj) {
        return ((String)this.getID()).equals(((JobPlugin)((Object)obj)).getID());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ": " + (String)this.getID() + "(" + (this.getType() == 1 ? "NATIVE" : "PLUGIN") + ")";
    }

    public String getCategory() {
        return this.getCategory(LanguageChoice.getInstance().getDefaultLocale().toString().toLowerCase());
    }

    public String getCategory(String locale) {
        String localizedCategory = this.localizedCategories.get(locale.toLowerCase());
        if (localizedCategory != null) {
            return localizedCategory;
        }
        if (this.category == null) {
            return Messages.getString("StepPlugin.Label");
        }
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDescription() {
        return this.getDescription(LanguageChoice.getInstance().getDefaultLocale().toString().toLowerCase());
    }

    public String getDescription(String locale) {
        String localizedDescription = this.localizedDescriptions.get(locale.toLowerCase());
        if (localizedDescription != null) {
            return localizedDescription;
        }
        return this.description;
    }

    public String getTooltip() {
        return this.getTooltip(LanguageChoice.getInstance().getDefaultLocale().toString().toLowerCase());
    }

    public String getTooltip(String locale) {
        String localizedTooltip = this.localizedTooltips.get(locale.toLowerCase());
        if (localizedTooltip != null) {
            return localizedTooltip;
        }
        return super.getTooltip();
    }

    public void setLocalizedCategories(Map<String, String> localizedCategories) {
        this.localizedCategories = localizedCategories;
    }

    public Map<String, String> getLocalizedCategories() {
        return this.localizedCategories;
    }

    public void setLocalizedDescriptions(Map<String, String> localizedDescriptions) {
        this.localizedDescriptions = localizedDescriptions;
    }

    public Map<String, String> getLocalizedDescriptions() {
        return this.localizedDescriptions;
    }

    public Map<String, String> getLocalizedTooltips() {
        return this.localizedTooltips;
    }

    public void setLocalizedTooltips(Map<String, String> localizedTooltips) {
        this.localizedTooltips = localizedTooltips;
    }

    public String getJarfilesList() {
        String list = "";
        String[] jarfiles = super.getJarfiles();
        if (jarfiles != null) {
            for (int i = 0; i < jarfiles.length; ++i) {
                if (i > 0) {
                    list = list + Const.PATH_SEPARATOR;
                }
                list = list + jarfiles[i];
            }
        }
        return list;
    }

    public static RowMetaInterface getPluginInformationRowMeta() {
        RowMeta row = new RowMeta();
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.Type.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.ID.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.Description.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.ToolTip.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.Directory.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.JarFiles.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.IconFile.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.ClassName.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.Category.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.ErrorHelpFile.Label"), 2));
        row.addValueMeta((ValueMetaInterface)new ValueMeta(Messages.getString("StepPlugin.Information.SeparateClassloader.Label"), 4));
        return row;
    }

    public Object[] getPluginInformation() {
        Object[] row = new Object[JobPlugin.getPluginInformationRowMeta().size()];
        int rowIndex = 0;
        String jobTypeDesc = this.jobType == null || this.jobType.equals((Object)JobEntryType.NONE) ? StepPlugin.typeDesc[2] : StepPlugin.typeDesc[1];
        row[rowIndex++] = jobTypeDesc;
        row[rowIndex++] = this.getID();
        row[rowIndex++] = this.getDescription();
        row[rowIndex++] = this.getTooltip();
        row[rowIndex++] = this.getDirectory();
        row[rowIndex++] = this.getJarfilesList();
        row[rowIndex++] = this.getIconFilename();
        row[rowIndex++] = this.getClassname();
        row[rowIndex++] = this.getCategory();
        row[rowIndex++] = null;
        row[rowIndex++] = false;
        return row;
    }
}

