/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.ArrayEncodedSubValue;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class EncodedArrayItem
extends Item<EncodedArrayItem> {
    private int hashCode = 0;
    private ArrayEncodedSubValue encodedArray;

    protected EncodedArrayItem(DexFile dexFile) {
        super(dexFile);
    }

    private EncodedArrayItem(DexFile dexFile, ArrayEncodedSubValue encodedArray) {
        super(dexFile);
        this.encodedArray = encodedArray;
    }

    public static EncodedArrayItem internEncodedArrayItem(DexFile dexFile, ArrayEncodedSubValue encodedArray) {
        EncodedArrayItem encodedArrayItem = new EncodedArrayItem(dexFile, encodedArray);
        return dexFile.EncodedArraysSection.intern(encodedArrayItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.encodedArray = new ArrayEncodedSubValue(this.dexFile, in);
    }

    @Override
    protected int placeItem(int offset) {
        return this.encodedArray.placeValue(offset);
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        this.encodedArray.writeValue(out);
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ENCODED_ARRAY_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "encoded_array @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(EncodedArrayItem encodedArrayItem) {
        return this.encodedArray.compareTo(encodedArrayItem.encodedArray);
    }

    public ArrayEncodedSubValue getEncodedArray() {
        return this.encodedArray;
    }

    private void calcHashCode() {
        this.hashCode = this.encodedArray.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        EncodedArrayItem other = (EncodedArrayItem)o;
        return this.encodedArray.compareTo(other.encodedArray) == 0;
    }
}

