/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.ApplePartitionMap;
import org.catacombae.hfsexplorer.partitioning.DriverDescriptorRecord;
import org.catacombae.hfsexplorer.partitioning.GPTHeader;
import org.catacombae.hfsexplorer.partitioning.GUIDPartitionTable;
import org.catacombae.hfsexplorer.partitioning.MBRPartitionTable;
import org.catacombae.hfsexplorer.partitioning.PartitionSystem;
import org.catacombae.io.ReadableRandomAccessStream;

public class PartitionSystemRecognizer {
    private ReadableRandomAccessStream bitstream;

    public PartitionSystemRecognizer(ReadableRandomAccessStream bitstream) {
        this.bitstream = bitstream;
    }

    public PartitionSystemType detectPartitionSystem() {
        block17: {
            try {
                byte[] piece1 = null;
                byte[] piece2 = null;
                try {
                    this.bitstream.seek(0L);
                    piece1 = new byte[512];
                    this.bitstream.readFully(piece1);
                }
                catch (Exception e) {
                    piece1 = null;
                }
                try {
                    this.bitstream.seek(512L);
                    piece2 = new byte[512];
                    this.bitstream.readFully(piece2);
                }
                catch (Exception e) {
                    piece2 = null;
                }
                if (piece1 != null) {
                    try {
                        int blockSize;
                        ApplePartitionMap apm;
                        DriverDescriptorRecord ddr = new DriverDescriptorRecord(piece1, 0);
                        if (ddr.isValid() && (apm = new ApplePartitionMap(this.bitstream, (long)((blockSize = Util.unsign((short)ddr.getSbBlkSize())) * 1), blockSize)).getUsedPartitionCount() > 0) {
                            return PartitionSystemType.APPLE_PARTITION_MAP;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (piece2 != null) {
                    try {
                        GPTHeader gh = new GPTHeader(piece2, 0, 512);
                        if (gh.isValid()) {
                            return PartitionSystemType.GUID_PARTITION_TABLE;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (piece1 == null) break block17;
                try {
                    MBRPartitionTable mpt = new MBRPartitionTable(piece1, 0);
                    if (mpt.isValid()) {
                        return PartitionSystemType.MASTER_BOOT_RECORD;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PartitionSystemType.NONE_FOUND;
    }

    public PartitionSystem getPartitionSystem() {
        PartitionSystemType type = this.detectPartitionSystem();
        switch (type) {
            case APPLE_PARTITION_MAP: {
                byte[] ddrData = new byte[512];
                this.bitstream.seek(0L);
                this.bitstream.readFully(ddrData);
                DriverDescriptorRecord ddr = new DriverDescriptorRecord(ddrData, 0);
                int blockSize = Util.unsign((short)ddr.getSbBlkSize());
                return new ApplePartitionMap(this.bitstream, (long)(blockSize * 1), blockSize);
            }
            case GUID_PARTITION_TABLE: {
                return new GUIDPartitionTable(this.bitstream, 0);
            }
            case MASTER_BOOT_RECORD: {
                return new MBRPartitionTable(this.bitstream, 0);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PartitionSystemType {
        APPLE_PARTITION_MAP,
        MASTER_BOOT_RECORD,
        GUID_PARTITION_TABLE,
        NONE_FOUND;

    }
}

