/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.dialogs.InputDialog;
import ghidra.app.cmd.refs.AddExternalNameCmd;
import ghidra.app.plugin.core.references.ExternalReferencesProvider;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class AddExternalReferenceNameAction
extends DockingAction {
    private static ImageIcon ADD_ICON = ResourceManager.loadImage((String)"images/Plus.png");
    private final ExternalReferencesProvider provider;

    public AddExternalReferenceNameAction(ExternalReferencesProvider provider) {
        super("Add External Program Name", provider.getOwner());
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Add External Program"}, (Icon)ADD_ICON, null));
        this.setToolBarData(new ToolBarData((Icon)ADD_ICON, null));
    }

    public void actionPerformed(ActionContext context) {
        InputDialog dialog = new InputDialog("New External Program", "Enter Name");
        dialog.setHelpLocation(new HelpLocation("ReferencesPlugin", "Add_External_Program_Name"));
        this.provider.getTool().showDialog((DialogComponentProvider)dialog, (ComponentProvider)this.provider);
        if (dialog.isCanceled()) {
            return;
        }
        String newExternalName = dialog.getValue().trim();
        if (newExternalName.isEmpty()) {
            Msg.showError((Object)((Object)this), (Component)dialog.getComponent(), (String)"Invalid Input", (Object)"External program name cannot be empty");
            return;
        }
        AddExternalNameCmd cmd = new AddExternalNameCmd(newExternalName, SourceType.USER_DEFINED);
        this.provider.getTool().execute((Command)cmd, (DomainObject)this.provider.getProgram());
    }
}

