/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.util.Conv;
import java.io.IOException;
import java.util.ArrayList;

public class OMFLibrary {
    private String[] libs;

    static OMFLibrary createOMFLibrary(FactoryBundledWithBinaryReader reader, int ptr, int numBytes) throws IOException {
        OMFLibrary omfLibrary = (OMFLibrary)reader.getFactory().create(OMFLibrary.class, new Object[0]);
        omfLibrary.initOMFLibrary(reader, ptr, numBytes);
        return omfLibrary;
    }

    private void initOMFLibrary(FactoryBundledWithBinaryReader reader, int ptr, int numBytes) throws IOException {
        ArrayList<String> libList = new ArrayList<String>();
        while (numBytes > 0) {
            byte len = reader.readByte(ptr);
            --numBytes;
            int length = Conv.byteToInt((byte)len);
            String lib = reader.readAsciiString(++ptr, length);
            ptr += length;
            numBytes -= length;
            libList.add(lib);
        }
        this.libs = new String[libList.size()];
        libList.toArray(this.libs);
    }

    public String[] getLibraries() {
        return this.libs;
    }
}

