/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;

public class MultiAddressRangeIterator {
    AddressRangeIterator[] iters;
    AddressRange[] addrRanges;
    boolean forward;
    Address min = null;
    Address max = null;

    public MultiAddressRangeIterator(AddressRangeIterator[] iters) {
        this.iters = iters;
        this.addrRanges = new AddressRange[iters.length];
        this.forward = true;
    }

    public MultiAddressRangeIterator(AddressRangeIterator[] iters, boolean forward) {
        this.iters = iters;
        this.addrRanges = new AddressRange[iters.length];
        this.forward = forward;
    }

    public boolean hasNext() {
        for (int i = 0; i < this.iters.length; ++i) {
            if (this.addrRanges[i] == null && (this.iters[i] == null || !this.iters[i].hasNext())) continue;
            return true;
        }
        return false;
    }

    public AddressRange next() {
        return this.forward ? this.forwardNext() : this.backwardNext();
    }

    public AddressRange forwardNext() {
        Address checkMinAddr;
        int i;
        for (i = 0; i < this.iters.length; ++i) {
            if (this.addrRanges[i] != null || this.iters[i] == null || !this.iters[i].hasNext()) continue;
            this.addrRanges[i] = (AddressRange)this.iters[i].next();
        }
        if (this.min == null) {
            for (i = 0; i < this.addrRanges.length; ++i) {
                if (this.addrRanges[i] == null) continue;
                checkMinAddr = this.addrRanges[i].getMinAddress();
                if (this.min != null && this.min.compareTo((Object)checkMinAddr) <= 0) continue;
                this.min = checkMinAddr;
            }
        }
        this.max = null;
        for (i = 0; i < this.addrRanges.length; ++i) {
            if (this.addrRanges[i] == null) continue;
            checkMinAddr = this.addrRanges[i].getMinAddress();
            Address checkMaxAddr = this.addrRanges[i].getMaxAddress();
            if (this.addrRanges[i].contains(this.min)) {
                if (this.max != null && this.max.compareTo((Object)checkMaxAddr) <= 0) continue;
                this.max = checkMaxAddr;
                continue;
            }
            if (this.min.compareTo((Object)checkMinAddr) >= 0) continue;
            Address previous = checkMinAddr.previous();
            if (this.max != null && this.max.compareTo((Object)previous) <= 0) continue;
            this.max = previous;
        }
        AddressRangeImpl nextRange = new AddressRangeImpl(this.min, this.max);
        Address nextMin = this.max != null ? this.max.next() : null;
        this.min = null;
        for (int i2 = 0; i2 < this.addrRanges.length; ++i2) {
            if (this.addrRanges[i2] == null) continue;
            Address checkMaxAddr = this.addrRanges[i2].getMaxAddress();
            if (nextMin == null || nextMin.compareTo((Object)checkMaxAddr) > 0) {
                this.addrRanges[i2] = null;
                continue;
            }
            if (!this.addrRanges[i2].contains(nextMin) || this.min != null) continue;
            this.min = nextMin;
        }
        return nextRange;
    }

    public AddressRange backwardNext() {
        int i;
        for (i = 0; i < this.iters.length; ++i) {
            if (this.addrRanges[i] != null || this.iters[i] == null || !this.iters[i].hasNext()) continue;
            this.addrRanges[i] = (AddressRange)this.iters[i].next();
        }
        if (this.max == null) {
            for (i = 0; i < this.addrRanges.length; ++i) {
                if (this.addrRanges[i] == null) continue;
                Address checkMaxAddr = this.addrRanges[i].getMaxAddress();
                if (this.max != null && this.max.compareTo((Object)checkMaxAddr) >= 0) continue;
                this.max = checkMaxAddr;
            }
        }
        this.min = null;
        for (i = 0; i < this.addrRanges.length; ++i) {
            if (this.addrRanges[i] == null) continue;
            Address checkMinAddr = this.addrRanges[i].getMinAddress();
            Address checkMaxAddr = this.addrRanges[i].getMaxAddress();
            if (this.addrRanges[i].contains(this.max)) {
                if (this.min != null && this.min.compareTo((Object)checkMinAddr) >= 0) continue;
                this.min = checkMinAddr;
                continue;
            }
            if (this.max.compareTo((Object)checkMaxAddr) <= 0) continue;
            Address next = checkMaxAddr.next();
            if (this.min != null && this.min.compareTo((Object)next) >= 0) continue;
            this.min = next;
        }
        AddressRangeImpl nextRange = new AddressRangeImpl(this.min, this.max);
        Address nextMax = this.min != null ? this.min.previous() : null;
        this.max = null;
        for (int i2 = 0; i2 < this.addrRanges.length; ++i2) {
            if (this.addrRanges[i2] == null) continue;
            Address checkMinAddr = this.addrRanges[i2].getMinAddress();
            if (nextMax == null || nextMax.compareTo((Object)checkMinAddr) < 0) {
                this.addrRanges[i2] = null;
                continue;
            }
            if (!this.addrRanges[i2].contains(nextMax) || this.max != null) continue;
            this.max = nextMax;
        }
        return nextRange;
    }
}

