/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import db.DBHandle;
import db.Record;
import db.Schema;
import db.Table;
import ghidra.feature.fid.db.FidDBUtils;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.RelationType;
import ghidra.feature.fid.hash.FidHashQuad;
import java.io.IOException;

public class RelationsTable {
    static final String INFERIOR_RELATIONS_TABLE = "Inferior Table";
    static final String SUPERIOR_RELATIONS_TABLE = "Superior Table";
    static final Schema SCHEMA = new Schema(6, "Relation Smash", new Class[0], new String[0]);
    Table inferiorTable;
    Table superiorTable;

    public RelationsTable(DBHandle handle) throws IOException {
        this.inferiorTable = handle.getTable(INFERIOR_RELATIONS_TABLE);
        this.superiorTable = handle.getTable(SUPERIOR_RELATIONS_TABLE);
    }

    public static void createTables(DBHandle handle) throws IOException {
        handle.createTable(INFERIOR_RELATIONS_TABLE, SCHEMA);
        handle.createTable(SUPERIOR_RELATIONS_TABLE, SCHEMA);
    }

    public void createRelation(FunctionRecord superiorFunction, FunctionRecord inferiorFunction, RelationType relationType) throws IOException {
        long superiorKey = FidDBUtils.generateSuperiorFullHashSmash(superiorFunction, inferiorFunction);
        Record superiorRecord = SCHEMA.createRecord(superiorKey);
        this.superiorTable.putRecord(superiorRecord);
        if (relationType != RelationType.INTER_LIBRARY_CALL) {
            long inferiorKey = FidDBUtils.generateInferiorFullHashSmash(superiorFunction, inferiorFunction);
            Record inferiorRecord = SCHEMA.createRecord(inferiorKey);
            this.inferiorTable.putRecord(inferiorRecord);
        }
    }

    public void createInferiorRelation(FunctionRecord superiorFunction, FunctionRecord inferiorFunction) throws IOException {
        long inferiorKey = FidDBUtils.generateInferiorFullHashSmash(superiorFunction, inferiorFunction);
        Record inferiorRecord = SCHEMA.createRecord(inferiorKey);
        this.inferiorTable.putRecord(inferiorRecord);
    }

    public boolean getSuperiorFullRelation(FunctionRecord superiorFunction, FidHashQuad inferiorFunction) throws IOException {
        long superiorKey = FidDBUtils.generateSuperiorFullHashSmash(superiorFunction, inferiorFunction);
        Record record = this.superiorTable.getRecord(superiorKey);
        return record != null;
    }

    public boolean getInferiorFullRelation(FidHashQuad superiorFunction, FunctionRecord inferiorFunction) throws IOException {
        long inferiorKey = FidDBUtils.generateInferiorFullHashSmash(superiorFunction, inferiorFunction);
        Record record = this.inferiorTable.getRecord(inferiorKey);
        return record != null;
    }
}

