/*
 * Decompiled with CFR 0.152.
 */
package help;

import ghidra.util.xml.XmlUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public class TOCConverter {
    private String sourceFilename;
    private String outFilename;
    private static final String TOC_VERSION = "<toc version";
    private static final String TOCITEM = "<tocitem";
    private static final String TEXT = "text";
    private static final String TARGET = " target";
    private Map<String, String> urlMap;
    private List<String> tocList;

    TOCConverter(String sourceTOCfilename, String outFilename) throws IOException, SAXException, ParserConfigurationException {
        this.sourceFilename = sourceTOCfilename;
        this.outFilename = outFilename;
        this.urlMap = new HashMap<String, String>();
        this.tocList = new ArrayList<String>();
        this.readSourceTOC();
        this.writeJavaHelpTOC();
        System.out.println("  TOC conversion is done!");
    }

    void writeTOCMapFile(PrintWriter out) {
        out.println("  <!-- Table of Contents help IDs -->");
        for (int i = 0; i < this.tocList.size(); ++i) {
            String target = this.tocList.get(i);
            String url = this.urlMap.get(target);
            String line = "  <mapID target=\"" + target + "\" url=\"" + url + "\" />";
            out.println(line);
        }
        out.println("  <!-- End of Table of Contents help IDs -->");
    }

    private void readSourceTOC() throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory factory = XmlUtilities.createSecureSAXParserFactory((boolean)false);
        ParserAdapter parser = new ParserAdapter(factory.newSAXParser().getParser());
        File file = this.createTempTOCFile();
        String fileURL = file.toURI().toURL().toString();
        TOCHandler handler = new TOCHandler();
        parser.setContentHandler(handler);
        parser.setErrorHandler(handler);
        parser.setFeature("http://xml.org/sax/features/namespaces", true);
        System.out.println("  Parsing input file " + this.sourceFilename);
        parser.parse(fileURL);
        file.deleteOnExit();
    }

    private void writeJavaHelpTOC() throws IOException {
        System.out.println("  Writing JavaHelp TOC file " + this.outFilename);
        PrintWriter out = new PrintWriter(new FileOutputStream(this.outFilename));
        BufferedReader reader = new BufferedReader(new FileReader(this.sourceFilename));
        Object line = null;
        while ((line = reader.readLine()) != null) {
            if (((String)line).indexOf(TOCITEM) > 0) {
                TOCItem item = this.parseLine((String)line);
                if (item == null) continue;
                String endline = " >";
                if (((String)line).endsWith("/>")) {
                    endline = " />";
                }
                line = this.getPadString((String)line) + "<tocitem text=\"" + item.getText() + "\"";
                if (item.getTarget().length() > 0) {
                    line = (String)line + " target=\"" + item.getTarget() + "\"";
                }
                line = (String)line + endline;
            } else if (((String)line).indexOf(TOC_VERSION) == 0) {
                out.println("<!-- This is the JavaHelp Table of Contents file -->");
                out.println("<!-- Auto generated on " + new Date() + ": Do not edit! -->");
            }
            if (((String)line).startsWith("<!-- Source")) continue;
            out.println((String)line);
        }
        out.close();
        reader.close();
    }

    private String getPadString(String line) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private TOCItem parseLine(String line) {
        int pos = line.indexOf(TOCITEM);
        line = line.substring(pos + TOCITEM.length());
        StringTokenizer st = new StringTokenizer(line, "=\"");
        st.nextToken();
        String text = st.nextToken();
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (!st.hasMoreTokens()) {
            return new TOCItem(text, "");
        }
        String target = st.nextToken();
        return new TOCItem(text, target);
    }

    private File createTempTOCFile() throws IOException {
        File tempFile = File.createTempFile("toc", ".xml");
        PrintWriter out = new PrintWriter(new FileOutputStream(tempFile));
        BufferedReader reader = new BufferedReader(new FileReader(this.sourceFilename));
        boolean endLineFound = true;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("<!DOCTYPE")) {
                if (line.endsWith(">")) continue;
                endLineFound = false;
            }
            if (!endLineFound && line.endsWith(">")) {
                endLineFound = true;
                continue;
            }
            out.println(line);
        }
        out.close();
        reader.close();
        return tempFile;
    }

    public static final void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: TOCConverter [source TOC filename] [out filename]");
            System.exit(0);
        }
        try {
            TOCConverter conv = new TOCConverter(args[0], args[1]);
            File file = new File(args[1]);
            Object name = file.getName();
            name = "map_" + (String)name;
            PrintWriter out = new PrintWriter(new FileOutputStream(new File(file.getParentFile(), (String)name)));
            conv.writeTOCMapFile(out);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class TOCHandler
    extends DefaultHandler {
        private TOCHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (atts != null) {
                String url;
                if (!atts.getQName(0).equals(TOCConverter.TEXT)) {
                    return;
                }
                String target = url = atts.getValue(1);
                if (url != null && url.length() > 0) {
                    target = target.replace('.', '_');
                    target = target.replace('#', '_');
                    target = target.replace('-', '_');
                    TOCConverter.this.urlMap.put(target, url);
                    if (!TOCConverter.this.tocList.contains(target)) {
                        TOCConverter.this.tocList.add(target);
                    }
                }
            }
        }
    }

    private class TOCItem {
        private String text;
        private String target;

        TOCItem(String text, String url) {
            this.text = text;
            this.target = url.replace('.', '_');
            this.target = this.target.replace('#', '_');
            this.target = this.target.replace('-', '_');
        }

        String getText() {
            return this.text;
        }

        String getTarget() {
            return this.target;
        }
    }
}

