/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import edu.uci.ics.jung.visualization.VisualizationServer;
import ghidra.app.plugin.core.functiongraph.graph.FGComponent;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.EmptyFunctionGraphData;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.FGViewUpdater;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualGraphView;
import ghidra.graph.viewer.layout.LayoutProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.SystemUtilities;
import ghidra.util.task.BusyListener;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.JComponent;

public class FGView
extends VisualGraphView<FGVertex, FGEdge, FunctionGraph> {
    private FGData functionGraphData = new EmptyFunctionGraphData("Uninitialized Function Graph");
    private FGComponent fgComponent;
    private final FGController controller;

    public FGView(FGController controller, JComponent taskMonitorComponent) {
        this.controller = controller;
        this.setSouthComponent(taskMonitorComponent);
        this.setVertexFocusListener(v -> {
            ProgramLocation location = v.getProgramLocation();
            if (location == null) {
                return;
            }
            controller.synchronizeProgramLocationToVertex(location);
        });
    }

    void setViewData(FGData data) {
        this.functionGraphData = data;
        if (!data.hasResults()) {
            this.showErrorView(data.getMessage());
            return;
        }
        this.setGraph((VisualGraph)data.getFunctionGraph());
    }

    protected void installGraphViewer() {
        FGComponent newFgComponent = this.createGraphComponent();
        newFgComponent.setGraphOptions(this.controller.getFunctionGraphOptions());
        this.setGraphComponent(newFgComponent);
        this.fgComponent = newFgComponent;
        this.fgComponent.restoreSettings();
    }

    private FGComponent createGraphComponent() {
        return (FGComponent)((Object)this.getWithBusyCursor(() -> {
            FGComponent newViewer = new FGComponent(this, this.functionGraphData, (LayoutProvider<FGVertex, FGEdge, FunctionGraph>)this.layoutProvider);
            return newViewer;
        }));
    }

    boolean containsLocation(ProgramLocation newLocation) {
        return this.functionGraphData.containsLocation(newLocation);
    }

    void setLocation(ProgramLocation location) {
        if (!this.functionGraphData.containsLocation(location)) {
            return;
        }
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        FGVertex locationVertex = graph.getVertexForAddress(location.getAddress());
        if (locationVertex == null) {
            return;
        }
        FGVertex focusedVertex = (FGVertex)this.getFocusedVertex();
        ProgramLocation currentLocation = locationVertex.getProgramLocation();
        if (locationVertex == focusedVertex && SystemUtilities.isEqual((Object)currentLocation, (Object)location)) {
            this.ensureCursorOnScreen(locationVertex, false);
            return;
        }
        this.fgComponent.setVertexFocused(locationVertex, location);
        this.repaint();
        boolean twinkleVertex = locationVertex != focusedVertex;
        this.ensureCursorOnScreen(locationVertex, twinkleVertex);
    }

    private void ensureCursorOnScreen(FGVertex vertex, boolean twinkle) {
        if (this.fgComponent.isUninitialized()) {
            return;
        }
        BusyListener twinkleAfterAnimationListener = busy -> {
            if (!busy) {
                this.maybeTwinkleVertex(vertex, twinkle);
            }
        };
        GraphViewer primaryViewer = this.getPrimaryGraphViewer();
        Rectangle cursorBounds = vertex.getCursorBounds();
        if (cursorBounds == null) {
            if (GraphViewerUtils.isScaledPastVertexInteractionThreshold((VisualizationServer)primaryViewer)) {
                this.maybeTwinkleVertex(vertex, twinkle);
            }
            return;
        }
        FGViewUpdater updater = this.getViewUpdater();
        updater.ensureVertexAreaVisible(vertex, cursorBounds, twinkleAfterAnimationListener);
    }

    void setSelection(ProgramSelection selection) {
        if (!this.functionGraphData.containsSelection(selection)) {
            if (this.functionGraphData.hasResults()) {
                FunctionGraph graph = this.functionGraphData.getFunctionGraph();
                graph.setProgramSelection(new ProgramSelection());
            }
            return;
        }
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        graph.setProgramSelection(selection);
        this.repaint();
    }

    void setHighlight(ProgramSelection highlight) {
        if (!this.functionGraphData.containsSelection(highlight)) {
            return;
        }
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        graph.setProgramHighlight(highlight);
        this.repaint();
    }

    void setViewMode(FGVertex vertex, boolean maximized) {
        if (maximized) {
            this.setContent(vertex.getMaximizedViewComponent());
        } else {
            FGViewUpdater updater = this.getViewUpdater();
            JComponent component = this.graphComponent.getComponent();
            this.setContent(component);
            updater.moveVertexToCenterWithoutAnimation(vertex);
        }
    }

    FGVertex getEntryPointVertex() {
        FunctionGraph functionGraph = this.functionGraphData.getFunctionGraph();
        Function function = this.functionGraphData.getFunction();
        Address entryPoint = function.getEntryPoint();
        return functionGraph.getVertexForAddress(entryPoint);
    }

    void refreshDisplayWithoutRebuilding() {
        FunctionGraph functionGraph;
        FunctionGraph graph = functionGraph = this.functionGraphData.getFunctionGraph();
        Collection vertices = graph.getVertices();
        for (FGVertex vertex : vertices) {
            vertex.refreshDisplay();
        }
    }

    void refreshDisplayForAddress(Address address) {
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        FGVertex vertex = graph.getVertexForAddress(address);
        if (vertex == null) {
            return;
        }
        vertex.refreshDisplayForAddress(address);
    }

    void setGraphViewStale(boolean isStale) {
        this.fgComponent.setGraphViewStale(isStale);
    }

    public boolean isGraphViewStale() {
        if (this.fgComponent == null) {
            return false;
        }
        return this.fgComponent.isGraphViewStale();
    }

    public void setLayoutProvider(LayoutProvider<FGVertex, FGEdge, FunctionGraph> newLayoutProvider) {
        LayoutProvider oldLayoutProvider = this.layoutProvider;
        super.setLayoutProvider(newLayoutProvider);
        if (this.graphComponent == null) {
            return;
        }
        if (oldLayoutProvider != newLayoutProvider) {
            this.fgComponent.clearLayoutPositionCache();
        }
    }

    void relayout() {
        if (this.fgComponent == null) {
            return;
        }
        FGViewUpdater updater = this.getViewUpdater();
        updater.relayoutGraph(this.controller);
    }

    public FGViewUpdater getViewUpdater() {
        return (FGViewUpdater)super.getViewUpdater();
    }

    void clearUserLayoutSettings() {
        this.fgComponent.clearAllUserLayoutSettings();
    }

    public void broadcastLayoutRefreshNeeded() {
        this.controller.rebuildCurrentDisplay();
    }

    public FGController getController() {
        return this.controller;
    }

    protected void disposeViewer() {
        this.fgComponent = null;
        super.disposeViewer();
    }
}

