/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.LocalComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ShadowedCapability;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.model.ComponentConfigurationIdentifier;
import org.gradle.internal.component.model.VariantResolveMetadata;

public class DefaultLocalComponentMetadataBuilder
implements LocalComponentMetadataBuilder {
    private final LocalConfigurationMetadataBuilder configurationMetadataBuilder;

    public DefaultLocalComponentMetadataBuilder(LocalConfigurationMetadataBuilder configurationMetadataBuilder) {
        this.configurationMetadataBuilder = configurationMetadataBuilder;
    }

    @Override
    public BuildableLocalConfigurationMetadata addConfiguration(final BuildableLocalComponentMetadata metaData, final ConfigurationInternal configuration) {
        BuildableLocalConfigurationMetadata configurationMetadata = this.createConfiguration(metaData, configuration);
        metaData.addDependenciesAndExcludesForConfiguration(configuration, this.configurationMetadataBuilder);
        final ComponentConfigurationIdentifier configurationIdentifier = new ComponentConfigurationIdentifier(metaData.getId(), configuration.getName());
        configuration.collectVariants(new ConfigurationInternal.VariantVisitor(){

            @Override
            public void visitArtifacts(Collection<? extends PublishArtifact> artifacts) {
                metaData.addArtifacts(configuration.getName(), artifacts);
            }

            @Override
            public void visitOwnVariant(DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> artifacts) {
                metaData.addVariant(configuration.getName(), configuration.getName(), configurationIdentifier, displayName, attributes, artifacts);
            }

            @Override
            public void visitChildVariant(String name, DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> artifacts) {
                metaData.addVariant(configuration.getName(), configuration.getName() + "-" + name, new NestedVariantIdentifier(configurationIdentifier, name), displayName, attributes, artifacts);
            }
        });
        return configurationMetadata;
    }

    private BuildableLocalConfigurationMetadata createConfiguration(BuildableLocalComponentMetadata metaData, ConfigurationInternal configuration) {
        configuration.preventFromFurtherMutation();
        ImmutableSet<String> hierarchy = Configurations.getNames(configuration.getHierarchy());
        ImmutableSet<String> extendsFrom = Configurations.getNames(configuration.getExtendsFrom());
        ImmutableCapabilities capabilities = DefaultLocalComponentMetadataBuilder.asImmutable(Configurations.collectCapabilities(configuration, Sets.newHashSet(), Sets.newHashSet()));
        return metaData.addConfiguration(configuration.getName(), configuration.getDescription(), (Set<String>)extendsFrom, hierarchy, configuration.isVisible(), configuration.isTransitive(), configuration.getAttributes().asImmutable(), configuration.isCanBeConsumed(), configuration.getConsumptionAlternatives(), configuration.isCanBeResolved(), capabilities);
    }

    private static ImmutableCapabilities asImmutable(Collection<? extends Capability> descriptors) {
        if (descriptors.isEmpty()) {
            return ImmutableCapabilities.EMPTY;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Capability capability : descriptors) {
            if (capability instanceof ImmutableCapability) {
                builder.add((Object)((ImmutableCapability)capability));
                continue;
            }
            if (capability instanceof ShadowedCapability) {
                builder.add((Object)((ShadowedCapability)capability));
                continue;
            }
            builder.add((Object)new ImmutableCapability(capability.getGroup(), capability.getName(), capability.getVersion()));
        }
        return ImmutableCapabilities.of((List<? extends Capability>)builder.build());
    }

    private static class NestedVariantIdentifier
    implements VariantResolveMetadata.Identifier {
        private final VariantResolveMetadata.Identifier parent;
        private final String name;

        public NestedVariantIdentifier(VariantResolveMetadata.Identifier parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public int hashCode() {
            return this.parent.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NestedVariantIdentifier other = (NestedVariantIdentifier)obj;
            return this.parent.equals(other.parent) && this.name.equals(other.name);
        }
    }
}

