/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.config;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metaconfig.ConfigException;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.service.configuration.ConfigurationService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/config/ConfigurationServiceConfigSource;", "Lorg/jitsi/metaconfig/ConfigSource;", "name", "", "config", "Lorg/jitsi/service/configuration/ConfigurationService;", "(Ljava/lang/String;Lorg/jitsi/service/configuration/ConfigurationService;)V", "getName", "()Ljava/lang/String;", "getterFor", "Lkotlin/Function1;", "", "type", "Lkotlin/reflect/KType;", "getStringOrThrow", "key", "jicoco-config"})
public final class ConfigurationServiceConfigSource
implements ConfigSource {
    @NotNull
    private final String name;
    @NotNull
    private final ConfigurationService config;

    public ConfigurationServiceConfigSource(@NotNull String name, @NotNull ConfigurationService config) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(config, "config");
        this.name = name;
        this.config = config;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Function1<String, Object> getterFor(@NotNull KType type2) {
        Function1 function1;
        Intrinsics.checkNotNullParameter(type2, "type");
        KType kType = type2;
        if (Intrinsics.areEqual(kType, Reflection.typeOf(String.class))) {
            function1 = new Function1<String, Object>(this){
                final /* synthetic */ ConfigurationServiceConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return ConfigurationServiceConfigSource.access$getStringOrThrow(this.this$0, ConfigurationServiceConfigSource.access$getConfig$p(this.this$0), key);
                }
            };
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Boolean.TYPE))) {
            function1 = new Function1<String, Object>(this){
                final /* synthetic */ ConfigurationServiceConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return Boolean.parseBoolean(ConfigurationServiceConfigSource.access$getStringOrThrow(this.this$0, ConfigurationServiceConfigSource.access$getConfig$p(this.this$0), key));
                }
            };
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Double.TYPE))) {
            function1 = new Function1<String, Object>(this){
                final /* synthetic */ ConfigurationServiceConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return Double.parseDouble(ConfigurationServiceConfigSource.access$getStringOrThrow(this.this$0, ConfigurationServiceConfigSource.access$getConfig$p(this.this$0), key));
                }
            };
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Integer.TYPE))) {
            function1 = new Function1<String, Object>(this){
                final /* synthetic */ ConfigurationServiceConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return Integer.parseInt(ConfigurationServiceConfigSource.access$getStringOrThrow(this.this$0, ConfigurationServiceConfigSource.access$getConfig$p(this.this$0), key));
                }
            };
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Long.TYPE))) {
            function1 = new Function1<String, Object>(this){
                final /* synthetic */ ConfigurationServiceConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return Long.parseLong(ConfigurationServiceConfigSource.access$getStringOrThrow(this.this$0, ConfigurationServiceConfigSource.access$getConfig$p(this.this$0), key));
                }
            };
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Map.class, KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), KTypeProjection.Companion.invariant(Reflection.typeOf(String.class))))) {
            function1 = new Function1<String, Object>(this){
                final /* synthetic */ ConfigurationServiceConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Map props = new LinkedHashMap<K, V>();
                    for (String propName : ConfigurationServiceConfigSource.access$getConfig$p(this.this$0).getPropertyNamesByPrefix(key, false)) {
                        String string;
                        Map map = props;
                        Intrinsics.checkNotNullExpressionValue(propName, "propName");
                        String string2 = propName;
                        Intrinsics.checkNotNullExpressionValue(ConfigurationServiceConfigSource.access$getConfig$p(this.this$0).getString(propName), "config.getString(propName)");
                        map.put(string2, string);
                    }
                    return props;
                }
            };
        } else {
            throw new ConfigException.UnsupportedType("Type " + type2 + " not supported in source '" + this.getName() + "'");
        }
        return function1;
    }

    private final String getStringOrThrow(ConfigurationService $this$getStringOrThrow, String key) {
        String string = $this$getStringOrThrow.getString(key);
        if (string == null) {
            throw new ConfigException.UnableToRetrieve.NotFound("Key '" + key + "' not found in source '" + this.getName() + "'");
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        return ConfigSource.DefaultImpls.getDescription(this);
    }

    public static final /* synthetic */ String access$getStringOrThrow(ConfigurationServiceConfigSource $this, ConfigurationService $receiver, String key) {
        return $this.getStringOrThrow($receiver, key);
    }

    public static final /* synthetic */ ConfigurationService access$getConfig$p(ConfigurationServiceConfigSource $this) {
        return $this.config;
    }
}

