/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.ice;

import java.io.IOException;
import java.util.List;
import org.ice4j.ice.harvest.AbstractUdpListener;
import org.ice4j.ice.harvest.SinglePortUdpHarvester;
import org.ice4j.ice.harvest.TcpHarvester;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.ice.IceConfig;

public class Harvesters {
    private static boolean staticConfigurationInitialized = false;
    private static boolean healthy = true;
    private static final Logger classLogger = new LoggerImpl(Harvesters.class.getName());
    public static TcpHarvester tcpHarvester = null;
    public static List<SinglePortUdpHarvester> singlePortHarvesters = null;

    public static boolean isHealthy() {
        return healthy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeStaticConfiguration() {
        Class<Harvesters> clazz = Harvesters.class;
        synchronized (Harvesters.class) {
            if (staticConfigurationInitialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            staticConfigurationInitialized = true;
            singlePortHarvesters = SinglePortUdpHarvester.createHarvesters(IceConfig.config.getPort());
            if (singlePortHarvesters.isEmpty()) {
                singlePortHarvesters = null;
                classLogger.info("No single-port harvesters created.");
            }
            boolean bl = healthy = singlePortHarvesters != null;
            if (IceConfig.config.getTcpEnabled()) {
                int port2 = IceConfig.config.getTcpPort();
                try {
                    tcpHarvester = new TcpHarvester(port2, IceConfig.config.getIceSslTcp());
                    classLogger.info("Initialized TCP harvester on port " + port2 + ", ssltcp=" + IceConfig.config.getIceSslTcp());
                }
                catch (IOException ioe) {
                    classLogger.warn("Failed to initialize TCP harvester on port " + port2);
                }
                Integer mappedPort = IceConfig.config.getTcpMappedPort();
                if (mappedPort != null) {
                    tcpHarvester.addMappedPort(mappedPort);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeStaticConfiguration() {
        Class<Harvesters> clazz = Harvesters.class;
        synchronized (Harvesters.class) {
            if (!staticConfigurationInitialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            staticConfigurationInitialized = false;
            if (singlePortHarvesters != null) {
                singlePortHarvesters.forEach(AbstractUdpListener::close);
                singlePortHarvesters = null;
            }
            if (tcpHarvester != null) {
                tcpHarvester.close();
                tcpHarvester = null;
            }
            healthy = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

